// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The approval stage.
 */
@Fluent
public final class ApprovalStage implements JsonSerializable<ApprovalStage> {
    /*
     * The time in days when approval request would be timed out
     */
    private Integer approvalStageTimeOutInDays;

    /*
     * Determines whether approver need to provide justification for his decision.
     */
    private Boolean isApproverJustificationRequired;

    /*
     * The time in minutes when the approval request would be escalated if the primary approver does not approve
     */
    private Integer escalationTimeInMinutes;

    /*
     * The primary approver of the request.
     */
    private List<UserSet> primaryApprovers;

    /*
     * The value determine whether escalation feature is enabled.
     */
    private Boolean isEscalationEnabled;

    /*
     * The escalation approver of the request.
     */
    private List<UserSet> escalationApprovers;

    /**
     * Creates an instance of ApprovalStage class.
     */
    public ApprovalStage() {
    }

    /**
     * Get the approvalStageTimeOutInDays property: The time in days when approval request would be timed out.
     * 
     * @return the approvalStageTimeOutInDays value.
     */
    public Integer approvalStageTimeOutInDays() {
        return this.approvalStageTimeOutInDays;
    }

    /**
     * Set the approvalStageTimeOutInDays property: The time in days when approval request would be timed out.
     * 
     * @param approvalStageTimeOutInDays the approvalStageTimeOutInDays value to set.
     * @return the ApprovalStage object itself.
     */
    public ApprovalStage withApprovalStageTimeOutInDays(Integer approvalStageTimeOutInDays) {
        this.approvalStageTimeOutInDays = approvalStageTimeOutInDays;
        return this;
    }

    /**
     * Get the isApproverJustificationRequired property: Determines whether approver need to provide justification for
     * his decision.
     * 
     * @return the isApproverJustificationRequired value.
     */
    public Boolean isApproverJustificationRequired() {
        return this.isApproverJustificationRequired;
    }

    /**
     * Set the isApproverJustificationRequired property: Determines whether approver need to provide justification for
     * his decision.
     * 
     * @param isApproverJustificationRequired the isApproverJustificationRequired value to set.
     * @return the ApprovalStage object itself.
     */
    public ApprovalStage withIsApproverJustificationRequired(Boolean isApproverJustificationRequired) {
        this.isApproverJustificationRequired = isApproverJustificationRequired;
        return this;
    }

    /**
     * Get the escalationTimeInMinutes property: The time in minutes when the approval request would be escalated if the
     * primary approver does not approve.
     * 
     * @return the escalationTimeInMinutes value.
     */
    public Integer escalationTimeInMinutes() {
        return this.escalationTimeInMinutes;
    }

    /**
     * Set the escalationTimeInMinutes property: The time in minutes when the approval request would be escalated if the
     * primary approver does not approve.
     * 
     * @param escalationTimeInMinutes the escalationTimeInMinutes value to set.
     * @return the ApprovalStage object itself.
     */
    public ApprovalStage withEscalationTimeInMinutes(Integer escalationTimeInMinutes) {
        this.escalationTimeInMinutes = escalationTimeInMinutes;
        return this;
    }

    /**
     * Get the primaryApprovers property: The primary approver of the request.
     * 
     * @return the primaryApprovers value.
     */
    public List<UserSet> primaryApprovers() {
        return this.primaryApprovers;
    }

    /**
     * Set the primaryApprovers property: The primary approver of the request.
     * 
     * @param primaryApprovers the primaryApprovers value to set.
     * @return the ApprovalStage object itself.
     */
    public ApprovalStage withPrimaryApprovers(List<UserSet> primaryApprovers) {
        this.primaryApprovers = primaryApprovers;
        return this;
    }

    /**
     * Get the isEscalationEnabled property: The value determine whether escalation feature is enabled.
     * 
     * @return the isEscalationEnabled value.
     */
    public Boolean isEscalationEnabled() {
        return this.isEscalationEnabled;
    }

    /**
     * Set the isEscalationEnabled property: The value determine whether escalation feature is enabled.
     * 
     * @param isEscalationEnabled the isEscalationEnabled value to set.
     * @return the ApprovalStage object itself.
     */
    public ApprovalStage withIsEscalationEnabled(Boolean isEscalationEnabled) {
        this.isEscalationEnabled = isEscalationEnabled;
        return this;
    }

    /**
     * Get the escalationApprovers property: The escalation approver of the request.
     * 
     * @return the escalationApprovers value.
     */
    public List<UserSet> escalationApprovers() {
        return this.escalationApprovers;
    }

    /**
     * Set the escalationApprovers property: The escalation approver of the request.
     * 
     * @param escalationApprovers the escalationApprovers value to set.
     * @return the ApprovalStage object itself.
     */
    public ApprovalStage withEscalationApprovers(List<UserSet> escalationApprovers) {
        this.escalationApprovers = escalationApprovers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (primaryApprovers() != null) {
            primaryApprovers().forEach(e -> e.validate());
        }
        if (escalationApprovers() != null) {
            escalationApprovers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("approvalStageTimeOutInDays", this.approvalStageTimeOutInDays);
        jsonWriter.writeBooleanField("isApproverJustificationRequired", this.isApproverJustificationRequired);
        jsonWriter.writeNumberField("escalationTimeInMinutes", this.escalationTimeInMinutes);
        jsonWriter.writeArrayField("primaryApprovers", this.primaryApprovers,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("isEscalationEnabled", this.isEscalationEnabled);
        jsonWriter.writeArrayField("escalationApprovers", this.escalationApprovers,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApprovalStage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApprovalStage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApprovalStage.
     */
    public static ApprovalStage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApprovalStage deserializedApprovalStage = new ApprovalStage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("approvalStageTimeOutInDays".equals(fieldName)) {
                    deserializedApprovalStage.approvalStageTimeOutInDays = reader.getNullable(JsonReader::getInt);
                } else if ("isApproverJustificationRequired".equals(fieldName)) {
                    deserializedApprovalStage.isApproverJustificationRequired
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("escalationTimeInMinutes".equals(fieldName)) {
                    deserializedApprovalStage.escalationTimeInMinutes = reader.getNullable(JsonReader::getInt);
                } else if ("primaryApprovers".equals(fieldName)) {
                    List<UserSet> primaryApprovers = reader.readArray(reader1 -> UserSet.fromJson(reader1));
                    deserializedApprovalStage.primaryApprovers = primaryApprovers;
                } else if ("isEscalationEnabled".equals(fieldName)) {
                    deserializedApprovalStage.isEscalationEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("escalationApprovers".equals(fieldName)) {
                    List<UserSet> escalationApprovers = reader.readArray(reader1 -> UserSet.fromJson(reader1));
                    deserializedApprovalStage.escalationApprovers = escalationApprovers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApprovalStage;
        });
    }
}
