// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * trending.
 */
@Fluent
public final class MicrosoftGraphTrending extends MicrosoftGraphEntity {
    /*
     * The lastModifiedDateTime property.
     */
    private OffsetDateTime lastModifiedDateTime;

    /*
     * resourceReference
     */
    private MicrosoftGraphResourceReference resourceReference;

    /*
     * resourceVisualization
     */
    private MicrosoftGraphResourceVisualization resourceVisualization;

    /*
     * Value indicating how much the document is currently trending. The larger the number, the more the document is
     * currently trending around the user (the more relevant it is). Returned documents are sorted by this value.
     */
    private Double weight;

    /*
     * entity
     */
    private MicrosoftGraphEntity resource;

    /*
     * trending
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTrending class.
     */
    public MicrosoftGraphTrending() {
    }

    /**
     * Get the lastModifiedDateTime property: The lastModifiedDateTime property.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: The lastModifiedDateTime property.
     * 
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphTrending object itself.
     */
    public MicrosoftGraphTrending withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the resourceReference property: resourceReference.
     * 
     * @return the resourceReference value.
     */
    public MicrosoftGraphResourceReference resourceReference() {
        return this.resourceReference;
    }

    /**
     * Set the resourceReference property: resourceReference.
     * 
     * @param resourceReference the resourceReference value to set.
     * @return the MicrosoftGraphTrending object itself.
     */
    public MicrosoftGraphTrending withResourceReference(MicrosoftGraphResourceReference resourceReference) {
        this.resourceReference = resourceReference;
        return this;
    }

    /**
     * Get the resourceVisualization property: resourceVisualization.
     * 
     * @return the resourceVisualization value.
     */
    public MicrosoftGraphResourceVisualization resourceVisualization() {
        return this.resourceVisualization;
    }

    /**
     * Set the resourceVisualization property: resourceVisualization.
     * 
     * @param resourceVisualization the resourceVisualization value to set.
     * @return the MicrosoftGraphTrending object itself.
     */
    public MicrosoftGraphTrending withResourceVisualization(MicrosoftGraphResourceVisualization resourceVisualization) {
        this.resourceVisualization = resourceVisualization;
        return this;
    }

    /**
     * Get the weight property: Value indicating how much the document is currently trending. The larger the number, the
     * more the document is currently trending around the user (the more relevant it is). Returned documents are sorted
     * by this value.
     * 
     * @return the weight value.
     */
    public Double weight() {
        return this.weight;
    }

    /**
     * Set the weight property: Value indicating how much the document is currently trending. The larger the number, the
     * more the document is currently trending around the user (the more relevant it is). Returned documents are sorted
     * by this value.
     * 
     * @param weight the weight value to set.
     * @return the MicrosoftGraphTrending object itself.
     */
    public MicrosoftGraphTrending withWeight(Double weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Get the resource property: entity.
     * 
     * @return the resource value.
     */
    public MicrosoftGraphEntity resource() {
        return this.resource;
    }

    /**
     * Set the resource property: entity.
     * 
     * @param resource the resource value to set.
     * @return the MicrosoftGraphTrending object itself.
     */
    public MicrosoftGraphTrending withResource(MicrosoftGraphEntity resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the additionalProperties property: trending.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: trending.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTrending object itself.
     */
    public MicrosoftGraphTrending withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTrending withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (resourceReference() != null) {
            resourceReference().validate();
        }
        if (resourceVisualization() != null) {
            resourceVisualization().validate();
        }
        if (resource() != null) {
            resource().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("lastModifiedDateTime",
            this.lastModifiedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeJsonField("resourceReference", this.resourceReference);
        jsonWriter.writeJsonField("resourceVisualization", this.resourceVisualization);
        jsonWriter.writeNumberField("weight", this.weight);
        jsonWriter.writeJsonField("resource", this.resource);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTrending from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTrending if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTrending.
     */
    public static MicrosoftGraphTrending fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTrending deserializedMicrosoftGraphTrending = new MicrosoftGraphTrending();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.withId(reader.getString());
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.lastModifiedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("resourceReference".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.resourceReference
                        = MicrosoftGraphResourceReference.fromJson(reader);
                } else if ("resourceVisualization".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.resourceVisualization
                        = MicrosoftGraphResourceVisualization.fromJson(reader);
                } else if ("weight".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.weight = reader.getNullable(JsonReader::getDouble);
                } else if ("resource".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.resource = MicrosoftGraphEntity.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTrending.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTrending;
        });
    }
}
