// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * specialFolder.
 */
@Fluent
public final class MicrosoftGraphSpecialFolder implements JsonSerializable<MicrosoftGraphSpecialFolder> {
    /*
     * The unique identifier for this item in the /drive/special collection
     */
    private String name;

    /*
     * specialFolder
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSpecialFolder class.
     */
    public MicrosoftGraphSpecialFolder() {
    }

    /**
     * Get the name property: The unique identifier for this item in the /drive/special collection.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The unique identifier for this item in the /drive/special collection.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphSpecialFolder object itself.
     */
    public MicrosoftGraphSpecialFolder withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the additionalProperties property: specialFolder.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: specialFolder.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSpecialFolder object itself.
     */
    public MicrosoftGraphSpecialFolder withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSpecialFolder from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSpecialFolder if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSpecialFolder.
     */
    public static MicrosoftGraphSpecialFolder fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSpecialFolder deserializedMicrosoftGraphSpecialFolder = new MicrosoftGraphSpecialFolder();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphSpecialFolder.name = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSpecialFolder.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSpecialFolder;
        });
    }
}
