// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * officeGraphInsights.
 */
@Fluent
public final class MicrosoftGraphOfficeGraphInsights extends MicrosoftGraphEntity {
    /*
     * Calculated relationship identifying documents shared with or by the user. This includes URLs, file attachments,
     * and reference attachments to OneDrive for Business and SharePoint files found in Outlook messages and meetings.
     * This also includes URLs and reference attachments to Teams conversations. Ordered by recency of share.
     */
    private List<MicrosoftGraphSharedInsight> shared;

    /*
     * Calculated relationship identifying documents trending around a user. Trending documents are calculated based on
     * activity of the user's closest network of people and include files stored in OneDrive for Business and
     * SharePoint. Trending insights help the user to discover potentially useful content that the user has access to,
     * but has never viewed before.
     */
    private List<MicrosoftGraphTrending> trending;

    /*
     * Calculated relationship identifying the latest documents viewed or modified by a user, including OneDrive for
     * Business and SharePoint documents, ranked by recency of use.
     */
    private List<MicrosoftGraphUsedInsight> used;

    /*
     * officeGraphInsights
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOfficeGraphInsights class.
     */
    public MicrosoftGraphOfficeGraphInsights() {
    }

    /**
     * Get the shared property: Calculated relationship identifying documents shared with or by the user. This includes
     * URLs, file attachments, and reference attachments to OneDrive for Business and SharePoint files found in Outlook
     * messages and meetings. This also includes URLs and reference attachments to Teams conversations. Ordered by
     * recency of share.
     * 
     * @return the shared value.
     */
    public List<MicrosoftGraphSharedInsight> shared() {
        return this.shared;
    }

    /**
     * Set the shared property: Calculated relationship identifying documents shared with or by the user. This includes
     * URLs, file attachments, and reference attachments to OneDrive for Business and SharePoint files found in Outlook
     * messages and meetings. This also includes URLs and reference attachments to Teams conversations. Ordered by
     * recency of share.
     * 
     * @param shared the shared value to set.
     * @return the MicrosoftGraphOfficeGraphInsights object itself.
     */
    public MicrosoftGraphOfficeGraphInsights withShared(List<MicrosoftGraphSharedInsight> shared) {
        this.shared = shared;
        return this;
    }

    /**
     * Get the trending property: Calculated relationship identifying documents trending around a user. Trending
     * documents are calculated based on activity of the user's closest network of people and include files stored in
     * OneDrive for Business and SharePoint. Trending insights help the user to discover potentially useful content that
     * the user has access to, but has never viewed before.
     * 
     * @return the trending value.
     */
    public List<MicrosoftGraphTrending> trending() {
        return this.trending;
    }

    /**
     * Set the trending property: Calculated relationship identifying documents trending around a user. Trending
     * documents are calculated based on activity of the user's closest network of people and include files stored in
     * OneDrive for Business and SharePoint. Trending insights help the user to discover potentially useful content that
     * the user has access to, but has never viewed before.
     * 
     * @param trending the trending value to set.
     * @return the MicrosoftGraphOfficeGraphInsights object itself.
     */
    public MicrosoftGraphOfficeGraphInsights withTrending(List<MicrosoftGraphTrending> trending) {
        this.trending = trending;
        return this;
    }

    /**
     * Get the used property: Calculated relationship identifying the latest documents viewed or modified by a user,
     * including OneDrive for Business and SharePoint documents, ranked by recency of use.
     * 
     * @return the used value.
     */
    public List<MicrosoftGraphUsedInsight> used() {
        return this.used;
    }

    /**
     * Set the used property: Calculated relationship identifying the latest documents viewed or modified by a user,
     * including OneDrive for Business and SharePoint documents, ranked by recency of use.
     * 
     * @param used the used value to set.
     * @return the MicrosoftGraphOfficeGraphInsights object itself.
     */
    public MicrosoftGraphOfficeGraphInsights withUsed(List<MicrosoftGraphUsedInsight> used) {
        this.used = used;
        return this;
    }

    /**
     * Get the additionalProperties property: officeGraphInsights.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: officeGraphInsights.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOfficeGraphInsights object itself.
     */
    public MicrosoftGraphOfficeGraphInsights withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOfficeGraphInsights withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (shared() != null) {
            shared().forEach(e -> e.validate());
        }
        if (trending() != null) {
            trending().forEach(e -> e.validate());
        }
        if (used() != null) {
            used().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("shared", this.shared, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("trending", this.trending, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("used", this.used, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOfficeGraphInsights from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOfficeGraphInsights if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOfficeGraphInsights.
     */
    public static MicrosoftGraphOfficeGraphInsights fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOfficeGraphInsights deserializedMicrosoftGraphOfficeGraphInsights
                = new MicrosoftGraphOfficeGraphInsights();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOfficeGraphInsights.withId(reader.getString());
                } else if ("shared".equals(fieldName)) {
                    List<MicrosoftGraphSharedInsight> shared
                        = reader.readArray(reader1 -> MicrosoftGraphSharedInsight.fromJson(reader1));
                    deserializedMicrosoftGraphOfficeGraphInsights.shared = shared;
                } else if ("trending".equals(fieldName)) {
                    List<MicrosoftGraphTrending> trending
                        = reader.readArray(reader1 -> MicrosoftGraphTrending.fromJson(reader1));
                    deserializedMicrosoftGraphOfficeGraphInsights.trending = trending;
                } else if ("used".equals(fieldName)) {
                    List<MicrosoftGraphUsedInsight> used
                        = reader.readArray(reader1 -> MicrosoftGraphUsedInsight.fromJson(reader1));
                    deserializedMicrosoftGraphOfficeGraphInsights.used = used;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOfficeGraphInsights.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOfficeGraphInsights;
        });
    }
}
