// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details of the resource scope.
 */
@Fluent
public final class PolicyAssignmentPropertiesScope implements JsonSerializable<PolicyAssignmentPropertiesScope> {
    /*
     * Scope id of the resource
     */
    private String id;

    /*
     * Display name of the resource
     */
    private String displayName;

    /*
     * Type of the resource
     */
    private String type;

    /**
     * Creates an instance of PolicyAssignmentPropertiesScope class.
     */
    public PolicyAssignmentPropertiesScope() {
    }

    /**
     * Get the id property: Scope id of the resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Scope id of the resource.
     * 
     * @param id the id value to set.
     * @return the PolicyAssignmentPropertiesScope object itself.
     */
    public PolicyAssignmentPropertiesScope withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the displayName property: Display name of the resource.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display name of the resource.
     * 
     * @param displayName the displayName value to set.
     * @return the PolicyAssignmentPropertiesScope object itself.
     */
    public PolicyAssignmentPropertiesScope withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the type property: Type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the resource.
     * 
     * @param type the type value to set.
     * @return the PolicyAssignmentPropertiesScope object itself.
     */
    public PolicyAssignmentPropertiesScope withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyAssignmentPropertiesScope from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyAssignmentPropertiesScope if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyAssignmentPropertiesScope.
     */
    public static PolicyAssignmentPropertiesScope fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyAssignmentPropertiesScope deserializedPolicyAssignmentPropertiesScope
                = new PolicyAssignmentPropertiesScope();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPolicyAssignmentPropertiesScope.id = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedPolicyAssignmentPropertiesScope.displayName = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPolicyAssignmentPropertiesScope.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyAssignmentPropertiesScope;
        });
    }
}
