// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * schedule.
 */
@Fluent
public final class MicrosoftGraphSchedule extends MicrosoftGraphEntity {
    /*
     * Indicates whether the schedule is enabled for the team. Required.
     */
    private Boolean enabled;

    /*
     * Indicates whether offer shift requests are enabled for the schedule.
     */
    private Boolean offerShiftRequestsEnabled;

    /*
     * Indicates whether open shifts are enabled for the schedule.
     */
    private Boolean openShiftsEnabled;

    /*
     * operationStatus
     */
    private MicrosoftGraphOperationStatus provisionStatus;

    /*
     * Additional information about why schedule provisioning failed.
     */
    private String provisionStatusCode;

    /*
     * Indicates whether swap shifts requests are enabled for the schedule.
     */
    private Boolean swapShiftsRequestsEnabled;

    /*
     * Indicates whether time clock is enabled for the schedule.
     */
    private Boolean timeClockEnabled;

    /*
     * Indicates whether time off requests are enabled for the schedule.
     */
    private Boolean timeOffRequestsEnabled;

    /*
     * Indicates the time zone of the schedule team using tz database format. Required.
     */
    private String timeZone;

    /*
     * The workforceIntegrationIds property.
     */
    private List<String> workforceIntegrationIds;

    /*
     * The offerShiftRequests property.
     */
    private List<MicrosoftGraphOfferShiftRequest> offerShiftRequests;

    /*
     * The openShiftChangeRequests property.
     */
    private List<MicrosoftGraphOpenShiftChangeRequest> openShiftChangeRequests;

    /*
     * The openShifts property.
     */
    private List<MicrosoftGraphOpenShift> openShifts;

    /*
     * The logical grouping of users in the schedule (usually by role).
     */
    private List<MicrosoftGraphSchedulingGroup> schedulingGroups;

    /*
     * The shifts in the schedule.
     */
    private List<MicrosoftGraphShift> shifts;

    /*
     * The swapShiftsChangeRequests property.
     */
    private List<MicrosoftGraphSwapShiftsChangeRequest> swapShiftsChangeRequests;

    /*
     * The set of reasons for a time off in the schedule.
     */
    private List<MicrosoftGraphTimeOffReason> timeOffReasons;

    /*
     * The timeOffRequests property.
     */
    private List<MicrosoftGraphTimeOffRequest> timeOffRequests;

    /*
     * The instances of times off in the schedule.
     */
    private List<MicrosoftGraphTimeOff> timesOff;

    /*
     * schedule
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSchedule class.
     */
    public MicrosoftGraphSchedule() {
    }

    /**
     * Get the enabled property: Indicates whether the schedule is enabled for the team. Required.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether the schedule is enabled for the team. Required.
     * 
     * @param enabled the enabled value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the offerShiftRequestsEnabled property: Indicates whether offer shift requests are enabled for the schedule.
     * 
     * @return the offerShiftRequestsEnabled value.
     */
    public Boolean offerShiftRequestsEnabled() {
        return this.offerShiftRequestsEnabled;
    }

    /**
     * Set the offerShiftRequestsEnabled property: Indicates whether offer shift requests are enabled for the schedule.
     * 
     * @param offerShiftRequestsEnabled the offerShiftRequestsEnabled value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withOfferShiftRequestsEnabled(Boolean offerShiftRequestsEnabled) {
        this.offerShiftRequestsEnabled = offerShiftRequestsEnabled;
        return this;
    }

    /**
     * Get the openShiftsEnabled property: Indicates whether open shifts are enabled for the schedule.
     * 
     * @return the openShiftsEnabled value.
     */
    public Boolean openShiftsEnabled() {
        return this.openShiftsEnabled;
    }

    /**
     * Set the openShiftsEnabled property: Indicates whether open shifts are enabled for the schedule.
     * 
     * @param openShiftsEnabled the openShiftsEnabled value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withOpenShiftsEnabled(Boolean openShiftsEnabled) {
        this.openShiftsEnabled = openShiftsEnabled;
        return this;
    }

    /**
     * Get the provisionStatus property: operationStatus.
     * 
     * @return the provisionStatus value.
     */
    public MicrosoftGraphOperationStatus provisionStatus() {
        return this.provisionStatus;
    }

    /**
     * Set the provisionStatus property: operationStatus.
     * 
     * @param provisionStatus the provisionStatus value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withProvisionStatus(MicrosoftGraphOperationStatus provisionStatus) {
        this.provisionStatus = provisionStatus;
        return this;
    }

    /**
     * Get the provisionStatusCode property: Additional information about why schedule provisioning failed.
     * 
     * @return the provisionStatusCode value.
     */
    public String provisionStatusCode() {
        return this.provisionStatusCode;
    }

    /**
     * Set the provisionStatusCode property: Additional information about why schedule provisioning failed.
     * 
     * @param provisionStatusCode the provisionStatusCode value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withProvisionStatusCode(String provisionStatusCode) {
        this.provisionStatusCode = provisionStatusCode;
        return this;
    }

    /**
     * Get the swapShiftsRequestsEnabled property: Indicates whether swap shifts requests are enabled for the schedule.
     * 
     * @return the swapShiftsRequestsEnabled value.
     */
    public Boolean swapShiftsRequestsEnabled() {
        return this.swapShiftsRequestsEnabled;
    }

    /**
     * Set the swapShiftsRequestsEnabled property: Indicates whether swap shifts requests are enabled for the schedule.
     * 
     * @param swapShiftsRequestsEnabled the swapShiftsRequestsEnabled value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withSwapShiftsRequestsEnabled(Boolean swapShiftsRequestsEnabled) {
        this.swapShiftsRequestsEnabled = swapShiftsRequestsEnabled;
        return this;
    }

    /**
     * Get the timeClockEnabled property: Indicates whether time clock is enabled for the schedule.
     * 
     * @return the timeClockEnabled value.
     */
    public Boolean timeClockEnabled() {
        return this.timeClockEnabled;
    }

    /**
     * Set the timeClockEnabled property: Indicates whether time clock is enabled for the schedule.
     * 
     * @param timeClockEnabled the timeClockEnabled value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withTimeClockEnabled(Boolean timeClockEnabled) {
        this.timeClockEnabled = timeClockEnabled;
        return this;
    }

    /**
     * Get the timeOffRequestsEnabled property: Indicates whether time off requests are enabled for the schedule.
     * 
     * @return the timeOffRequestsEnabled value.
     */
    public Boolean timeOffRequestsEnabled() {
        return this.timeOffRequestsEnabled;
    }

    /**
     * Set the timeOffRequestsEnabled property: Indicates whether time off requests are enabled for the schedule.
     * 
     * @param timeOffRequestsEnabled the timeOffRequestsEnabled value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withTimeOffRequestsEnabled(Boolean timeOffRequestsEnabled) {
        this.timeOffRequestsEnabled = timeOffRequestsEnabled;
        return this;
    }

    /**
     * Get the timeZone property: Indicates the time zone of the schedule team using tz database format. Required.
     * 
     * @return the timeZone value.
     */
    public String timeZone() {
        return this.timeZone;
    }

    /**
     * Set the timeZone property: Indicates the time zone of the schedule team using tz database format. Required.
     * 
     * @param timeZone the timeZone value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    /**
     * Get the workforceIntegrationIds property: The workforceIntegrationIds property.
     * 
     * @return the workforceIntegrationIds value.
     */
    public List<String> workforceIntegrationIds() {
        return this.workforceIntegrationIds;
    }

    /**
     * Set the workforceIntegrationIds property: The workforceIntegrationIds property.
     * 
     * @param workforceIntegrationIds the workforceIntegrationIds value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withWorkforceIntegrationIds(List<String> workforceIntegrationIds) {
        this.workforceIntegrationIds = workforceIntegrationIds;
        return this;
    }

    /**
     * Get the offerShiftRequests property: The offerShiftRequests property.
     * 
     * @return the offerShiftRequests value.
     */
    public List<MicrosoftGraphOfferShiftRequest> offerShiftRequests() {
        return this.offerShiftRequests;
    }

    /**
     * Set the offerShiftRequests property: The offerShiftRequests property.
     * 
     * @param offerShiftRequests the offerShiftRequests value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withOfferShiftRequests(List<MicrosoftGraphOfferShiftRequest> offerShiftRequests) {
        this.offerShiftRequests = offerShiftRequests;
        return this;
    }

    /**
     * Get the openShiftChangeRequests property: The openShiftChangeRequests property.
     * 
     * @return the openShiftChangeRequests value.
     */
    public List<MicrosoftGraphOpenShiftChangeRequest> openShiftChangeRequests() {
        return this.openShiftChangeRequests;
    }

    /**
     * Set the openShiftChangeRequests property: The openShiftChangeRequests property.
     * 
     * @param openShiftChangeRequests the openShiftChangeRequests value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule
        withOpenShiftChangeRequests(List<MicrosoftGraphOpenShiftChangeRequest> openShiftChangeRequests) {
        this.openShiftChangeRequests = openShiftChangeRequests;
        return this;
    }

    /**
     * Get the openShifts property: The openShifts property.
     * 
     * @return the openShifts value.
     */
    public List<MicrosoftGraphOpenShift> openShifts() {
        return this.openShifts;
    }

    /**
     * Set the openShifts property: The openShifts property.
     * 
     * @param openShifts the openShifts value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withOpenShifts(List<MicrosoftGraphOpenShift> openShifts) {
        this.openShifts = openShifts;
        return this;
    }

    /**
     * Get the schedulingGroups property: The logical grouping of users in the schedule (usually by role).
     * 
     * @return the schedulingGroups value.
     */
    public List<MicrosoftGraphSchedulingGroup> schedulingGroups() {
        return this.schedulingGroups;
    }

    /**
     * Set the schedulingGroups property: The logical grouping of users in the schedule (usually by role).
     * 
     * @param schedulingGroups the schedulingGroups value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withSchedulingGroups(List<MicrosoftGraphSchedulingGroup> schedulingGroups) {
        this.schedulingGroups = schedulingGroups;
        return this;
    }

    /**
     * Get the shifts property: The shifts in the schedule.
     * 
     * @return the shifts value.
     */
    public List<MicrosoftGraphShift> shifts() {
        return this.shifts;
    }

    /**
     * Set the shifts property: The shifts in the schedule.
     * 
     * @param shifts the shifts value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withShifts(List<MicrosoftGraphShift> shifts) {
        this.shifts = shifts;
        return this;
    }

    /**
     * Get the swapShiftsChangeRequests property: The swapShiftsChangeRequests property.
     * 
     * @return the swapShiftsChangeRequests value.
     */
    public List<MicrosoftGraphSwapShiftsChangeRequest> swapShiftsChangeRequests() {
        return this.swapShiftsChangeRequests;
    }

    /**
     * Set the swapShiftsChangeRequests property: The swapShiftsChangeRequests property.
     * 
     * @param swapShiftsChangeRequests the swapShiftsChangeRequests value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule
        withSwapShiftsChangeRequests(List<MicrosoftGraphSwapShiftsChangeRequest> swapShiftsChangeRequests) {
        this.swapShiftsChangeRequests = swapShiftsChangeRequests;
        return this;
    }

    /**
     * Get the timeOffReasons property: The set of reasons for a time off in the schedule.
     * 
     * @return the timeOffReasons value.
     */
    public List<MicrosoftGraphTimeOffReason> timeOffReasons() {
        return this.timeOffReasons;
    }

    /**
     * Set the timeOffReasons property: The set of reasons for a time off in the schedule.
     * 
     * @param timeOffReasons the timeOffReasons value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withTimeOffReasons(List<MicrosoftGraphTimeOffReason> timeOffReasons) {
        this.timeOffReasons = timeOffReasons;
        return this;
    }

    /**
     * Get the timeOffRequests property: The timeOffRequests property.
     * 
     * @return the timeOffRequests value.
     */
    public List<MicrosoftGraphTimeOffRequest> timeOffRequests() {
        return this.timeOffRequests;
    }

    /**
     * Set the timeOffRequests property: The timeOffRequests property.
     * 
     * @param timeOffRequests the timeOffRequests value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withTimeOffRequests(List<MicrosoftGraphTimeOffRequest> timeOffRequests) {
        this.timeOffRequests = timeOffRequests;
        return this;
    }

    /**
     * Get the timesOff property: The instances of times off in the schedule.
     * 
     * @return the timesOff value.
     */
    public List<MicrosoftGraphTimeOff> timesOff() {
        return this.timesOff;
    }

    /**
     * Set the timesOff property: The instances of times off in the schedule.
     * 
     * @param timesOff the timesOff value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withTimesOff(List<MicrosoftGraphTimeOff> timesOff) {
        this.timesOff = timesOff;
        return this;
    }

    /**
     * Get the additionalProperties property: schedule.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: schedule.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSchedule object itself.
     */
    public MicrosoftGraphSchedule withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSchedule withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (offerShiftRequests() != null) {
            offerShiftRequests().forEach(e -> e.validate());
        }
        if (openShiftChangeRequests() != null) {
            openShiftChangeRequests().forEach(e -> e.validate());
        }
        if (openShifts() != null) {
            openShifts().forEach(e -> e.validate());
        }
        if (schedulingGroups() != null) {
            schedulingGroups().forEach(e -> e.validate());
        }
        if (shifts() != null) {
            shifts().forEach(e -> e.validate());
        }
        if (swapShiftsChangeRequests() != null) {
            swapShiftsChangeRequests().forEach(e -> e.validate());
        }
        if (timeOffReasons() != null) {
            timeOffReasons().forEach(e -> e.validate());
        }
        if (timeOffRequests() != null) {
            timeOffRequests().forEach(e -> e.validate());
        }
        if (timesOff() != null) {
            timesOff().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeBooleanField("offerShiftRequestsEnabled", this.offerShiftRequestsEnabled);
        jsonWriter.writeBooleanField("openShiftsEnabled", this.openShiftsEnabled);
        jsonWriter.writeStringField("provisionStatus",
            this.provisionStatus == null ? null : this.provisionStatus.toString());
        jsonWriter.writeStringField("provisionStatusCode", this.provisionStatusCode);
        jsonWriter.writeBooleanField("swapShiftsRequestsEnabled", this.swapShiftsRequestsEnabled);
        jsonWriter.writeBooleanField("timeClockEnabled", this.timeClockEnabled);
        jsonWriter.writeBooleanField("timeOffRequestsEnabled", this.timeOffRequestsEnabled);
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeArrayField("workforceIntegrationIds", this.workforceIntegrationIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("offerShiftRequests", this.offerShiftRequests,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("openShiftChangeRequests", this.openShiftChangeRequests,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("openShifts", this.openShifts, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("schedulingGroups", this.schedulingGroups,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("shifts", this.shifts, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("swapShiftsChangeRequests", this.swapShiftsChangeRequests,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("timeOffReasons", this.timeOffReasons,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("timeOffRequests", this.timeOffRequests,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("timesOff", this.timesOff, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSchedule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSchedule if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSchedule.
     */
    public static MicrosoftGraphSchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSchedule deserializedMicrosoftGraphSchedule = new MicrosoftGraphSchedule();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.withId(reader.getString());
                } else if ("enabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("offerShiftRequestsEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.offerShiftRequestsEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("openShiftsEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.openShiftsEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("provisionStatus".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.provisionStatus
                        = MicrosoftGraphOperationStatus.fromString(reader.getString());
                } else if ("provisionStatusCode".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.provisionStatusCode = reader.getString();
                } else if ("swapShiftsRequestsEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.swapShiftsRequestsEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("timeClockEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.timeClockEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("timeOffRequestsEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.timeOffRequestsEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("timeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.timeZone = reader.getString();
                } else if ("workforceIntegrationIds".equals(fieldName)) {
                    List<String> workforceIntegrationIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphSchedule.workforceIntegrationIds = workforceIntegrationIds;
                } else if ("offerShiftRequests".equals(fieldName)) {
                    List<MicrosoftGraphOfferShiftRequest> offerShiftRequests
                        = reader.readArray(reader1 -> MicrosoftGraphOfferShiftRequest.fromJson(reader1));
                    deserializedMicrosoftGraphSchedule.offerShiftRequests = offerShiftRequests;
                } else if ("openShiftChangeRequests".equals(fieldName)) {
                    List<MicrosoftGraphOpenShiftChangeRequest> openShiftChangeRequests
                        = reader.readArray(reader1 -> MicrosoftGraphOpenShiftChangeRequest.fromJson(reader1));
                    deserializedMicrosoftGraphSchedule.openShiftChangeRequests = openShiftChangeRequests;
                } else if ("openShifts".equals(fieldName)) {
                    List<MicrosoftGraphOpenShift> openShifts
                        = reader.readArray(reader1 -> MicrosoftGraphOpenShift.fromJson(reader1));
                    deserializedMicrosoftGraphSchedule.openShifts = openShifts;
                } else if ("schedulingGroups".equals(fieldName)) {
                    List<MicrosoftGraphSchedulingGroup> schedulingGroups
                        = reader.readArray(reader1 -> MicrosoftGraphSchedulingGroup.fromJson(reader1));
                    deserializedMicrosoftGraphSchedule.schedulingGroups = schedulingGroups;
                } else if ("shifts".equals(fieldName)) {
                    List<MicrosoftGraphShift> shifts
                        = reader.readArray(reader1 -> MicrosoftGraphShift.fromJson(reader1));
                    deserializedMicrosoftGraphSchedule.shifts = shifts;
                } else if ("swapShiftsChangeRequests".equals(fieldName)) {
                    List<MicrosoftGraphSwapShiftsChangeRequest> swapShiftsChangeRequests
                        = reader.readArray(reader1 -> MicrosoftGraphSwapShiftsChangeRequest.fromJson(reader1));
                    deserializedMicrosoftGraphSchedule.swapShiftsChangeRequests = swapShiftsChangeRequests;
                } else if ("timeOffReasons".equals(fieldName)) {
                    List<MicrosoftGraphTimeOffReason> timeOffReasons
                        = reader.readArray(reader1 -> MicrosoftGraphTimeOffReason.fromJson(reader1));
                    deserializedMicrosoftGraphSchedule.timeOffReasons = timeOffReasons;
                } else if ("timeOffRequests".equals(fieldName)) {
                    List<MicrosoftGraphTimeOffRequest> timeOffRequests
                        = reader.readArray(reader1 -> MicrosoftGraphTimeOffRequest.fromJson(reader1));
                    deserializedMicrosoftGraphSchedule.timeOffRequests = timeOffRequests;
                } else if ("timesOff".equals(fieldName)) {
                    List<MicrosoftGraphTimeOff> timesOff
                        = reader.readArray(reader1 -> MicrosoftGraphTimeOff.fromJson(reader1));
                    deserializedMicrosoftGraphSchedule.timesOff = timesOff;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSchedule.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSchedule;
        });
    }
}
