// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * publicationFacet.
 */
@Fluent
public final class MicrosoftGraphPublicationFacet implements JsonSerializable<MicrosoftGraphPublicationFacet> {
    /*
     * The state of publication for this document. Either published or checkout. Read-only.
     */
    private String level;

    /*
     * The unique identifier for the version that is visible to the current caller. Read-only.
     */
    private String versionId;

    /*
     * publicationFacet
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPublicationFacet class.
     */
    public MicrosoftGraphPublicationFacet() {
    }

    /**
     * Get the level property: The state of publication for this document. Either published or checkout. Read-only.
     * 
     * @return the level value.
     */
    public String level() {
        return this.level;
    }

    /**
     * Set the level property: The state of publication for this document. Either published or checkout. Read-only.
     * 
     * @param level the level value to set.
     * @return the MicrosoftGraphPublicationFacet object itself.
     */
    public MicrosoftGraphPublicationFacet withLevel(String level) {
        this.level = level;
        return this;
    }

    /**
     * Get the versionId property: The unique identifier for the version that is visible to the current caller.
     * Read-only.
     * 
     * @return the versionId value.
     */
    public String versionId() {
        return this.versionId;
    }

    /**
     * Set the versionId property: The unique identifier for the version that is visible to the current caller.
     * Read-only.
     * 
     * @param versionId the versionId value to set.
     * @return the MicrosoftGraphPublicationFacet object itself.
     */
    public MicrosoftGraphPublicationFacet withVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    /**
     * Get the additionalProperties property: publicationFacet.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: publicationFacet.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPublicationFacet object itself.
     */
    public MicrosoftGraphPublicationFacet withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("level", this.level);
        jsonWriter.writeStringField("versionId", this.versionId);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPublicationFacet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPublicationFacet if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPublicationFacet.
     */
    public static MicrosoftGraphPublicationFacet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPublicationFacet deserializedMicrosoftGraphPublicationFacet
                = new MicrosoftGraphPublicationFacet();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("level".equals(fieldName)) {
                    deserializedMicrosoftGraphPublicationFacet.level = reader.getString();
                } else if ("versionId".equals(fieldName)) {
                    deserializedMicrosoftGraphPublicationFacet.versionId = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPublicationFacet.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPublicationFacet;
        });
    }
}
