// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * geoCoordinates.
 */
@Fluent
public final class MicrosoftGraphGeoCoordinates implements JsonSerializable<MicrosoftGraphGeoCoordinates> {
    /*
     * Optional. The altitude (height), in feet, above sea level for the item. Read-only.
     */
    private Double altitude;

    /*
     * Optional. The latitude, in decimal, for the item. Read-only.
     */
    private Double latitude;

    /*
     * Optional. The longitude, in decimal, for the item. Read-only.
     */
    private Double longitude;

    /*
     * geoCoordinates
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphGeoCoordinates class.
     */
    public MicrosoftGraphGeoCoordinates() {
    }

    /**
     * Get the altitude property: Optional. The altitude (height), in feet, above sea level for the item. Read-only.
     * 
     * @return the altitude value.
     */
    public Double altitude() {
        return this.altitude;
    }

    /**
     * Set the altitude property: Optional. The altitude (height), in feet, above sea level for the item. Read-only.
     * 
     * @param altitude the altitude value to set.
     * @return the MicrosoftGraphGeoCoordinates object itself.
     */
    public MicrosoftGraphGeoCoordinates withAltitude(Double altitude) {
        this.altitude = altitude;
        return this;
    }

    /**
     * Get the latitude property: Optional. The latitude, in decimal, for the item. Read-only.
     * 
     * @return the latitude value.
     */
    public Double latitude() {
        return this.latitude;
    }

    /**
     * Set the latitude property: Optional. The latitude, in decimal, for the item. Read-only.
     * 
     * @param latitude the latitude value to set.
     * @return the MicrosoftGraphGeoCoordinates object itself.
     */
    public MicrosoftGraphGeoCoordinates withLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    /**
     * Get the longitude property: Optional. The longitude, in decimal, for the item. Read-only.
     * 
     * @return the longitude value.
     */
    public Double longitude() {
        return this.longitude;
    }

    /**
     * Set the longitude property: Optional. The longitude, in decimal, for the item. Read-only.
     * 
     * @param longitude the longitude value to set.
     * @return the MicrosoftGraphGeoCoordinates object itself.
     */
    public MicrosoftGraphGeoCoordinates withLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    /**
     * Get the additionalProperties property: geoCoordinates.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: geoCoordinates.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphGeoCoordinates object itself.
     */
    public MicrosoftGraphGeoCoordinates withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("altitude", this.altitude);
        jsonWriter.writeNumberField("latitude", this.latitude);
        jsonWriter.writeNumberField("longitude", this.longitude);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphGeoCoordinates from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphGeoCoordinates if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphGeoCoordinates.
     */
    public static MicrosoftGraphGeoCoordinates fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphGeoCoordinates deserializedMicrosoftGraphGeoCoordinates = new MicrosoftGraphGeoCoordinates();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("altitude".equals(fieldName)) {
                    deserializedMicrosoftGraphGeoCoordinates.altitude = reader.getNullable(JsonReader::getDouble);
                } else if ("latitude".equals(fieldName)) {
                    deserializedMicrosoftGraphGeoCoordinates.latitude = reader.getNullable(JsonReader::getDouble);
                } else if ("longitude".equals(fieldName)) {
                    deserializedMicrosoftGraphGeoCoordinates.longitude = reader.getNullable(JsonReader::getDouble);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphGeoCoordinates.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphGeoCoordinates;
        });
    }
}
