// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * deviceActionResult
 * 
 * Device action result.
 */
@Fluent
public final class MicrosoftGraphDeviceActionResult implements JsonSerializable<MicrosoftGraphDeviceActionResult> {
    /*
     * Action name
     */
    private String actionName;

    /*
     * actionState
     */
    private MicrosoftGraphActionState actionState;

    /*
     * Time the action state was last updated
     */
    private OffsetDateTime lastUpdatedDateTime;

    /*
     * Time the action was initiated
     */
    private OffsetDateTime startDateTime;

    /*
     * Device action result
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphDeviceActionResult class.
     */
    public MicrosoftGraphDeviceActionResult() {
    }

    /**
     * Get the actionName property: Action name.
     * 
     * @return the actionName value.
     */
    public String actionName() {
        return this.actionName;
    }

    /**
     * Set the actionName property: Action name.
     * 
     * @param actionName the actionName value to set.
     * @return the MicrosoftGraphDeviceActionResult object itself.
     */
    public MicrosoftGraphDeviceActionResult withActionName(String actionName) {
        this.actionName = actionName;
        return this;
    }

    /**
     * Get the actionState property: actionState.
     * 
     * @return the actionState value.
     */
    public MicrosoftGraphActionState actionState() {
        return this.actionState;
    }

    /**
     * Set the actionState property: actionState.
     * 
     * @param actionState the actionState value to set.
     * @return the MicrosoftGraphDeviceActionResult object itself.
     */
    public MicrosoftGraphDeviceActionResult withActionState(MicrosoftGraphActionState actionState) {
        this.actionState = actionState;
        return this;
    }

    /**
     * Get the lastUpdatedDateTime property: Time the action state was last updated.
     * 
     * @return the lastUpdatedDateTime value.
     */
    public OffsetDateTime lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    /**
     * Set the lastUpdatedDateTime property: Time the action state was last updated.
     * 
     * @param lastUpdatedDateTime the lastUpdatedDateTime value to set.
     * @return the MicrosoftGraphDeviceActionResult object itself.
     */
    public MicrosoftGraphDeviceActionResult withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    /**
     * Get the startDateTime property: Time the action was initiated.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: Time the action was initiated.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphDeviceActionResult object itself.
     */
    public MicrosoftGraphDeviceActionResult withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: Device action result.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Device action result.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDeviceActionResult object itself.
     */
    public MicrosoftGraphDeviceActionResult withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionName", this.actionName);
        jsonWriter.writeStringField("actionState", this.actionState == null ? null : this.actionState.toString());
        jsonWriter.writeStringField("lastUpdatedDateTime",
            this.lastUpdatedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeStringField("startDateTime",
            this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphDeviceActionResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphDeviceActionResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphDeviceActionResult.
     */
    public static MicrosoftGraphDeviceActionResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphDeviceActionResult deserializedMicrosoftGraphDeviceActionResult
                = new MicrosoftGraphDeviceActionResult();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actionName".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceActionResult.actionName = reader.getString();
                } else if ("actionState".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceActionResult.actionState
                        = MicrosoftGraphActionState.fromString(reader.getString());
                } else if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceActionResult.lastUpdatedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceActionResult.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphDeviceActionResult.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphDeviceActionResult;
        });
    }
}
