// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * contract
 * 
 * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
 * entity types.
 */
@Fluent
public final class MicrosoftGraphContract extends MicrosoftGraphDirectoryObjectInner {
    /*
     * Type of contract.Possible values are: SyndicationPartner - Partner that exclusively resells and manages O365 and
     * Intune for this customer. They resell and support their customers. BreadthPartner - Partner has the ability to
     * provide administrative support for this customer. However, the partner is not allowed to resell to the
     * customer.ResellerPartner - Partner that is similar to a syndication partner, except that the partner doesn’t have
     * exclusive access to a tenant. In the syndication case, the customer cannot buy additional direct subscriptions
     * from Microsoft or from other partners.
     */
    private String contractType;

    /*
     * The unique identifier for the customer tenant referenced by this partnership. Corresponds to the id property of
     * the customer tenant's organization resource.
     */
    private UUID customerId;

    /*
     * A copy of the customer tenant's default domain name. The copy is made when the partnership with the customer is
     * established. It is not automatically updated if the customer tenant's default domain name changes.
     */
    private String defaultDomainName;

    /*
     * A copy of the customer tenant's display name. The copy is made when the partnership with the customer is
     * established. It is not automatically updated if the customer tenant's display name changes.
     */
    private String displayName;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
     * entity types.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphContract class.
     */
    public MicrosoftGraphContract() {
    }

    /**
     * Get the contractType property: Type of contract.Possible values are: SyndicationPartner - Partner that
     * exclusively resells and manages O365 and Intune for this customer. They resell and support their customers.
     * BreadthPartner - Partner has the ability to provide administrative support for this customer. However, the
     * partner is not allowed to resell to the customer.ResellerPartner - Partner that is similar to a syndication
     * partner, except that the partner doesn’t have exclusive access to a tenant. In the syndication case, the customer
     * cannot buy additional direct subscriptions from Microsoft or from other partners.
     * 
     * @return the contractType value.
     */
    public String contractType() {
        return this.contractType;
    }

    /**
     * Set the contractType property: Type of contract.Possible values are: SyndicationPartner - Partner that
     * exclusively resells and manages O365 and Intune for this customer. They resell and support their customers.
     * BreadthPartner - Partner has the ability to provide administrative support for this customer. However, the
     * partner is not allowed to resell to the customer.ResellerPartner - Partner that is similar to a syndication
     * partner, except that the partner doesn’t have exclusive access to a tenant. In the syndication case, the customer
     * cannot buy additional direct subscriptions from Microsoft or from other partners.
     * 
     * @param contractType the contractType value to set.
     * @return the MicrosoftGraphContract object itself.
     */
    public MicrosoftGraphContract withContractType(String contractType) {
        this.contractType = contractType;
        return this;
    }

    /**
     * Get the customerId property: The unique identifier for the customer tenant referenced by this partnership.
     * Corresponds to the id property of the customer tenant's organization resource.
     * 
     * @return the customerId value.
     */
    public UUID customerId() {
        return this.customerId;
    }

    /**
     * Set the customerId property: The unique identifier for the customer tenant referenced by this partnership.
     * Corresponds to the id property of the customer tenant's organization resource.
     * 
     * @param customerId the customerId value to set.
     * @return the MicrosoftGraphContract object itself.
     */
    public MicrosoftGraphContract withCustomerId(UUID customerId) {
        this.customerId = customerId;
        return this;
    }

    /**
     * Get the defaultDomainName property: A copy of the customer tenant's default domain name. The copy is made when
     * the partnership with the customer is established. It is not automatically updated if the customer tenant's
     * default domain name changes.
     * 
     * @return the defaultDomainName value.
     */
    public String defaultDomainName() {
        return this.defaultDomainName;
    }

    /**
     * Set the defaultDomainName property: A copy of the customer tenant's default domain name. The copy is made when
     * the partnership with the customer is established. It is not automatically updated if the customer tenant's
     * default domain name changes.
     * 
     * @param defaultDomainName the defaultDomainName value to set.
     * @return the MicrosoftGraphContract object itself.
     */
    public MicrosoftGraphContract withDefaultDomainName(String defaultDomainName) {
        this.defaultDomainName = defaultDomainName;
        return this;
    }

    /**
     * Get the displayName property: A copy of the customer tenant's display name. The copy is made when the partnership
     * with the customer is established. It is not automatically updated if the customer tenant's display name changes.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: A copy of the customer tenant's display name. The copy is made when the partnership
     * with the customer is established. It is not automatically updated if the customer tenant's display name changes.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphContract object itself.
     */
    public MicrosoftGraphContract withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphContract object itself.
     */
    public MicrosoftGraphContract withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphContract withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphContract withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("deletedDateTime",
            deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(deletedDateTime()));
        jsonWriter.writeStringField("contractType", this.contractType);
        jsonWriter.writeStringField("customerId", Objects.toString(this.customerId, null));
        jsonWriter.writeStringField("defaultDomainName", this.defaultDomainName);
        jsonWriter.writeStringField("displayName", this.displayName);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphContract if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphContract.
     */
    public static MicrosoftGraphContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphContract deserializedMicrosoftGraphContract = new MicrosoftGraphContract();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.withId(reader.getString());
                } else if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.withDeletedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("contractType".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.contractType = reader.getString();
                } else if ("customerId".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.customerId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("defaultDomainName".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.defaultDomainName = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.displayName = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphContract.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphContract;
        });
    }
}
