// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ExpandedProperties model.
 */
@Fluent
public final class ExpandedProperties implements JsonSerializable<ExpandedProperties> {
    /*
     * Details of the resource scope
     */
    private ExpandedPropertiesScope scope;

    /*
     * Details of role definition
     */
    private ExpandedPropertiesRoleDefinition roleDefinition;

    /*
     * Details of the principal
     */
    private ExpandedPropertiesPrincipal principal;

    /**
     * Creates an instance of ExpandedProperties class.
     */
    public ExpandedProperties() {
    }

    /**
     * Get the scope property: Details of the resource scope.
     * 
     * @return the scope value.
     */
    public ExpandedPropertiesScope scope() {
        return this.scope;
    }

    /**
     * Set the scope property: Details of the resource scope.
     * 
     * @param scope the scope value to set.
     * @return the ExpandedProperties object itself.
     */
    public ExpandedProperties withScope(ExpandedPropertiesScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the roleDefinition property: Details of role definition.
     * 
     * @return the roleDefinition value.
     */
    public ExpandedPropertiesRoleDefinition roleDefinition() {
        return this.roleDefinition;
    }

    /**
     * Set the roleDefinition property: Details of role definition.
     * 
     * @param roleDefinition the roleDefinition value to set.
     * @return the ExpandedProperties object itself.
     */
    public ExpandedProperties withRoleDefinition(ExpandedPropertiesRoleDefinition roleDefinition) {
        this.roleDefinition = roleDefinition;
        return this;
    }

    /**
     * Get the principal property: Details of the principal.
     * 
     * @return the principal value.
     */
    public ExpandedPropertiesPrincipal principal() {
        return this.principal;
    }

    /**
     * Set the principal property: Details of the principal.
     * 
     * @param principal the principal value to set.
     * @return the ExpandedProperties object itself.
     */
    public ExpandedProperties withPrincipal(ExpandedPropertiesPrincipal principal) {
        this.principal = principal;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scope() != null) {
            scope().validate();
        }
        if (roleDefinition() != null) {
            roleDefinition().validate();
        }
        if (principal() != null) {
            principal().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("scope", this.scope);
        jsonWriter.writeJsonField("roleDefinition", this.roleDefinition);
        jsonWriter.writeJsonField("principal", this.principal);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpandedProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpandedProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpandedProperties.
     */
    public static ExpandedProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpandedProperties deserializedExpandedProperties = new ExpandedProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedExpandedProperties.scope = ExpandedPropertiesScope.fromJson(reader);
                } else if ("roleDefinition".equals(fieldName)) {
                    deserializedExpandedProperties.roleDefinition = ExpandedPropertiesRoleDefinition.fromJson(reader);
                } else if ("principal".equals(fieldName)) {
                    deserializedExpandedProperties.principal = ExpandedPropertiesPrincipal.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpandedProperties;
        });
    }
}
