// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.authorization.fluent.RoleManagementPoliciesClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleManagementPolicyInner;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in RoleManagementPoliciesClient.
 */
public final class RoleManagementPoliciesClientImpl implements InnerSupportsDelete<Void>, RoleManagementPoliciesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final RoleManagementPoliciesService service;

    /**
     * The service client containing this operation class.
     */
    private final AuthorizationManagementClientImpl client;

    /**
     * Initializes an instance of RoleManagementPoliciesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    RoleManagementPoliciesClientImpl(AuthorizationManagementClientImpl client) {
        this.service = RestProxy.create(RoleManagementPoliciesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AuthorizationManagementClientRoleManagementPolicies to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AuthorizationManagem")
    public interface RoleManagementPoliciesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/{scope}/providers/Microsoft.Authorization/roleManagementPolicies/{roleManagementPolicyName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleManagementPolicyInner>> get(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleManagementPolicyName") String roleManagementPolicyName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/{scope}/providers/Microsoft.Authorization/roleManagementPolicies/{roleManagementPolicyName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleManagementPolicyInner>> update(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleManagementPolicyName") String roleManagementPolicyName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RoleManagementPolicyInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/{scope}/providers/Microsoft.Authorization/roleManagementPolicies/{roleManagementPolicyName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleManagementPolicyName") String roleManagementPolicyName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/{scope}/providers/Microsoft.Authorization/roleManagementPolicies")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleManagementPolicyListResult>> listForScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleManagementPolicyListResult>> listForScopeNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get the specified role management policy for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyName The name (guid) of the role management policy to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy for a resource scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleManagementPolicyInner>> getWithResponseAsync(String scope,
        String roleManagementPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter roleManagementPolicyName is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), scope, roleManagementPolicyName, apiVersion,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the specified role management policy for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyName The name (guid) of the role management policy to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy for a resource scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleManagementPolicyInner>> getWithResponseAsync(String scope,
        String roleManagementPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter roleManagementPolicyName is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), scope, roleManagementPolicyName, apiVersion, accept, context);
    }

    /**
     * Get the specified role management policy for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyName The name (guid) of the role management policy to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy for a resource scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleManagementPolicyInner> getAsync(String scope, String roleManagementPolicyName) {
        return getWithResponseAsync(scope, roleManagementPolicyName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the specified role management policy for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyName The name (guid) of the role management policy to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy for a resource scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleManagementPolicyInner> getWithResponse(String scope, String roleManagementPolicyName,
        Context context) {
        return getWithResponseAsync(scope, roleManagementPolicyName, context).block();
    }

    /**
     * Get the specified role management policy for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyName The name (guid) of the role management policy to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy for a resource scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleManagementPolicyInner get(String scope, String roleManagementPolicyName) {
        return getWithResponse(scope, roleManagementPolicyName, Context.NONE).getValue();
    }

    /**
     * Update a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param parameters Parameters for the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleManagementPolicyInner>> updateWithResponseAsync(String scope,
        String roleManagementPolicyName, RoleManagementPolicyInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter roleManagementPolicyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), scope, roleManagementPolicyName,
                apiVersion, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param parameters Parameters for the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleManagementPolicyInner>> updateWithResponseAsync(String scope,
        String roleManagementPolicyName, RoleManagementPolicyInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter roleManagementPolicyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), scope, roleManagementPolicyName, apiVersion, parameters,
            accept, context);
    }

    /**
     * Update a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param parameters Parameters for the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleManagementPolicyInner> updateAsync(String scope, String roleManagementPolicyName,
        RoleManagementPolicyInner parameters) {
        return updateWithResponseAsync(scope, roleManagementPolicyName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param parameters Parameters for the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleManagementPolicyInner> updateWithResponse(String scope, String roleManagementPolicyName,
        RoleManagementPolicyInner parameters, Context context) {
        return updateWithResponseAsync(scope, roleManagementPolicyName, parameters, context).block();
    }

    /**
     * Update a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param parameters Parameters for the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleManagementPolicyInner update(String scope, String roleManagementPolicyName,
        RoleManagementPolicyInner parameters) {
        return updateWithResponse(scope, roleManagementPolicyName, parameters, Context.NONE).getValue();
    }

    /**
     * Delete a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String scope, String roleManagementPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter roleManagementPolicyName is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), scope, roleManagementPolicyName,
                apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String scope, String roleManagementPolicyName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter roleManagementPolicyName is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), scope, roleManagementPolicyName, apiVersion, accept, context);
    }

    /**
     * Delete a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String scope, String roleManagementPolicyName) {
        return deleteWithResponseAsync(scope, roleManagementPolicyName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String scope, String roleManagementPolicyName, Context context) {
        return deleteWithResponseAsync(scope, roleManagementPolicyName, context).block();
    }

    /**
     * Delete a role management policy.
     * 
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String scope, String roleManagementPolicyName) {
        deleteWithResponse(scope, roleManagementPolicyName, Context.NONE);
    }

    /**
     * Gets role management policies for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policies for a resource scope along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleManagementPolicyInner>> listForScopeSinglePageAsync(String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listForScope(this.client.getEndpoint(), scope, apiVersion, accept, context))
            .<PagedResponse<RoleManagementPolicyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets role management policies for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policies for a resource scope along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleManagementPolicyInner>> listForScopeSinglePageAsync(String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listForScope(this.client.getEndpoint(), scope, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets role management policies for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policies for a resource scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleManagementPolicyInner> listForScopeAsync(String scope) {
        return new PagedFlux<>(() -> listForScopeSinglePageAsync(scope),
            nextLink -> listForScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Gets role management policies for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policies for a resource scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RoleManagementPolicyInner> listForScopeAsync(String scope, Context context) {
        return new PagedFlux<>(() -> listForScopeSinglePageAsync(scope, context),
            nextLink -> listForScopeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets role management policies for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policies for a resource scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleManagementPolicyInner> listForScope(String scope) {
        return new PagedIterable<>(listForScopeAsync(scope));
    }

    /**
     * Gets role management policies for a resource scope.
     * 
     * @param scope The scope of the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policies for a resource scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleManagementPolicyInner> listForScope(String scope, Context context) {
        return new PagedIterable<>(listForScopeAsync(scope, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy list operation result along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleManagementPolicyInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listForScopeNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RoleManagementPolicyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy list operation result along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleManagementPolicyInner>> listForScopeNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listForScopeNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
