// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.authorization.fluent.ApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsAddKeyRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsAddPasswordRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsExpand;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsRemoveKeyRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsRemovePasswordRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsSelect;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtensionProperty;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfHomeRealmDiscoveryPolicy;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfHomeRealmDiscoveryPolicy;
import com.azure.resourcemanager.authorization.fluent.models.Get1ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphHomeRealmDiscoveryPolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ApplicationsClient.
 */
public final class ApplicationsClientImpl implements ApplicationsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ApplicationsService service;

    /**
     * The service client containing this operation class.
     */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of ApplicationsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ApplicationsClientImpl(MicrosoftGraphClientImpl client) {
        this.service
            = RestProxy.create(ApplicationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientApplications to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    public interface ApplicationsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/applications/{application-id}/createdOnBehalfOf")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOf(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId, @QueryParam("$select") String select,
            @QueryParam("$expand") String expand, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/applications/{application-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<String>> getRefCreatedOnBehalfOf(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/applications/{application-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> setRefCreatedOnBehalfOf(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId, @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/applications/{application-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteRefCreatedOnBehalfOf(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/applications/{application-id}/extensionProperties")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtensionProperty>> listExtensionProperties(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId, @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip, @QueryParam("$search") String search,
            @QueryParam("$filter") String filter, @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby, @QueryParam("$select") String select,
            @QueryParam("$expand") String expand, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/extensionProperties")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionPropertyInner>> createExtensionProperties(
            @HostParam("$host") String endpoint, @PathParam("application-id") String applicationId,
            @BodyParam("application/json") MicrosoftGraphExtensionPropertyInner body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/applications/{application-id}/extensionProperties/{extensionProperty-id}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionPropertyInner>> getExtensionProperties(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @PathParam("extensionProperty-id") String extensionPropertyId, @QueryParam("$select") String select,
            @QueryParam("$expand") String expand, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/applications/{application-id}/extensionProperties/{extensionProperty-id}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateExtensionProperties(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @PathParam("extensionProperty-id") String extensionPropertyId,
            @BodyParam("application/json") MicrosoftGraphExtensionPropertyInner body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/applications/{application-id}/extensionProperties/{extensionProperty-id}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteExtensionProperties(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @PathParam("extensionProperty-id") String extensionPropertyId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/applications/{application-id}/homeRealmDiscoveryPolicies")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfHomeRealmDiscoveryPolicy>> listHomeRealmDiscoveryPolicies(
            @HostParam("$host") String endpoint, @PathParam("application-id") String applicationId,
            @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip, @QueryParam("$search") String search,
            @QueryParam("$filter") String filter, @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby, @QueryParam("$select") String select,
            @QueryParam("$expand") String expand, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/applications/{application-id}/homeRealmDiscoveryPolicies/$ref")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfHomeRealmDiscoveryPolicy>> listRefHomeRealmDiscoveryPolicies(
            @HostParam("$host") String endpoint, @PathParam("application-id") String applicationId,
            @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip, @QueryParam("$search") String search,
            @QueryParam("$filter") String filter, @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/homeRealmDiscoveryPolicies/$ref")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefHomeRealmDiscoveryPolicies(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId, @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/microsoft.graph.addKey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphKeyCredentialInner>> addKey(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @BodyParam("application/json") ApplicationsAddKeyRequestBodyInner body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/microsoft.graph.addPassword")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPassword(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @BodyParam("application/json") ApplicationsAddPasswordRequestBodyInner body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> checkMemberGroups(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @BodyParam("application/json") ApplicationsCheckMemberGroupsRequestBody body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> checkMemberObjects(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @BodyParam("application/json") ApplicationsCheckMemberObjectsRequestBody body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> getMemberGroups(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @BodyParam("application/json") ApplicationsGetMemberGroupsRequestBody body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> getMemberObjects(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @BodyParam("application/json") ApplicationsGetMemberObjectsRequestBody body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/microsoft.graph.removeKey")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> removeKey(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @BodyParam("application/json") ApplicationsRemoveKeyRequestBody body, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/microsoft.graph.removePassword")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> removePassword(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId,
            @BodyParam("application/json") ApplicationsRemovePasswordRequestBody body,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/applications/{application-id}/microsoft.graph.restore")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(@HostParam("$host") String endpoint,
            @PathParam("application-id") String applicationId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json", "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtensionProperty>>
            listMore(@PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({ "Accept: application/json", "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfHomeRealmDiscoveryPolicy>> listHomeRealmDiscoveryPoliciesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({ "Accept: application/json", "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfHomeRealmDiscoveryPolicy>> listRefHomeRealmDiscoveryPoliciesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from applications along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>>
        getCreatedOnBehalfOfWithResponseAsync(String applicationId, List<Get1ItemsItem> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String expandConverted = (expand == null)
            ? null
            : expand.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.getCreatedOnBehalfOf(this.client.getEndpoint(), applicationId,
                selectConverted, expandConverted, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from applications along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOfWithResponseAsync(
        String applicationId, List<Get1ItemsItem> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String expandConverted = (expand == null)
            ? null
            : expand.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return service.getCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, selectConverted, expandConverted,
            accept, context);
    }

    /**
     * Get createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from applications on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfAsync(String applicationId) {
        final List<Get1ItemsItem> select = null;
        final List<String> expand = null;
        return getCreatedOnBehalfOfWithResponseAsync(applicationId, select, expand)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from applications along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfWithResponse(String applicationId,
        List<Get1ItemsItem> select, List<String> expand, Context context) {
        return getCreatedOnBehalfOfWithResponseAsync(applicationId, select, expand, context).block();
    }

    /**
     * Get createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdOnBehalfOf from applications.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner getCreatedOnBehalfOf(String applicationId) {
        final List<Get1ItemsItem> select = null;
        final List<String> expand = null;
        return getCreatedOnBehalfOfWithResponse(applicationId, select, expand, Context.NONE).getValue();
    }

    /**
     * Get ref of createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from applications along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<String>> getRefCreatedOnBehalfOfWithResponseAsync(String applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get ref of createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from applications along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<String>> getRefCreatedOnBehalfOfWithResponseAsync(String applicationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, accept, context);
    }

    /**
     * Get ref of createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from applications on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<String> getRefCreatedOnBehalfOfAsync(String applicationId) {
        return getRefCreatedOnBehalfOfWithResponseAsync(applicationId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get ref of createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from applications along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> getRefCreatedOnBehalfOfWithResponse(String applicationId, Context context) {
        return getRefCreatedOnBehalfOfWithResponseAsync(applicationId, context).block();
    }

    /**
     * Get ref of createdOnBehalfOf from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdOnBehalfOf from applications.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getRefCreatedOnBehalfOf(String applicationId) {
        return getRefCreatedOnBehalfOfWithResponse(applicationId, Context.NONE).getValue();
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setRefCreatedOnBehalfOfWithResponseAsync(String applicationId,
        Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.setRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> setRefCreatedOnBehalfOfWithResponseAsync(String applicationId,
        Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.setRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setRefCreatedOnBehalfOfAsync(String applicationId, Map<String, Object> body) {
        return setRefCreatedOnBehalfOfWithResponseAsync(applicationId, body).flatMap(ignored -> Mono.empty());
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setRefCreatedOnBehalfOfWithResponse(String applicationId, Map<String, Object> body,
        Context context) {
        return setRefCreatedOnBehalfOfWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Update the ref of navigation property createdOnBehalfOf in applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setRefCreatedOnBehalfOf(String applicationId, Map<String, Object> body) {
        setRefCreatedOnBehalfOfWithResponse(applicationId, body, Context.NONE);
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for applications.
     * 
     * @param applicationId key: id of application.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRefCreatedOnBehalfOfWithResponseAsync(String applicationId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId,
                ifMatch, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for applications.
     * 
     * @param applicationId key: id of application.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRefCreatedOnBehalfOfWithResponseAsync(String applicationId, String ifMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, ifMatch, accept, context);
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteRefCreatedOnBehalfOfAsync(String applicationId) {
        final String ifMatch = null;
        return deleteRefCreatedOnBehalfOfWithResponseAsync(applicationId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for applications.
     * 
     * @param applicationId key: id of application.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteRefCreatedOnBehalfOfWithResponse(String applicationId, String ifMatch,
        Context context) {
        return deleteRefCreatedOnBehalfOfWithResponseAsync(applicationId, ifMatch, context).block();
    }

    /**
     * Delete ref of navigation property createdOnBehalfOf for applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteRefCreatedOnBehalfOf(String applicationId) {
        final String ifMatch = null;
        deleteRefCreatedOnBehalfOfWithResponse(applicationId, ifMatch, Context.NONE);
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionPropertyInner>> listExtensionPropertiesSinglePageAsync(
        String applicationId, Integer top, Integer skip, String search, String filter, Boolean count,
        List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted = (orderby == null)
            ? null
            : orderby.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String expandConverted = (expand == null)
            ? null
            : expand.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.listExtensionProperties(this.client.getEndpoint(), applicationId, top, skip,
                search, filter, count, orderbyConverted, selectConverted, expandConverted, accept, context))
            .<PagedResponse<MicrosoftGraphExtensionPropertyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().odataNextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionPropertyInner>> listExtensionPropertiesSinglePageAsync(
        String applicationId, Integer top, Integer skip, String search, String filter, Boolean count,
        List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted = (orderby == null)
            ? null
            : orderby.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String expandConverted = (expand == null)
            ? null
            : expand.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return service
            .listExtensionProperties(this.client.getEndpoint(), applicationId, top, skip, search, filter, count,
                orderbyConverted, selectConverted, expandConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().odataNextLink(), null));
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionPropertyInner> listExtensionPropertiesAsync(String applicationId,
        Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby,
        List<ApplicationsSelect> select, List<String> expand) {
        return new PagedFlux<>(() -> listExtensionPropertiesSinglePageAsync(applicationId, top, skip, search, filter,
            count, orderby, select, expand), nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionPropertyInner> listExtensionPropertiesAsync(String applicationId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ApplicationsOrderby> orderby = null;
        final List<ApplicationsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(() -> listExtensionPropertiesSinglePageAsync(applicationId, top, skip, search, filter,
            count, orderby, select, expand), nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphExtensionPropertyInner> listExtensionPropertiesAsync(String applicationId,
        Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby,
        List<ApplicationsSelect> select, List<String> expand, Context context) {
        return new PagedFlux<>(() -> listExtensionPropertiesSinglePageAsync(applicationId, top, skip, search, filter,
            count, orderby, select, expand, context), nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionPropertyInner> listExtensionProperties(String applicationId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ApplicationsOrderby> orderby = null;
        final List<ApplicationsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listExtensionPropertiesAsync(applicationId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionPropertyInner> listExtensionProperties(String applicationId,
        Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby,
        List<ApplicationsSelect> select, List<String> expand, Context context) {
        return new PagedIterable<>(listExtensionPropertiesAsync(applicationId, top, skip, search, filter, count,
            orderby, select, expand, context));
    }

    /**
     * Create new navigation property to extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperty along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionPropertyInner>>
        createExtensionPropertiesWithResponseAsync(String applicationId, MicrosoftGraphExtensionPropertyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createExtensionProperties(this.client.getEndpoint(), applicationId, body,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create new navigation property to extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperty along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionPropertyInner>> createExtensionPropertiesWithResponseAsync(
        String applicationId, MicrosoftGraphExtensionPropertyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createExtensionProperties(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Create new navigation property to extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperty on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionPropertyInner> createExtensionPropertiesAsync(String applicationId,
        MicrosoftGraphExtensionPropertyInner body) {
        return createExtensionPropertiesWithResponseAsync(applicationId, body)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create new navigation property to extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperty along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionPropertyInner> createExtensionPropertiesWithResponse(String applicationId,
        MicrosoftGraphExtensionPropertyInner body, Context context) {
        return createExtensionPropertiesWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Create new navigation property to extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperty.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionPropertyInner createExtensionProperties(String applicationId,
        MicrosoftGraphExtensionPropertyInner body) {
        return createExtensionPropertiesWithResponse(applicationId, body, Context.NONE).getValue();
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionPropertyInner>> getExtensionPropertiesWithResponseAsync(
        String applicationId, String extensionPropertyId, List<ApplicationsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String expandConverted = (expand == null)
            ? null
            : expand.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.getExtensionProperties(this.client.getEndpoint(), applicationId,
                extensionPropertyId, selectConverted, expandConverted, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionPropertyInner>> getExtensionPropertiesWithResponseAsync(
        String applicationId, String extensionPropertyId, List<ApplicationsSelect> select, List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String expandConverted = (expand == null)
            ? null
            : expand.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return service.getExtensionProperties(this.client.getEndpoint(), applicationId, extensionPropertyId,
            selectConverted, expandConverted, accept, context);
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionPropertyInner> getExtensionPropertiesAsync(String applicationId,
        String extensionPropertyId) {
        final List<ApplicationsSelect> select = null;
        final List<String> expand = null;
        return getExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, select, expand)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionPropertyInner> getExtensionPropertiesWithResponse(String applicationId,
        String extensionPropertyId, List<ApplicationsSelect> select, List<String> expand, Context context) {
        return getExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, select, expand, context)
            .block();
    }

    /**
     * Get extensionProperties from applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensionProperties from applications.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionPropertyInner getExtensionProperties(String applicationId,
        String extensionPropertyId) {
        final List<ApplicationsSelect> select = null;
        final List<String> expand = null;
        return getExtensionPropertiesWithResponse(applicationId, extensionPropertyId, select, expand, Context.NONE)
            .getValue();
    }

    /**
     * Update the navigation property extensionProperties in applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateExtensionPropertiesWithResponseAsync(String applicationId,
        String extensionPropertyId, MicrosoftGraphExtensionPropertyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateExtensionProperties(this.client.getEndpoint(), applicationId,
                extensionPropertyId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update the navigation property extensionProperties in applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateExtensionPropertiesWithResponseAsync(String applicationId,
        String extensionPropertyId, MicrosoftGraphExtensionPropertyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateExtensionProperties(this.client.getEndpoint(), applicationId, extensionPropertyId, body,
            accept, context);
    }

    /**
     * Update the navigation property extensionProperties in applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateExtensionPropertiesAsync(String applicationId, String extensionPropertyId,
        MicrosoftGraphExtensionPropertyInner body) {
        return updateExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, body)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Update the navigation property extensionProperties in applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateExtensionPropertiesWithResponse(String applicationId, String extensionPropertyId,
        MicrosoftGraphExtensionPropertyInner body, Context context) {
        return updateExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, body, context).block();
    }

    /**
     * Update the navigation property extensionProperties in applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateExtensionProperties(String applicationId, String extensionPropertyId,
        MicrosoftGraphExtensionPropertyInner body) {
        updateExtensionPropertiesWithResponse(applicationId, extensionPropertyId, body, Context.NONE);
    }

    /**
     * Delete navigation property extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteExtensionPropertiesWithResponseAsync(String applicationId,
        String extensionPropertyId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteExtensionProperties(this.client.getEndpoint(), applicationId,
                extensionPropertyId, ifMatch, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete navigation property extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteExtensionPropertiesWithResponseAsync(String applicationId,
        String extensionPropertyId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteExtensionProperties(this.client.getEndpoint(), applicationId, extensionPropertyId, ifMatch,
            accept, context);
    }

    /**
     * Delete navigation property extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteExtensionPropertiesAsync(String applicationId, String extensionPropertyId) {
        final String ifMatch = null;
        return deleteExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, ifMatch)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete navigation property extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteExtensionPropertiesWithResponse(String applicationId, String extensionPropertyId,
        String ifMatch, Context context) {
        return deleteExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, ifMatch, context).block();
    }

    /**
     * Delete navigation property extensionProperties for applications.
     * 
     * @param applicationId key: id of application.
     * @param extensionPropertyId key: id of extensionProperty.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteExtensionProperties(String applicationId, String extensionPropertyId) {
        final String ifMatch = null;
        deleteExtensionPropertiesWithResponse(applicationId, extensionPropertyId, ifMatch, Context.NONE);
    }

    /**
     * Get homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from applications along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>>
        listHomeRealmDiscoveryPoliciesSinglePageAsync(String applicationId, Integer top, Integer skip, String search,
            String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select,
            List<ApplicationsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted = (orderby == null)
            ? null
            : orderby.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String expandConverted = (expand == null)
            ? null
            : expand.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.listHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId,
                top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, accept, context))
            .<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().odataNextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from applications along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>>
        listHomeRealmDiscoveryPoliciesSinglePageAsync(String applicationId, Integer top, Integer skip, String search,
            String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select,
            List<ApplicationsExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted = (orderby == null)
            ? null
            : orderby.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String expandConverted = (expand == null)
            ? null
            : expand.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return service
            .listHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId, top, skip, search, filter, count,
                orderbyConverted, selectConverted, expandConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().odataNextLink(), null));
    }

    /**
     * Get homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(
        String applicationId, Integer top, Integer skip, String search, String filter, Boolean count,
        List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<ApplicationsExpand> expand) {
        return new PagedFlux<>(() -> listHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search,
            filter, count, orderby, select, expand),
            nextLink -> listHomeRealmDiscoveryPoliciesNextSinglePageAsync(nextLink));
    }

    /**
     * Get homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner>
        listHomeRealmDiscoveryPoliciesAsync(String applicationId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ApplicationsOrderby> orderby = null;
        final List<ApplicationsSelect> select = null;
        final List<ApplicationsExpand> expand = null;
        return new PagedFlux<>(() -> listHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search,
            filter, count, orderby, select, expand),
            nextLink -> listHomeRealmDiscoveryPoliciesNextSinglePageAsync(nextLink));
    }

    /**
     * Get homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(
        String applicationId, Integer top, Integer skip, String search, String filter, Boolean count,
        List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<ApplicationsExpand> expand,
        Context context) {
        return new PagedFlux<>(
            () -> listHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search, filter, count,
                orderby, select, expand, context),
            nextLink -> listHomeRealmDiscoveryPoliciesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphHomeRealmDiscoveryPolicyInner>
        listHomeRealmDiscoveryPolicies(String applicationId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ApplicationsOrderby> orderby = null;
        final List<ApplicationsSelect> select = null;
        final List<ApplicationsExpand> expand = null;
        return new PagedIterable<>(listHomeRealmDiscoveryPoliciesAsync(applicationId, top, skip, search, filter, count,
            orderby, select, expand));
    }

    /**
     * Get homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPolicies(
        String applicationId, Integer top, Integer skip, String search, String filter, Boolean count,
        List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<ApplicationsExpand> expand,
        Context context) {
        return new PagedIterable<>(listHomeRealmDiscoveryPoliciesAsync(applicationId, top, skip, search, filter, count,
            orderby, select, expand, context));
    }

    /**
     * Get ref of homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from applications along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesSinglePageAsync(String applicationId,
        Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted = (orderby == null)
            ? null
            : orderby.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.listRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId,
                top, skip, search, filter, count, orderbyConverted, accept, context))
            .<PagedResponse<String>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().odataNextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get ref of homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from applications along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesSinglePageAsync(String applicationId,
        Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted = (orderby == null)
            ? null
            : orderby.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return service
            .listRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId, top, skip, search, filter,
                count, orderbyConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().odataNextLink(), null));
    }

    /**
     * Get ref of homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String applicationId, Integer top, Integer skip,
        String search, String filter, Boolean count, List<ApplicationsOrderby> orderby) {
        return new PagedFlux<>(() -> listRefHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search,
            filter, count, orderby), nextLink -> listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String applicationId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ApplicationsOrderby> orderby = null;
        return new PagedFlux<>(() -> listRefHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search,
            filter, count, orderby), nextLink -> listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String applicationId, Integer top, Integer skip,
        String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, Context context) {
        return new PagedFlux<>(() -> listRefHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search,
            filter, count, orderby, context),
            nextLink -> listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefHomeRealmDiscoveryPolicies(String applicationId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ApplicationsOrderby> orderby = null;
        return new PagedIterable<>(
            listRefHomeRealmDiscoveryPoliciesAsync(applicationId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of homeRealmDiscoveryPolicies from applications.
     * 
     * @param applicationId key: id of application.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from applications as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefHomeRealmDiscoveryPolicies(String applicationId, Integer top, Integer skip,
        String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, Context context) {
        return new PagedIterable<>(
            listRefHomeRealmDiscoveryPoliciesAsync(applicationId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to homeRealmDiscoveryPolicies for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;AnyObject&gt; along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>>
        createRefHomeRealmDiscoveryPoliciesWithResponseAsync(String applicationId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(),
                applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create new navigation property ref to homeRealmDiscoveryPolicies for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;AnyObject&gt; along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefHomeRealmDiscoveryPoliciesWithResponseAsync(
        String applicationId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId, body, accept,
            context);
    }

    /**
     * Create new navigation property ref to homeRealmDiscoveryPolicies for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;AnyObject&gt; on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefHomeRealmDiscoveryPoliciesAsync(String applicationId,
        Map<String, Object> body) {
        return createRefHomeRealmDiscoveryPoliciesWithResponseAsync(applicationId, body)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create new navigation property ref to homeRealmDiscoveryPolicies for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;AnyObject&gt; along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefHomeRealmDiscoveryPoliciesWithResponse(String applicationId,
        Map<String, Object> body, Context context) {
        return createRefHomeRealmDiscoveryPoliciesWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Create new navigation property ref to homeRealmDiscoveryPolicies for applications.
     * 
     * @param applicationId key: id of application.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;AnyObject&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefHomeRealmDiscoveryPolicies(String applicationId, Map<String, Object> body) {
        return createRefHomeRealmDiscoveryPoliciesWithResponse(applicationId, body, Context.NONE).getValue();
    }

    /**
     * Invoke action addKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(String applicationId,
        ApplicationsAddKeyRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.addKey(this.client.getEndpoint(), applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action addKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(String applicationId,
        ApplicationsAddKeyRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.addKey(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Invoke action addKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphKeyCredentialInner> addKeyAsync(String applicationId,
        ApplicationsAddKeyRequestBodyInner body) {
        return addKeyWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Invoke action addKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphKeyCredentialInner> addKeyWithResponse(String applicationId,
        ApplicationsAddKeyRequestBodyInner body, Context context) {
        return addKeyWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Invoke action addKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphKeyCredentialInner addKey(String applicationId, ApplicationsAddKeyRequestBodyInner body) {
        return addKeyWithResponse(applicationId, body, Context.NONE).getValue();
    }

    /**
     * Invoke action addPassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(String applicationId,
        ApplicationsAddPasswordRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.addPassword(this.client.getEndpoint(), applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action addPassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(String applicationId,
        ApplicationsAddPasswordRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.addPassword(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Invoke action addPassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphPasswordCredentialInner> addPasswordAsync(String applicationId,
        ApplicationsAddPasswordRequestBodyInner body) {
        return addPasswordWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Invoke action addPassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphPasswordCredentialInner> addPasswordWithResponse(String applicationId,
        ApplicationsAddPasswordRequestBodyInner body, Context context) {
        return addPasswordWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Invoke action addPassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphPasswordCredentialInner addPassword(String applicationId,
        ApplicationsAddPasswordRequestBodyInner body) {
        return addPasswordWithResponse(applicationId, body, Context.NONE).getValue();
    }

    /**
     * Invoke action checkMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String applicationId,
        ApplicationsCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.checkMemberGroups(this.client.getEndpoint(), applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action checkMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String applicationId,
        ApplicationsCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkMemberGroups(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Invoke action checkMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> checkMemberGroupsAsync(String applicationId,
        ApplicationsCheckMemberGroupsRequestBody body) {
        return checkMemberGroupsWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Invoke action checkMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> checkMemberGroupsWithResponse(String applicationId,
        ApplicationsCheckMemberGroupsRequestBody body, Context context) {
        return checkMemberGroupsWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Invoke action checkMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> checkMemberGroups(String applicationId, ApplicationsCheckMemberGroupsRequestBody body) {
        return checkMemberGroupsWithResponse(applicationId, body, Context.NONE).getValue();
    }

    /**
     * Invoke action checkMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String applicationId,
        ApplicationsCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.checkMemberObjects(this.client.getEndpoint(), applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action checkMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String applicationId,
        ApplicationsCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkMemberObjects(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Invoke action checkMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> checkMemberObjectsAsync(String applicationId,
        ApplicationsCheckMemberObjectsRequestBody body) {
        return checkMemberObjectsWithResponseAsync(applicationId, body)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Invoke action checkMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> checkMemberObjectsWithResponse(String applicationId,
        ApplicationsCheckMemberObjectsRequestBody body, Context context) {
        return checkMemberObjectsWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Invoke action checkMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> checkMemberObjects(String applicationId, ApplicationsCheckMemberObjectsRequestBody body) {
        return checkMemberObjectsWithResponse(applicationId, body, Context.NONE).getValue();
    }

    /**
     * Invoke action getMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String applicationId,
        ApplicationsGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getMemberGroups(this.client.getEndpoint(), applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action getMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String applicationId,
        ApplicationsGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getMemberGroups(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Invoke action getMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> getMemberGroupsAsync(String applicationId, ApplicationsGetMemberGroupsRequestBody body) {
        return getMemberGroupsWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Invoke action getMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> getMemberGroupsWithResponse(String applicationId,
        ApplicationsGetMemberGroupsRequestBody body, Context context) {
        return getMemberGroupsWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Invoke action getMemberGroups.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> getMemberGroups(String applicationId, ApplicationsGetMemberGroupsRequestBody body) {
        return getMemberGroupsWithResponse(applicationId, body, Context.NONE).getValue();
    }

    /**
     * Invoke action getMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String applicationId,
        ApplicationsGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getMemberObjects(this.client.getEndpoint(), applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action getMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String applicationId,
        ApplicationsGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getMemberObjects(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Invoke action getMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> getMemberObjectsAsync(String applicationId,
        ApplicationsGetMemberObjectsRequestBody body) {
        return getMemberObjectsWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Invoke action getMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> getMemberObjectsWithResponse(String applicationId,
        ApplicationsGetMemberObjectsRequestBody body, Context context) {
        return getMemberObjectsWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Invoke action getMemberObjects.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> getMemberObjects(String applicationId, ApplicationsGetMemberObjectsRequestBody body) {
        return getMemberObjectsWithResponse(applicationId, body, Context.NONE).getValue();
    }

    /**
     * Invoke action removeKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> removeKeyWithResponseAsync(String applicationId,
        ApplicationsRemoveKeyRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.removeKey(this.client.getEndpoint(), applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action removeKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> removeKeyWithResponseAsync(String applicationId, ApplicationsRemoveKeyRequestBody body,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.removeKey(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Invoke action removeKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> removeKeyAsync(String applicationId, ApplicationsRemoveKeyRequestBody body) {
        return removeKeyWithResponseAsync(applicationId, body).flatMap(ignored -> Mono.empty());
    }

    /**
     * Invoke action removeKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> removeKeyWithResponse(String applicationId, ApplicationsRemoveKeyRequestBody body,
        Context context) {
        return removeKeyWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Invoke action removeKey.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void removeKey(String applicationId, ApplicationsRemoveKeyRequestBody body) {
        removeKeyWithResponse(applicationId, body, Context.NONE);
    }

    /**
     * Invoke action removePassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> removePasswordWithResponseAsync(String applicationId,
        ApplicationsRemovePasswordRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.removePassword(this.client.getEndpoint(), applicationId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action removePassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> removePasswordWithResponseAsync(String applicationId,
        ApplicationsRemovePasswordRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.removePassword(this.client.getEndpoint(), applicationId, body, accept, context);
    }

    /**
     * Invoke action removePassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> removePasswordAsync(String applicationId, ApplicationsRemovePasswordRequestBody body) {
        return removePasswordWithResponseAsync(applicationId, body).flatMap(ignored -> Mono.empty());
    }

    /**
     * Invoke action removePassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> removePasswordWithResponse(String applicationId, ApplicationsRemovePasswordRequestBody body,
        Context context) {
        return removePasswordWithResponseAsync(applicationId, body, context).block();
    }

    /**
     * Invoke action removePassword.
     * 
     * @param applicationId key: id of application.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void removePassword(String applicationId, ApplicationsRemovePasswordRequestBody body) {
        removePasswordWithResponse(applicationId, body, Context.NONE);
    }

    /**
     * Invoke action restore.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.restore(this.client.getEndpoint(), applicationId, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action restore.
     * 
     * @param applicationId key: id of application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String applicationId,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.restore(this.client.getEndpoint(), applicationId, accept, context);
    }

    /**
     * Invoke action restore.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String applicationId) {
        return restoreWithResponseAsync(applicationId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Invoke action restore.
     * 
     * @param applicationId key: id of application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String applicationId, Context context) {
        return restoreWithResponseAsync(applicationId, context).block();
    }

    /**
     * Invoke action restore.
     * 
     * @param applicationId key: id of application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner restore(String applicationId) {
        return restoreWithResponse(applicationId, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extensionProperty along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionPropertyInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphExtensionPropertyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().odataNextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extensionProperty along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionPropertyInner>> listMoreSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.listMore(nextLink, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().odataNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of homeRealmDiscoveryPolicy along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>>
        listHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> service.listHomeRealmDiscoveryPoliciesNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().odataNextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of homeRealmDiscoveryPolicy along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>>
        listHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.listHomeRealmDiscoveryPoliciesNext(nextLink, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().odataNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of homeRealmDiscoveryPolicy along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> service.listRefHomeRealmDiscoveryPoliciesNext(nextLink, context))
            .<PagedResponse<String>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().odataNextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of homeRealmDiscoveryPolicy along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.listRefHomeRealmDiscoveryPoliciesNext(nextLink, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().odataNextLink(), null));
    }
}
