// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * workbookChart.
 */
@Fluent
public final class MicrosoftGraphWorkbookChart extends MicrosoftGraphEntity {
    /*
     * Represents the height, in points, of the chart object.
     */
    private Double height;

    /*
     * The distance, in points, from the left side of the chart to the worksheet origin.
     */
    private Double left;

    /*
     * Represents the name of a chart object.
     */
    private String name;

    /*
     * Represents the distance, in points, from the top edge of the object to the top of row 1 (on a worksheet) or the
     * top of the chart area (on a chart).
     */
    private Double top;

    /*
     * Represents the width, in points, of the chart object.
     */
    private Double width;

    /*
     * workbookChartAxes
     */
    private MicrosoftGraphWorkbookChartAxes axes;

    /*
     * workbookChartDataLabels
     */
    private MicrosoftGraphWorkbookChartDataLabels dataLabels;

    /*
     * workbookChartAreaFormat
     */
    private MicrosoftGraphWorkbookChartAreaFormat format;

    /*
     * workbookChartLegend
     */
    private MicrosoftGraphWorkbookChartLegend legend;

    /*
     * Represents either a single series or collection of series in the chart. Read-only.
     */
    private List<MicrosoftGraphWorkbookChartSeries> series;

    /*
     * workbookChartTitle
     */
    private MicrosoftGraphWorkbookChartTitle title;

    /*
     * workbookWorksheet
     */
    private MicrosoftGraphWorkbookWorksheet worksheet;

    /*
     * workbookChart
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChart class.
     */
    public MicrosoftGraphWorkbookChart() {
    }

    /**
     * Get the height property: Represents the height, in points, of the chart object.
     * 
     * @return the height value.
     */
    public Double height() {
        return this.height;
    }

    /**
     * Set the height property: Represents the height, in points, of the chart object.
     * 
     * @param height the height value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withHeight(Double height) {
        this.height = height;
        return this;
    }

    /**
     * Get the left property: The distance, in points, from the left side of the chart to the worksheet origin.
     * 
     * @return the left value.
     */
    public Double left() {
        return this.left;
    }

    /**
     * Set the left property: The distance, in points, from the left side of the chart to the worksheet origin.
     * 
     * @param left the left value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withLeft(Double left) {
        this.left = left;
        return this;
    }

    /**
     * Get the name property: Represents the name of a chart object.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Represents the name of a chart object.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the top property: Represents the distance, in points, from the top edge of the object to the top of row 1 (on
     * a worksheet) or the top of the chart area (on a chart).
     * 
     * @return the top value.
     */
    public Double top() {
        return this.top;
    }

    /**
     * Set the top property: Represents the distance, in points, from the top edge of the object to the top of row 1 (on
     * a worksheet) or the top of the chart area (on a chart).
     * 
     * @param top the top value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withTop(Double top) {
        this.top = top;
        return this;
    }

    /**
     * Get the width property: Represents the width, in points, of the chart object.
     * 
     * @return the width value.
     */
    public Double width() {
        return this.width;
    }

    /**
     * Set the width property: Represents the width, in points, of the chart object.
     * 
     * @param width the width value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withWidth(Double width) {
        this.width = width;
        return this;
    }

    /**
     * Get the axes property: workbookChartAxes.
     * 
     * @return the axes value.
     */
    public MicrosoftGraphWorkbookChartAxes axes() {
        return this.axes;
    }

    /**
     * Set the axes property: workbookChartAxes.
     * 
     * @param axes the axes value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withAxes(MicrosoftGraphWorkbookChartAxes axes) {
        this.axes = axes;
        return this;
    }

    /**
     * Get the dataLabels property: workbookChartDataLabels.
     * 
     * @return the dataLabels value.
     */
    public MicrosoftGraphWorkbookChartDataLabels dataLabels() {
        return this.dataLabels;
    }

    /**
     * Set the dataLabels property: workbookChartDataLabels.
     * 
     * @param dataLabels the dataLabels value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withDataLabels(MicrosoftGraphWorkbookChartDataLabels dataLabels) {
        this.dataLabels = dataLabels;
        return this;
    }

    /**
     * Get the format property: workbookChartAreaFormat.
     * 
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartAreaFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartAreaFormat.
     * 
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withFormat(MicrosoftGraphWorkbookChartAreaFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the legend property: workbookChartLegend.
     * 
     * @return the legend value.
     */
    public MicrosoftGraphWorkbookChartLegend legend() {
        return this.legend;
    }

    /**
     * Set the legend property: workbookChartLegend.
     * 
     * @param legend the legend value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withLegend(MicrosoftGraphWorkbookChartLegend legend) {
        this.legend = legend;
        return this;
    }

    /**
     * Get the series property: Represents either a single series or collection of series in the chart. Read-only.
     * 
     * @return the series value.
     */
    public List<MicrosoftGraphWorkbookChartSeries> series() {
        return this.series;
    }

    /**
     * Set the series property: Represents either a single series or collection of series in the chart. Read-only.
     * 
     * @param series the series value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withSeries(List<MicrosoftGraphWorkbookChartSeries> series) {
        this.series = series;
        return this;
    }

    /**
     * Get the title property: workbookChartTitle.
     * 
     * @return the title value.
     */
    public MicrosoftGraphWorkbookChartTitle title() {
        return this.title;
    }

    /**
     * Set the title property: workbookChartTitle.
     * 
     * @param title the title value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withTitle(MicrosoftGraphWorkbookChartTitle title) {
        this.title = title;
        return this;
    }

    /**
     * Get the worksheet property: workbookWorksheet.
     * 
     * @return the worksheet value.
     */
    public MicrosoftGraphWorkbookWorksheet worksheet() {
        return this.worksheet;
    }

    /**
     * Set the worksheet property: workbookWorksheet.
     * 
     * @param worksheet the worksheet value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withWorksheet(MicrosoftGraphWorkbookWorksheet worksheet) {
        this.worksheet = worksheet;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChart.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChart.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChart withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (axes() != null) {
            axes().validate();
        }
        if (dataLabels() != null) {
            dataLabels().validate();
        }
        if (format() != null) {
            format().validate();
        }
        if (legend() != null) {
            legend().validate();
        }
        if (series() != null) {
            series().forEach(e -> e.validate());
        }
        if (title() != null) {
            title().validate();
        }
        if (worksheet() != null) {
            worksheet().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeNumberField("height", this.height);
        jsonWriter.writeNumberField("left", this.left);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("top", this.top);
        jsonWriter.writeNumberField("width", this.width);
        jsonWriter.writeJsonField("axes", this.axes);
        jsonWriter.writeJsonField("dataLabels", this.dataLabels);
        jsonWriter.writeJsonField("format", this.format);
        jsonWriter.writeJsonField("legend", this.legend);
        jsonWriter.writeArrayField("series", this.series, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("title", this.title);
        jsonWriter.writeJsonField("worksheet", this.worksheet);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChart from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChart if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChart.
     */
    public static MicrosoftGraphWorkbookChart fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChart deserializedMicrosoftGraphWorkbookChart = new MicrosoftGraphWorkbookChart();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.withId(reader.getString());
                } else if ("height".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.height = reader.getNullable(JsonReader::getDouble);
                } else if ("left".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.left = reader.getNullable(JsonReader::getDouble);
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.name = reader.getString();
                } else if ("top".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.top = reader.getNullable(JsonReader::getDouble);
                } else if ("width".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.width = reader.getNullable(JsonReader::getDouble);
                } else if ("axes".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.axes = MicrosoftGraphWorkbookChartAxes.fromJson(reader);
                } else if ("dataLabels".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.dataLabels
                        = MicrosoftGraphWorkbookChartDataLabels.fromJson(reader);
                } else if ("format".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.format
                        = MicrosoftGraphWorkbookChartAreaFormat.fromJson(reader);
                } else if ("legend".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.legend = MicrosoftGraphWorkbookChartLegend.fromJson(reader);
                } else if ("series".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookChartSeries> series
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookChartSeries.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookChart.series = series;
                } else if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.title = MicrosoftGraphWorkbookChartTitle.fromJson(reader);
                } else if ("worksheet".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChart.worksheet
                        = MicrosoftGraphWorkbookWorksheet.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChart.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChart;
        });
    }
}
