// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * onenotePatchContentCommand.
 */
@Fluent
public final class MicrosoftGraphOnenotePatchContentCommand
    implements JsonSerializable<MicrosoftGraphOnenotePatchContentCommand> {
    /*
     * onenotePatchActionType
     */
    private MicrosoftGraphOnenotePatchActionType action;

    /*
     * A string of well-formed HTML to add to the page, and any image or file binary data. If the content contains
     * binary data, the request must be sent using the multipart/form-data content type with a 'Commands' part.
     */
    private String content;

    /*
     * onenotePatchInsertPosition
     */
    private MicrosoftGraphOnenotePatchInsertPosition position;

    /*
     * The element to update. Must be the #<data-id> or the generated <id> of the element, or the body or title keyword.
     */
    private String target;

    /*
     * onenotePatchContentCommand
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOnenotePatchContentCommand class.
     */
    public MicrosoftGraphOnenotePatchContentCommand() {
    }

    /**
     * Get the action property: onenotePatchActionType.
     * 
     * @return the action value.
     */
    public MicrosoftGraphOnenotePatchActionType action() {
        return this.action;
    }

    /**
     * Set the action property: onenotePatchActionType.
     * 
     * @param action the action value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withAction(MicrosoftGraphOnenotePatchActionType action) {
        this.action = action;
        return this;
    }

    /**
     * Get the content property: A string of well-formed HTML to add to the page, and any image or file binary data. If
     * the content contains binary data, the request must be sent using the multipart/form-data content type with a
     * 'Commands' part.
     * 
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: A string of well-formed HTML to add to the page, and any image or file binary data. If
     * the content contains binary data, the request must be sent using the multipart/form-data content type with a
     * 'Commands' part.
     * 
     * @param content the content value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the position property: onenotePatchInsertPosition.
     * 
     * @return the position value.
     */
    public MicrosoftGraphOnenotePatchInsertPosition position() {
        return this.position;
    }

    /**
     * Set the position property: onenotePatchInsertPosition.
     * 
     * @param position the position value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withPosition(MicrosoftGraphOnenotePatchInsertPosition position) {
        this.position = position;
        return this;
    }

    /**
     * Get the target property: The element to update. Must be the #&lt;data-id&gt; or the generated &lt;id&gt; of the
     * element, or the body or title keyword.
     * 
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target property: The element to update. Must be the #&lt;data-id&gt; or the generated &lt;id&gt; of the
     * element, or the body or title keyword.
     * 
     * @param target the target value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the additionalProperties property: onenotePatchContentCommand.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenotePatchContentCommand.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenotePatchContentCommand object itself.
     */
    public MicrosoftGraphOnenotePatchContentCommand withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("position", this.position == null ? null : this.position.toString());
        jsonWriter.writeStringField("target", this.target);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOnenotePatchContentCommand from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOnenotePatchContentCommand if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOnenotePatchContentCommand.
     */
    public static MicrosoftGraphOnenotePatchContentCommand fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOnenotePatchContentCommand deserializedMicrosoftGraphOnenotePatchContentCommand
                = new MicrosoftGraphOnenotePatchContentCommand();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("action".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePatchContentCommand.action
                        = MicrosoftGraphOnenotePatchActionType.fromString(reader.getString());
                } else if ("content".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePatchContentCommand.content = reader.getString();
                } else if ("position".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePatchContentCommand.position
                        = MicrosoftGraphOnenotePatchInsertPosition.fromString(reader.getString());
                } else if ("target".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePatchContentCommand.target = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOnenotePatchContentCommand.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOnenotePatchContentCommand;
        });
    }
}
