// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * chatMessage.
 */
@Fluent
public final class MicrosoftGraphChatMessage extends MicrosoftGraphEntity {
    /*
     * Attached files. Attachments are currently read-only – sending attachments is not supported.
     */
    private List<MicrosoftGraphChatMessageAttachment> attachments;

    /*
     * itemBody
     */
    private MicrosoftGraphItemBody body;

    /*
     * Read only. Timestamp of when the chat message was created.
     */
    private OffsetDateTime createdDateTime;

    /*
     * Read only. Timestamp at which the chat message was deleted, or null if not deleted.
     */
    private OffsetDateTime deletedDateTime;

    /*
     * Read-only. Version number of the chat message.
     */
    private String etag;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet from;

    /*
     * chatMessageImportance
     */
    private MicrosoftGraphChatMessageImportance importance;

    /*
     * Read only. Timestamp when edits to the chat message were made. Triggers an 'Edited' flag in the Microsoft Teams
     * UI. If no edits are made the value is null.
     */
    private OffsetDateTime lastEditedDateTime;

    /*
     * Read only. Timestamp when the chat message is created (initial setting) or edited, including when a reaction is
     * added or removed.
     */
    private OffsetDateTime lastModifiedDateTime;

    /*
     * Locale of the chat message set by the client.
     */
    private String locale;

    /*
     * List of entities mentioned in the chat message. Currently supports user, bot, team, channel.
     */
    private List<MicrosoftGraphChatMessageMention> mentions;

    /*
     * chatMessageType
     */
    private MicrosoftGraphChatMessageType messageType;

    /*
     * chatMessagePolicyViolation
     */
    private MicrosoftGraphChatMessagePolicyViolation policyViolation;

    /*
     * The reactions property.
     */
    private List<MicrosoftGraphChatMessageReaction> reactions;

    /*
     * Read-only. Id of the parent chat message or root chat message of the thread. (Only applies to chat messages in
     * channels not chats)
     */
    private String replyToId;

    /*
     * The subject of the chat message, in plaintext.
     */
    private String subject;

    /*
     * Summary text of the chat message that could be used for push notifications and summary views or fall back views.
     * Only applies to channel chat messages, not chat messages in a chat.
     */
    private String summary;

    /*
     * The webUrl property.
     */
    private String webUrl;

    /*
     * The hostedContents property.
     */
    private List<MicrosoftGraphChatMessageHostedContent> hostedContents;

    /*
     * The replies property.
     */
    private List<MicrosoftGraphChatMessage> replies;

    /*
     * chatMessage
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphChatMessage class.
     */
    public MicrosoftGraphChatMessage() {
    }

    /**
     * Get the attachments property: Attached files. Attachments are currently read-only – sending attachments is not
     * supported.
     * 
     * @return the attachments value.
     */
    public List<MicrosoftGraphChatMessageAttachment> attachments() {
        return this.attachments;
    }

    /**
     * Set the attachments property: Attached files. Attachments are currently read-only – sending attachments is not
     * supported.
     * 
     * @param attachments the attachments value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withAttachments(List<MicrosoftGraphChatMessageAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    /**
     * Get the body property: itemBody.
     * 
     * @return the body value.
     */
    public MicrosoftGraphItemBody body() {
        return this.body;
    }

    /**
     * Set the body property: itemBody.
     * 
     * @param body the body value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withBody(MicrosoftGraphItemBody body) {
        this.body = body;
        return this;
    }

    /**
     * Get the createdDateTime property: Read only. Timestamp of when the chat message was created.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Read only. Timestamp of when the chat message was created.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the deletedDateTime property: Read only. Timestamp at which the chat message was deleted, or null if not
     * deleted.
     * 
     * @return the deletedDateTime value.
     */
    public OffsetDateTime deletedDateTime() {
        return this.deletedDateTime;
    }

    /**
     * Set the deletedDateTime property: Read only. Timestamp at which the chat message was deleted, or null if not
     * deleted.
     * 
     * @param deletedDateTime the deletedDateTime value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withDeletedDateTime(OffsetDateTime deletedDateTime) {
        this.deletedDateTime = deletedDateTime;
        return this;
    }

    /**
     * Get the etag property: Read-only. Version number of the chat message.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: Read-only. Version number of the chat message.
     * 
     * @param etag the etag value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the from property: identitySet.
     * 
     * @return the from value.
     */
    public MicrosoftGraphIdentitySet from() {
        return this.from;
    }

    /**
     * Set the from property: identitySet.
     * 
     * @param from the from value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withFrom(MicrosoftGraphIdentitySet from) {
        this.from = from;
        return this;
    }

    /**
     * Get the importance property: chatMessageImportance.
     * 
     * @return the importance value.
     */
    public MicrosoftGraphChatMessageImportance importance() {
        return this.importance;
    }

    /**
     * Set the importance property: chatMessageImportance.
     * 
     * @param importance the importance value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withImportance(MicrosoftGraphChatMessageImportance importance) {
        this.importance = importance;
        return this;
    }

    /**
     * Get the lastEditedDateTime property: Read only. Timestamp when edits to the chat message were made. Triggers an
     * 'Edited' flag in the Microsoft Teams UI. If no edits are made the value is null.
     * 
     * @return the lastEditedDateTime value.
     */
    public OffsetDateTime lastEditedDateTime() {
        return this.lastEditedDateTime;
    }

    /**
     * Set the lastEditedDateTime property: Read only. Timestamp when edits to the chat message were made. Triggers an
     * 'Edited' flag in the Microsoft Teams UI. If no edits are made the value is null.
     * 
     * @param lastEditedDateTime the lastEditedDateTime value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withLastEditedDateTime(OffsetDateTime lastEditedDateTime) {
        this.lastEditedDateTime = lastEditedDateTime;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: Read only. Timestamp when the chat message is created (initial setting) or
     * edited, including when a reaction is added or removed.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: Read only. Timestamp when the chat message is created (initial setting) or
     * edited, including when a reaction is added or removed.
     * 
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the locale property: Locale of the chat message set by the client.
     * 
     * @return the locale value.
     */
    public String locale() {
        return this.locale;
    }

    /**
     * Set the locale property: Locale of the chat message set by the client.
     * 
     * @param locale the locale value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withLocale(String locale) {
        this.locale = locale;
        return this;
    }

    /**
     * Get the mentions property: List of entities mentioned in the chat message. Currently supports user, bot, team,
     * channel.
     * 
     * @return the mentions value.
     */
    public List<MicrosoftGraphChatMessageMention> mentions() {
        return this.mentions;
    }

    /**
     * Set the mentions property: List of entities mentioned in the chat message. Currently supports user, bot, team,
     * channel.
     * 
     * @param mentions the mentions value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withMentions(List<MicrosoftGraphChatMessageMention> mentions) {
        this.mentions = mentions;
        return this;
    }

    /**
     * Get the messageType property: chatMessageType.
     * 
     * @return the messageType value.
     */
    public MicrosoftGraphChatMessageType messageType() {
        return this.messageType;
    }

    /**
     * Set the messageType property: chatMessageType.
     * 
     * @param messageType the messageType value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withMessageType(MicrosoftGraphChatMessageType messageType) {
        this.messageType = messageType;
        return this;
    }

    /**
     * Get the policyViolation property: chatMessagePolicyViolation.
     * 
     * @return the policyViolation value.
     */
    public MicrosoftGraphChatMessagePolicyViolation policyViolation() {
        return this.policyViolation;
    }

    /**
     * Set the policyViolation property: chatMessagePolicyViolation.
     * 
     * @param policyViolation the policyViolation value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withPolicyViolation(MicrosoftGraphChatMessagePolicyViolation policyViolation) {
        this.policyViolation = policyViolation;
        return this;
    }

    /**
     * Get the reactions property: The reactions property.
     * 
     * @return the reactions value.
     */
    public List<MicrosoftGraphChatMessageReaction> reactions() {
        return this.reactions;
    }

    /**
     * Set the reactions property: The reactions property.
     * 
     * @param reactions the reactions value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withReactions(List<MicrosoftGraphChatMessageReaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    /**
     * Get the replyToId property: Read-only. Id of the parent chat message or root chat message of the thread. (Only
     * applies to chat messages in channels not chats).
     * 
     * @return the replyToId value.
     */
    public String replyToId() {
        return this.replyToId;
    }

    /**
     * Set the replyToId property: Read-only. Id of the parent chat message or root chat message of the thread. (Only
     * applies to chat messages in channels not chats).
     * 
     * @param replyToId the replyToId value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withReplyToId(String replyToId) {
        this.replyToId = replyToId;
        return this;
    }

    /**
     * Get the subject property: The subject of the chat message, in plaintext.
     * 
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: The subject of the chat message, in plaintext.
     * 
     * @param subject the subject value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the summary property: Summary text of the chat message that could be used for push notifications and summary
     * views or fall back views. Only applies to channel chat messages, not chat messages in a chat.
     * 
     * @return the summary value.
     */
    public String summary() {
        return this.summary;
    }

    /**
     * Set the summary property: Summary text of the chat message that could be used for push notifications and summary
     * views or fall back views. Only applies to channel chat messages, not chat messages in a chat.
     * 
     * @param summary the summary value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    /**
     * Get the webUrl property: The webUrl property.
     * 
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: The webUrl property.
     * 
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the hostedContents property: The hostedContents property.
     * 
     * @return the hostedContents value.
     */
    public List<MicrosoftGraphChatMessageHostedContent> hostedContents() {
        return this.hostedContents;
    }

    /**
     * Set the hostedContents property: The hostedContents property.
     * 
     * @param hostedContents the hostedContents value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withHostedContents(List<MicrosoftGraphChatMessageHostedContent> hostedContents) {
        this.hostedContents = hostedContents;
        return this;
    }

    /**
     * Get the replies property: The replies property.
     * 
     * @return the replies value.
     */
    public List<MicrosoftGraphChatMessage> replies() {
        return this.replies;
    }

    /**
     * Set the replies property: The replies property.
     * 
     * @param replies the replies value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withReplies(List<MicrosoftGraphChatMessage> replies) {
        this.replies = replies;
        return this;
    }

    /**
     * Get the additionalProperties property: chatMessage.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: chatMessage.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChatMessage object itself.
     */
    public MicrosoftGraphChatMessage withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphChatMessage withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (attachments() != null) {
            attachments().forEach(e -> e.validate());
        }
        if (body() != null) {
            body().validate();
        }
        if (from() != null) {
            from().validate();
        }
        if (mentions() != null) {
            mentions().forEach(e -> e.validate());
        }
        if (policyViolation() != null) {
            policyViolation().validate();
        }
        if (reactions() != null) {
            reactions().forEach(e -> e.validate());
        }
        if (hostedContents() != null) {
            hostedContents().forEach(e -> e.validate());
        }
        if (replies() != null) {
            replies().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("body", this.body);
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("deletedDateTime",
            this.deletedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime));
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("from", this.from);
        jsonWriter.writeStringField("importance", this.importance == null ? null : this.importance.toString());
        jsonWriter.writeStringField("lastEditedDateTime",
            this.lastEditedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastEditedDateTime));
        jsonWriter.writeStringField("lastModifiedDateTime",
            this.lastModifiedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("locale", this.locale);
        jsonWriter.writeArrayField("mentions", this.mentions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("messageType", this.messageType == null ? null : this.messageType.toString());
        jsonWriter.writeJsonField("policyViolation", this.policyViolation);
        jsonWriter.writeArrayField("reactions", this.reactions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("replyToId", this.replyToId);
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeStringField("summary", this.summary);
        jsonWriter.writeStringField("webUrl", this.webUrl);
        jsonWriter.writeArrayField("hostedContents", this.hostedContents,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("replies", this.replies, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphChatMessage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphChatMessage if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphChatMessage.
     */
    public static MicrosoftGraphChatMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphChatMessage deserializedMicrosoftGraphChatMessage = new MicrosoftGraphChatMessage();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.withId(reader.getString());
                } else if ("attachments".equals(fieldName)) {
                    List<MicrosoftGraphChatMessageAttachment> attachments
                        = reader.readArray(reader1 -> MicrosoftGraphChatMessageAttachment.fromJson(reader1));
                    deserializedMicrosoftGraphChatMessage.attachments = attachments;
                } else if ("body".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.body = MicrosoftGraphItemBody.fromJson(reader);
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.deletedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("etag".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.etag = reader.getString();
                } else if ("from".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.from = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("importance".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.importance
                        = MicrosoftGraphChatMessageImportance.fromString(reader.getString());
                } else if ("lastEditedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.lastEditedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.lastModifiedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("locale".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.locale = reader.getString();
                } else if ("mentions".equals(fieldName)) {
                    List<MicrosoftGraphChatMessageMention> mentions
                        = reader.readArray(reader1 -> MicrosoftGraphChatMessageMention.fromJson(reader1));
                    deserializedMicrosoftGraphChatMessage.mentions = mentions;
                } else if ("messageType".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.messageType
                        = MicrosoftGraphChatMessageType.fromString(reader.getString());
                } else if ("policyViolation".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.policyViolation
                        = MicrosoftGraphChatMessagePolicyViolation.fromJson(reader);
                } else if ("reactions".equals(fieldName)) {
                    List<MicrosoftGraphChatMessageReaction> reactions
                        = reader.readArray(reader1 -> MicrosoftGraphChatMessageReaction.fromJson(reader1));
                    deserializedMicrosoftGraphChatMessage.reactions = reactions;
                } else if ("replyToId".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.replyToId = reader.getString();
                } else if ("subject".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.subject = reader.getString();
                } else if ("summary".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.summary = reader.getString();
                } else if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessage.webUrl = reader.getString();
                } else if ("hostedContents".equals(fieldName)) {
                    List<MicrosoftGraphChatMessageHostedContent> hostedContents
                        = reader.readArray(reader1 -> MicrosoftGraphChatMessageHostedContent.fromJson(reader1));
                    deserializedMicrosoftGraphChatMessage.hostedContents = hostedContents;
                } else if ("replies".equals(fieldName)) {
                    List<MicrosoftGraphChatMessage> replies
                        = reader.readArray(reader1 -> MicrosoftGraphChatMessage.fromJson(reader1));
                    deserializedMicrosoftGraphChatMessage.replies = replies;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphChatMessage.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphChatMessage;
        });
    }
}
