// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * numberColumn.
 */
@Fluent
public final class MicrosoftGraphNumberColumn implements JsonSerializable<MicrosoftGraphNumberColumn> {
    /*
     * How many decimal places to display. See below for information about the possible values.
     */
    private String decimalPlaces;

    /*
     * How the value should be presented in the UX. Must be one of number or percentage. If unspecified, treated as
     * number.
     */
    private String displayAs;

    /*
     * The maximum permitted value.
     */
    private Double maximum;

    /*
     * The minimum permitted value.
     */
    private Double minimum;

    /*
     * numberColumn
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphNumberColumn class.
     */
    public MicrosoftGraphNumberColumn() {
    }

    /**
     * Get the decimalPlaces property: How many decimal places to display. See below for information about the possible
     * values.
     * 
     * @return the decimalPlaces value.
     */
    public String decimalPlaces() {
        return this.decimalPlaces;
    }

    /**
     * Set the decimalPlaces property: How many decimal places to display. See below for information about the possible
     * values.
     * 
     * @param decimalPlaces the decimalPlaces value to set.
     * @return the MicrosoftGraphNumberColumn object itself.
     */
    public MicrosoftGraphNumberColumn withDecimalPlaces(String decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        return this;
    }

    /**
     * Get the displayAs property: How the value should be presented in the UX. Must be one of number or percentage. If
     * unspecified, treated as number.
     * 
     * @return the displayAs value.
     */
    public String displayAs() {
        return this.displayAs;
    }

    /**
     * Set the displayAs property: How the value should be presented in the UX. Must be one of number or percentage. If
     * unspecified, treated as number.
     * 
     * @param displayAs the displayAs value to set.
     * @return the MicrosoftGraphNumberColumn object itself.
     */
    public MicrosoftGraphNumberColumn withDisplayAs(String displayAs) {
        this.displayAs = displayAs;
        return this;
    }

    /**
     * Get the maximum property: The maximum permitted value.
     * 
     * @return the maximum value.
     */
    public Double maximum() {
        return this.maximum;
    }

    /**
     * Set the maximum property: The maximum permitted value.
     * 
     * @param maximum the maximum value to set.
     * @return the MicrosoftGraphNumberColumn object itself.
     */
    public MicrosoftGraphNumberColumn withMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    /**
     * Get the minimum property: The minimum permitted value.
     * 
     * @return the minimum value.
     */
    public Double minimum() {
        return this.minimum;
    }

    /**
     * Set the minimum property: The minimum permitted value.
     * 
     * @param minimum the minimum value to set.
     * @return the MicrosoftGraphNumberColumn object itself.
     */
    public MicrosoftGraphNumberColumn withMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    /**
     * Get the additionalProperties property: numberColumn.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: numberColumn.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphNumberColumn object itself.
     */
    public MicrosoftGraphNumberColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("decimalPlaces", this.decimalPlaces);
        jsonWriter.writeStringField("displayAs", this.displayAs);
        jsonWriter.writeNumberField("maximum", this.maximum);
        jsonWriter.writeNumberField("minimum", this.minimum);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphNumberColumn from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphNumberColumn if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphNumberColumn.
     */
    public static MicrosoftGraphNumberColumn fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphNumberColumn deserializedMicrosoftGraphNumberColumn = new MicrosoftGraphNumberColumn();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("decimalPlaces".equals(fieldName)) {
                    deserializedMicrosoftGraphNumberColumn.decimalPlaces = reader.getString();
                } else if ("displayAs".equals(fieldName)) {
                    deserializedMicrosoftGraphNumberColumn.displayAs = reader.getString();
                } else if ("maximum".equals(fieldName)) {
                    deserializedMicrosoftGraphNumberColumn.maximum = reader.getNullable(JsonReader::getDouble);
                } else if ("minimum".equals(fieldName)) {
                    deserializedMicrosoftGraphNumberColumn.minimum = reader.getNullable(JsonReader::getDouble);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphNumberColumn.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphNumberColumn;
        });
    }
}
