// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Schedule info of the role eligibility schedule. */
@Fluent
public final class RoleEligibilityScheduleRequestPropertiesScheduleInfo {
    /*
     * Start DateTime of the role eligibility schedule.
     */
    @JsonProperty(value = "startDateTime")
    private OffsetDateTime startDateTime;

    /*
     * Expiration of the role eligibility schedule
     */
    @JsonProperty(value = "expiration")
    private RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration expiration;

    /** Creates an instance of RoleEligibilityScheduleRequestPropertiesScheduleInfo class. */
    public RoleEligibilityScheduleRequestPropertiesScheduleInfo() {
    }

    /**
     * Get the startDateTime property: Start DateTime of the role eligibility schedule.
     *
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: Start DateTime of the role eligibility schedule.
     *
     * @param startDateTime the startDateTime value to set.
     * @return the RoleEligibilityScheduleRequestPropertiesScheduleInfo object itself.
     */
    public RoleEligibilityScheduleRequestPropertiesScheduleInfo withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the expiration property: Expiration of the role eligibility schedule.
     *
     * @return the expiration value.
     */
    public RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration expiration() {
        return this.expiration;
    }

    /**
     * Set the expiration property: Expiration of the role eligibility schedule.
     *
     * @param expiration the expiration value to set.
     * @return the RoleEligibilityScheduleRequestPropertiesScheduleInfo object itself.
     */
    public RoleEligibilityScheduleRequestPropertiesScheduleInfo withExpiration(
        RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (expiration() != null) {
            expiration().validate();
        }
    }
}
