// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** objectIdentity. */
@Fluent
public final class MicrosoftGraphObjectIdentity {
    /*
     * Specifies the issuer of the identity, for example facebook.com.For local accounts (where signInType is not
     * federated), this property is the local B2C tenant default domain name, for example contoso.onmicrosoft.com.For
     * external users from other Azure AD organization, this will be the domain of the federated organization, for
     * example contoso.com.Supports $filter. 512 character limit.
     */
    @JsonProperty(value = "issuer")
    private String issuer;

    /*
     * Specifies the unique identifier assigned to the user by the issuer. The combination of issuer and
     * issuerAssignedId must be unique within the organization. Represents the sign-in name for the user, when
     * signInType is set to emailAddress or userName (also known as local accounts).When signInType is set to:
     * emailAddress, (or starts with emailAddress like emailAddress1) issuerAssignedId must be a valid email
     * addressuserName, issuerAssignedId must be a valid local part of an email addressSupports $filter. 512 character
     * limit.
     */
    @JsonProperty(value = "issuerAssignedId")
    private String issuerAssignedId;

    /*
     * Specifies the user sign-in types in your directory, such as emailAddress, userName or federated. Here, federated
     * represents a unique identifier for a user from an issuer, that can be in any format chosen by the issuer.
     * Additional validation is enforced on issuerAssignedId when the sign-in type is set to emailAddress or userName.
     * This property can also be set to any custom string.
     */
    @JsonProperty(value = "signInType")
    private String signInType;

    /*
     * objectIdentity
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphObjectIdentity class. */
    public MicrosoftGraphObjectIdentity() {
    }

    /**
     * Get the issuer property: Specifies the issuer of the identity, for example facebook.com.For local accounts (where
     * signInType is not federated), this property is the local B2C tenant default domain name, for example
     * contoso.onmicrosoft.com.For external users from other Azure AD organization, this will be the domain of the
     * federated organization, for example contoso.com.Supports $filter. 512 character limit.
     *
     * @return the issuer value.
     */
    public String issuer() {
        return this.issuer;
    }

    /**
     * Set the issuer property: Specifies the issuer of the identity, for example facebook.com.For local accounts (where
     * signInType is not federated), this property is the local B2C tenant default domain name, for example
     * contoso.onmicrosoft.com.For external users from other Azure AD organization, this will be the domain of the
     * federated organization, for example contoso.com.Supports $filter. 512 character limit.
     *
     * @param issuer the issuer value to set.
     * @return the MicrosoftGraphObjectIdentity object itself.
     */
    public MicrosoftGraphObjectIdentity withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    /**
     * Get the issuerAssignedId property: Specifies the unique identifier assigned to the user by the issuer. The
     * combination of issuer and issuerAssignedId must be unique within the organization. Represents the sign-in name
     * for the user, when signInType is set to emailAddress or userName (also known as local accounts).When signInType
     * is set to: emailAddress, (or starts with emailAddress like emailAddress1) issuerAssignedId must be a valid email
     * addressuserName, issuerAssignedId must be a valid local part of an email addressSupports $filter. 512 character
     * limit.
     *
     * @return the issuerAssignedId value.
     */
    public String issuerAssignedId() {
        return this.issuerAssignedId;
    }

    /**
     * Set the issuerAssignedId property: Specifies the unique identifier assigned to the user by the issuer. The
     * combination of issuer and issuerAssignedId must be unique within the organization. Represents the sign-in name
     * for the user, when signInType is set to emailAddress or userName (also known as local accounts).When signInType
     * is set to: emailAddress, (or starts with emailAddress like emailAddress1) issuerAssignedId must be a valid email
     * addressuserName, issuerAssignedId must be a valid local part of an email addressSupports $filter. 512 character
     * limit.
     *
     * @param issuerAssignedId the issuerAssignedId value to set.
     * @return the MicrosoftGraphObjectIdentity object itself.
     */
    public MicrosoftGraphObjectIdentity withIssuerAssignedId(String issuerAssignedId) {
        this.issuerAssignedId = issuerAssignedId;
        return this;
    }

    /**
     * Get the signInType property: Specifies the user sign-in types in your directory, such as emailAddress, userName
     * or federated. Here, federated represents a unique identifier for a user from an issuer, that can be in any format
     * chosen by the issuer. Additional validation is enforced on issuerAssignedId when the sign-in type is set to
     * emailAddress or userName. This property can also be set to any custom string.
     *
     * @return the signInType value.
     */
    public String signInType() {
        return this.signInType;
    }

    /**
     * Set the signInType property: Specifies the user sign-in types in your directory, such as emailAddress, userName
     * or federated. Here, federated represents a unique identifier for a user from an issuer, that can be in any format
     * chosen by the issuer. Additional validation is enforced on issuerAssignedId when the sign-in type is set to
     * emailAddress or userName. This property can also be set to any custom string.
     *
     * @param signInType the signInType value to set.
     * @return the MicrosoftGraphObjectIdentity object itself.
     */
    public MicrosoftGraphObjectIdentity withSignInType(String signInType) {
        this.signInType = signInType;
        return this;
    }

    /**
     * Get the additionalProperties property: objectIdentity.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: objectIdentity.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphObjectIdentity object itself.
     */
    public MicrosoftGraphObjectIdentity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
