/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphServicePrincipalInner;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplication;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryObject;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.models.CertificateCredential;
import com.azure.resourcemanager.authorization.models.PasswordCredential;
import com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ServicePrincipal
extends ActiveDirectoryObject,
HasInnerModel<MicrosoftGraphServicePrincipalInner>,
Updatable<Update> {
    public String applicationId();

    public List<String> servicePrincipalNames();

    public Map<String, PasswordCredential> passwordCredentials();

    public Map<String, CertificateCredential> certificateCredentials();

    public Set<RoleAssignment> roleAssignments();

    public static interface Update
    extends Appliable<ServicePrincipal>,
    UpdateStages.WithCredential,
    UpdateStages.WithRoleAssignment {
    }

    public static interface UpdateStages {

        public static interface WithRoleAssignment {
            public Update withNewRole(BuiltInRole var1, String var2);

            public Update withNewRoleInSubscription(BuiltInRole var1, String var2);

            public Update withNewRoleInResourceGroup(BuiltInRole var1, ResourceGroup var2);

            public Update withoutRole(RoleAssignment var1);
        }

        public static interface WithCredential {
            public CertificateCredential.DefinitionStages.Blank<? extends Update> defineCertificateCredential(String var1);

            public PasswordCredential.DefinitionStages.Blank<? extends Update> definePasswordCredential(String var1);

            public Update withoutCredential(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ServicePrincipal>,
        WithCredential,
        WithRoleAssignment {
        }

        public static interface WithRoleAssignment {
            public WithCreate withNewRole(BuiltInRole var1, String var2);

            public WithCreate withNewRoleInSubscription(BuiltInRole var1, String var2);

            public WithCreate withNewRoleInResourceGroup(BuiltInRole var1, ResourceGroup var2);
        }

        public static interface WithCredential {
            public CertificateCredential.DefinitionStages.Blank<? extends WithCreate> defineCertificateCredential(String var1);

            public PasswordCredential.DefinitionStages.Blank<? extends WithCreate> definePasswordCredential(String var1);
        }

        public static interface WithApplication {
            public WithCreate withExistingApplication(String var1);

            public WithCreate withExistingApplication(ActiveDirectoryApplication var1);

            public WithCreate withNewApplication(Creatable<ActiveDirectoryApplication> var1);

            public WithCreate withNewApplication(String var1);

            public WithCreate withNewApplication();
        }

        public static interface Blank
        extends WithApplication {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

