// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** thumbnail. */
@Fluent
public final class MicrosoftGraphThumbnail {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * The content stream for the thumbnail.
     */
    @JsonProperty(value = "content")
    private Base64Url content;

    /*
     * The height of the thumbnail, in pixels.
     */
    @JsonProperty(value = "height")
    private Integer height;

    /*
     * The unique identifier of the item that provided the thumbnail. This is only available when a folder thumbnail is
     * requested.
     */
    @JsonProperty(value = "sourceItemId")
    private String sourceItemId;

    /*
     * The URL used to fetch the thumbnail content.
     */
    @JsonProperty(value = "url")
    private String url;

    /*
     * The width of the thumbnail, in pixels.
     */
    @JsonProperty(value = "width")
    private Integer width;

    /*
     * thumbnail
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphThumbnail class. */
    public MicrosoftGraphThumbnail() {
    }

    /**
     * Get the content property: The content stream for the thumbnail.
     *
     * @return the content value.
     */
    public byte[] content() {
        if (this.content == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.content.decodedBytes();
    }

    /**
     * Set the content property: The content stream for the thumbnail.
     *
     * @param content the content value to set.
     * @return the MicrosoftGraphThumbnail object itself.
     */
    public MicrosoftGraphThumbnail withContent(byte[] content) {
        if (content == null) {
            this.content = null;
        } else {
            this.content = Base64Url.encode(CoreUtils.clone(content));
        }
        return this;
    }

    /**
     * Get the height property: The height of the thumbnail, in pixels.
     *
     * @return the height value.
     */
    public Integer height() {
        return this.height;
    }

    /**
     * Set the height property: The height of the thumbnail, in pixels.
     *
     * @param height the height value to set.
     * @return the MicrosoftGraphThumbnail object itself.
     */
    public MicrosoftGraphThumbnail withHeight(Integer height) {
        this.height = height;
        return this;
    }

    /**
     * Get the sourceItemId property: The unique identifier of the item that provided the thumbnail. This is only
     * available when a folder thumbnail is requested.
     *
     * @return the sourceItemId value.
     */
    public String sourceItemId() {
        return this.sourceItemId;
    }

    /**
     * Set the sourceItemId property: The unique identifier of the item that provided the thumbnail. This is only
     * available when a folder thumbnail is requested.
     *
     * @param sourceItemId the sourceItemId value to set.
     * @return the MicrosoftGraphThumbnail object itself.
     */
    public MicrosoftGraphThumbnail withSourceItemId(String sourceItemId) {
        this.sourceItemId = sourceItemId;
        return this;
    }

    /**
     * Get the url property: The URL used to fetch the thumbnail content.
     *
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: The URL used to fetch the thumbnail content.
     *
     * @param url the url value to set.
     * @return the MicrosoftGraphThumbnail object itself.
     */
    public MicrosoftGraphThumbnail withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the width property: The width of the thumbnail, in pixels.
     *
     * @return the width value.
     */
    public Integer width() {
        return this.width;
    }

    /**
     * Set the width property: The width of the thumbnail, in pixels.
     *
     * @param width the width value to set.
     * @return the MicrosoftGraphThumbnail object itself.
     */
    public MicrosoftGraphThumbnail withWidth(Integer width) {
        this.width = width;
        return this;
    }

    /**
     * Get the additionalProperties property: thumbnail.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: thumbnail.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphThumbnail object itself.
     */
    public MicrosoftGraphThumbnail withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
