// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** openShiftItem. */
@Fluent
public final class MicrosoftGraphOpenShiftItem extends MicrosoftGraphShiftItem {
    /*
     * Count of the number of slots for the given open shift.
     */
    @JsonProperty(value = "openSlotCount")
    private Integer openSlotCount;

    /*
     * openShiftItem
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphOpenShiftItem class. */
    public MicrosoftGraphOpenShiftItem() {
    }

    /**
     * Get the openSlotCount property: Count of the number of slots for the given open shift.
     *
     * @return the openSlotCount value.
     */
    public Integer openSlotCount() {
        return this.openSlotCount;
    }

    /**
     * Set the openSlotCount property: Count of the number of slots for the given open shift.
     *
     * @param openSlotCount the openSlotCount value to set.
     * @return the MicrosoftGraphOpenShiftItem object itself.
     */
    public MicrosoftGraphOpenShiftItem withOpenSlotCount(Integer openSlotCount) {
        this.openSlotCount = openSlotCount;
        return this;
    }

    /**
     * Get the additionalProperties property: openShiftItem.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: openShiftItem.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOpenShiftItem object itself.
     */
    public MicrosoftGraphOpenShiftItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftItem withActivities(List<MicrosoftGraphShiftActivity> activities) {
        super.withActivities(activities);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftItem withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftItem withNotes(String notes) {
        super.withNotes(notes);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftItem withEndDateTime(OffsetDateTime endDateTime) {
        super.withEndDateTime(endDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftItem withStartDateTime(OffsetDateTime startDateTime) {
        super.withStartDateTime(startDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftItem withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        super.withTheme(theme);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
