// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.authorization.fluent.EligibleChildResourcesClient;
import com.azure.resourcemanager.authorization.fluent.models.EligibleChildResourceInner;
import com.azure.resourcemanager.authorization.models.EligibleChildResourcesListResult;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in EligibleChildResourcesClient. */
public final class EligibleChildResourcesClientImpl implements EligibleChildResourcesClient {
    /** The proxy service used to perform REST calls. */
    private final EligibleChildResourcesService service;

    /** The service client containing this operation class. */
    private final AuthorizationManagementClientImpl client;

    /**
     * Initializes an instance of EligibleChildResourcesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    EligibleChildResourcesClientImpl(AuthorizationManagementClientImpl client) {
        this.service =
            RestProxy
                .create(EligibleChildResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AuthorizationManagementClientEligibleChildResources to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AuthorizationManagem")
    public interface EligibleChildResourcesService {
        @Headers({"Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Authorization/eligibleChildResources")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<EligibleChildResourcesListResult>> get(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("$filter") String filter,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<EligibleChildResourcesListResult>> getNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @param filter The filter to apply on the operation. Use $filter=resourceType+eq+'Subscription' to filter on only
     *     resource of type = 'Subscription'. Use
     *     $filter=resourceType+eq+'subscription'+or+resourceType+eq+'resourcegroup' to filter on resource of type =
     *     'Subscription' or 'ResourceGroup'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EligibleChildResourceInner>> getSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), scope, filter, apiVersion, accept, context))
            .<PagedResponse<EligibleChildResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @param filter The filter to apply on the operation. Use $filter=resourceType+eq+'Subscription' to filter on only
     *     resource of type = 'Subscription'. Use
     *     $filter=resourceType+eq+'subscription'+or+resourceType+eq+'resourcegroup' to filter on resource of type =
     *     'Subscription' or 'ResourceGroup'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EligibleChildResourceInner>> getSinglePageAsync(
        String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(this.client.getEndpoint(), scope, filter, apiVersion, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @param filter The filter to apply on the operation. Use $filter=resourceType+eq+'Subscription' to filter on only
     *     resource of type = 'Subscription'. Use
     *     $filter=resourceType+eq+'subscription'+or+resourceType+eq+'resourcegroup' to filter on resource of type =
     *     'Subscription' or 'ResourceGroup'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<EligibleChildResourceInner> getAsync(String scope, String filter) {
        return new PagedFlux<>(() -> getSinglePageAsync(scope, filter), nextLink -> getNextSinglePageAsync(nextLink));
    }

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<EligibleChildResourceInner> getAsync(String scope) {
        final String filter = null;
        return new PagedFlux<>(() -> getSinglePageAsync(scope, filter), nextLink -> getNextSinglePageAsync(nextLink));
    }

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @param filter The filter to apply on the operation. Use $filter=resourceType+eq+'Subscription' to filter on only
     *     resource of type = 'Subscription'. Use
     *     $filter=resourceType+eq+'subscription'+or+resourceType+eq+'resourcegroup' to filter on resource of type =
     *     'Subscription' or 'ResourceGroup'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<EligibleChildResourceInner> getAsync(String scope, String filter, Context context) {
        return new PagedFlux<>(
            () -> getSinglePageAsync(scope, filter, context), nextLink -> getNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<EligibleChildResourceInner> get(String scope) {
        final String filter = null;
        return new PagedIterable<>(getAsync(scope, filter));
    }

    /**
     * Get the child resources of a resource on which user has eligible access.
     *
     * @param scope The scope of the role management policy.
     * @param filter The filter to apply on the operation. Use $filter=resourceType+eq+'Subscription' to filter on only
     *     resource of type = 'Subscription'. Use
     *     $filter=resourceType+eq+'subscription'+or+resourceType+eq+'resourcegroup' to filter on resource of type =
     *     'Subscription' or 'ResourceGroup'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the child resources of a resource on which user has eligible access as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<EligibleChildResourceInner> get(String scope, String filter, Context context) {
        return new PagedIterable<>(getAsync(scope, filter, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return eligible child resources list operation result along with {@link PagedResponse} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EligibleChildResourceInner>> getNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<EligibleChildResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return eligible child resources list operation result along with {@link PagedResponse} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EligibleChildResourceInner>> getNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
