// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookChartDataLabels. */
@Fluent
public final class MicrosoftGraphWorkbookChartDataLabels extends MicrosoftGraphEntity {
    /*
     * DataLabelPosition value that represents the position of the data label. The possible values are: None, Center,
     * InsideEnd, InsideBase, OutsideEnd, Left, Right, Top, Bottom, BestFit, Callout.
     */
    @JsonProperty(value = "position")
    private String position;

    /*
     * String representing the separator used for the data labels on a chart.
     */
    @JsonProperty(value = "separator")
    private String separator;

    /*
     * Boolean value representing if the data label bubble size is visible or not.
     */
    @JsonProperty(value = "showBubbleSize")
    private Boolean showBubbleSize;

    /*
     * Boolean value representing if the data label category name is visible or not.
     */
    @JsonProperty(value = "showCategoryName")
    private Boolean showCategoryName;

    /*
     * Boolean value representing if the data label legend key is visible or not.
     */
    @JsonProperty(value = "showLegendKey")
    private Boolean showLegendKey;

    /*
     * Boolean value representing if the data label percentage is visible or not.
     */
    @JsonProperty(value = "showPercentage")
    private Boolean showPercentage;

    /*
     * Boolean value representing if the data label series name is visible or not.
     */
    @JsonProperty(value = "showSeriesName")
    private Boolean showSeriesName;

    /*
     * Boolean value representing if the data label value is visible or not.
     */
    @JsonProperty(value = "showValue")
    private Boolean showValue;

    /*
     * workbookChartDataLabelFormat
     */
    @JsonProperty(value = "format")
    private MicrosoftGraphWorkbookChartDataLabelFormat format;

    /*
     * workbookChartDataLabels
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphWorkbookChartDataLabels class. */
    public MicrosoftGraphWorkbookChartDataLabels() {
    }

    /**
     * Get the position property: DataLabelPosition value that represents the position of the data label. The possible
     * values are: None, Center, InsideEnd, InsideBase, OutsideEnd, Left, Right, Top, Bottom, BestFit, Callout.
     *
     * @return the position value.
     */
    public String position() {
        return this.position;
    }

    /**
     * Set the position property: DataLabelPosition value that represents the position of the data label. The possible
     * values are: None, Center, InsideEnd, InsideBase, OutsideEnd, Left, Right, Top, Bottom, BestFit, Callout.
     *
     * @param position the position value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withPosition(String position) {
        this.position = position;
        return this;
    }

    /**
     * Get the separator property: String representing the separator used for the data labels on a chart.
     *
     * @return the separator value.
     */
    public String separator() {
        return this.separator;
    }

    /**
     * Set the separator property: String representing the separator used for the data labels on a chart.
     *
     * @param separator the separator value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    /**
     * Get the showBubbleSize property: Boolean value representing if the data label bubble size is visible or not.
     *
     * @return the showBubbleSize value.
     */
    public Boolean showBubbleSize() {
        return this.showBubbleSize;
    }

    /**
     * Set the showBubbleSize property: Boolean value representing if the data label bubble size is visible or not.
     *
     * @param showBubbleSize the showBubbleSize value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withShowBubbleSize(Boolean showBubbleSize) {
        this.showBubbleSize = showBubbleSize;
        return this;
    }

    /**
     * Get the showCategoryName property: Boolean value representing if the data label category name is visible or not.
     *
     * @return the showCategoryName value.
     */
    public Boolean showCategoryName() {
        return this.showCategoryName;
    }

    /**
     * Set the showCategoryName property: Boolean value representing if the data label category name is visible or not.
     *
     * @param showCategoryName the showCategoryName value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withShowCategoryName(Boolean showCategoryName) {
        this.showCategoryName = showCategoryName;
        return this;
    }

    /**
     * Get the showLegendKey property: Boolean value representing if the data label legend key is visible or not.
     *
     * @return the showLegendKey value.
     */
    public Boolean showLegendKey() {
        return this.showLegendKey;
    }

    /**
     * Set the showLegendKey property: Boolean value representing if the data label legend key is visible or not.
     *
     * @param showLegendKey the showLegendKey value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withShowLegendKey(Boolean showLegendKey) {
        this.showLegendKey = showLegendKey;
        return this;
    }

    /**
     * Get the showPercentage property: Boolean value representing if the data label percentage is visible or not.
     *
     * @return the showPercentage value.
     */
    public Boolean showPercentage() {
        return this.showPercentage;
    }

    /**
     * Set the showPercentage property: Boolean value representing if the data label percentage is visible or not.
     *
     * @param showPercentage the showPercentage value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withShowPercentage(Boolean showPercentage) {
        this.showPercentage = showPercentage;
        return this;
    }

    /**
     * Get the showSeriesName property: Boolean value representing if the data label series name is visible or not.
     *
     * @return the showSeriesName value.
     */
    public Boolean showSeriesName() {
        return this.showSeriesName;
    }

    /**
     * Set the showSeriesName property: Boolean value representing if the data label series name is visible or not.
     *
     * @param showSeriesName the showSeriesName value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withShowSeriesName(Boolean showSeriesName) {
        this.showSeriesName = showSeriesName;
        return this;
    }

    /**
     * Get the showValue property: Boolean value representing if the data label value is visible or not.
     *
     * @return the showValue value.
     */
    public Boolean showValue() {
        return this.showValue;
    }

    /**
     * Set the showValue property: Boolean value representing if the data label value is visible or not.
     *
     * @param showValue the showValue value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withShowValue(Boolean showValue) {
        this.showValue = showValue;
        return this;
    }

    /**
     * Get the format property: workbookChartDataLabelFormat.
     *
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartDataLabelFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartDataLabelFormat.
     *
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withFormat(MicrosoftGraphWorkbookChartDataLabelFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartDataLabels.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartDataLabels.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartDataLabels object itself.
     */
    public MicrosoftGraphWorkbookChartDataLabels withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookChartDataLabels withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (format() != null) {
            format().validate();
        }
    }
}
