/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.GroupsGroupsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfGroup;
import com.azure.resourcemanager.authorization.fluent.models.Get2ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get3ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get6ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get7ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get8ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphGroupInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class GroupsGroupsClientImpl
implements GroupsGroupsClient {
    private final GroupsGroupsService service;
    private final MicrosoftGraphClientImpl client;

    GroupsGroupsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (GroupsGroupsService)RestProxy.create(GroupsGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphGroupInner>> listGroupSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listGroup(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfGroup)res.getValue()).value(), ((CollectionOfGroup)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphGroupInner>> listGroupSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.listGroup(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfGroup)res.getValue()).value(), ((CollectionOfGroup)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphGroupInner> listGroupAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand) {
        return new PagedFlux(() -> this.listGroupSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphGroupInner> listGroupAsync() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listGroupSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphGroupInner> listGroupAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand, Context context) {
        return new PagedFlux(() -> this.listGroupSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphGroupInner> listGroup() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<Get6ItemsItem> orderby = null;
        List<Get7ItemsItem> select = null;
        List<Get8ItemsItem> expand = null;
        return new PagedIterable(this.listGroupAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphGroupInner> listGroup(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand, Context context) {
        return new PagedIterable(this.listGroupAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphGroupInner>> createGroupWithResponseAsync(MicrosoftGraphGroupInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createGroup(this.client.getEndpoint(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphGroupInner>> createGroupWithResponseAsync(MicrosoftGraphGroupInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createGroup(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphGroupInner> createGroupAsync(MicrosoftGraphGroupInner body) {
        return this.createGroupWithResponseAsync(body).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphGroupInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphGroupInner> createGroupWithResponse(MicrosoftGraphGroupInner body, Context context) {
        return (Response)this.createGroupWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphGroupInner createGroup(MicrosoftGraphGroupInner body) {
        return (MicrosoftGraphGroupInner)this.createGroupWithResponse(body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphGroupInner>> getGroupWithResponseAsync(String groupId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getGroup(this.client.getEndpoint(), groupId, consistencyLevel, selectConverted, expandConverted, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphGroupInner>> getGroupWithResponseAsync(String groupId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.getGroup(this.client.getEndpoint(), groupId, consistencyLevel, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphGroupInner> getGroupAsync(String groupId) {
        String consistencyLevel = null;
        List<Get2ItemsItem> select = null;
        List<Get3ItemsItem> expand = null;
        return this.getGroupWithResponseAsync(groupId, consistencyLevel, select, expand).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphGroupInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphGroupInner> getGroupWithResponse(String groupId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand, Context context) {
        return (Response)this.getGroupWithResponseAsync(groupId, consistencyLevel, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphGroupInner getGroup(String groupId) {
        String consistencyLevel = null;
        List<Get2ItemsItem> select = null;
        List<Get3ItemsItem> expand = null;
        return (MicrosoftGraphGroupInner)this.getGroupWithResponse(groupId, consistencyLevel, select, expand, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateGroupWithResponseAsync(String groupId, MicrosoftGraphGroupInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateGroup(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateGroupWithResponseAsync(String groupId, MicrosoftGraphGroupInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateGroup(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateGroupAsync(String groupId, MicrosoftGraphGroupInner body) {
        return this.updateGroupWithResponseAsync(groupId, body).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateGroupWithResponse(String groupId, MicrosoftGraphGroupInner body, Context context) {
        return (Response)this.updateGroupWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateGroup(String groupId, MicrosoftGraphGroupInner body) {
        this.updateGroupWithResponse(groupId, body, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteGroupWithResponseAsync(String groupId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteGroup(this.client.getEndpoint(), groupId, ifMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteGroupWithResponseAsync(String groupId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteGroup(this.client.getEndpoint(), groupId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteGroupAsync(String groupId) {
        String ifMatch = null;
        return this.deleteGroupWithResponseAsync(groupId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteGroupWithResponse(String groupId, String ifMatch, Context context) {
        return (Response)this.deleteGroupWithResponseAsync(groupId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteGroup(String groupId) {
        String ifMatch = null;
        this.deleteGroupWithResponse(groupId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphGroupInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfGroup)res.getValue()).value(), ((CollectionOfGroup)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphGroupInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfGroup)res.getValue()).value(), ((CollectionOfGroup)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    public static interface GroupsGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfGroup>> listGroup(@HostParam(value="$host") String var1, @HeaderParam(value="ConsistencyLevel") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphGroupInner>> createGroup(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphGroupInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphGroupInner>> getGroup(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="ConsistencyLevel") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/groups/{group-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateGroup(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") MicrosoftGraphGroupInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteGroup(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfGroup>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

