// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The role management policy rule target. */
@Fluent
public final class RoleManagementPolicyRuleTarget {
    /*
     * The caller of the setting.
     */
    @JsonProperty(value = "caller")
    private String caller;

    /*
     * The type of operation.
     */
    @JsonProperty(value = "operations")
    private List<String> operations;

    /*
     * The assignment level to which rule is applied.
     */
    @JsonProperty(value = "level")
    private String level;

    /*
     * The list of target objects.
     */
    @JsonProperty(value = "targetObjects")
    private List<String> targetObjects;

    /*
     * The list of inheritable settings.
     */
    @JsonProperty(value = "inheritableSettings")
    private List<String> inheritableSettings;

    /*
     * The list of enforced settings.
     */
    @JsonProperty(value = "enforcedSettings")
    private List<String> enforcedSettings;

    /**
     * Get the caller property: The caller of the setting.
     *
     * @return the caller value.
     */
    public String caller() {
        return this.caller;
    }

    /**
     * Set the caller property: The caller of the setting.
     *
     * @param caller the caller value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withCaller(String caller) {
        this.caller = caller;
        return this;
    }

    /**
     * Get the operations property: The type of operation.
     *
     * @return the operations value.
     */
    public List<String> operations() {
        return this.operations;
    }

    /**
     * Set the operations property: The type of operation.
     *
     * @param operations the operations value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withOperations(List<String> operations) {
        this.operations = operations;
        return this;
    }

    /**
     * Get the level property: The assignment level to which rule is applied.
     *
     * @return the level value.
     */
    public String level() {
        return this.level;
    }

    /**
     * Set the level property: The assignment level to which rule is applied.
     *
     * @param level the level value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withLevel(String level) {
        this.level = level;
        return this;
    }

    /**
     * Get the targetObjects property: The list of target objects.
     *
     * @return the targetObjects value.
     */
    public List<String> targetObjects() {
        return this.targetObjects;
    }

    /**
     * Set the targetObjects property: The list of target objects.
     *
     * @param targetObjects the targetObjects value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withTargetObjects(List<String> targetObjects) {
        this.targetObjects = targetObjects;
        return this;
    }

    /**
     * Get the inheritableSettings property: The list of inheritable settings.
     *
     * @return the inheritableSettings value.
     */
    public List<String> inheritableSettings() {
        return this.inheritableSettings;
    }

    /**
     * Set the inheritableSettings property: The list of inheritable settings.
     *
     * @param inheritableSettings the inheritableSettings value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withInheritableSettings(List<String> inheritableSettings) {
        this.inheritableSettings = inheritableSettings;
        return this;
    }

    /**
     * Get the enforcedSettings property: The list of enforced settings.
     *
     * @return the enforcedSettings value.
     */
    public List<String> enforcedSettings() {
        return this.enforcedSettings;
    }

    /**
     * Set the enforcedSettings property: The list of enforced settings.
     *
     * @param enforcedSettings the enforcedSettings value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withEnforcedSettings(List<String> enforcedSettings) {
        this.enforcedSettings = enforcedSettings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
