// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Role assignment create parameters. */
@Fluent
public final class RoleAssignmentCreateParameters {
    /*
     * Role assignment properties.
     */
    @JsonProperty(value = "properties", required = true)
    private RoleAssignmentProperties properties;

    /**
     * Get the properties property: Role assignment properties.
     *
     * @return the properties value.
     */
    public RoleAssignmentProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Role assignment properties.
     *
     * @param properties the properties value to set.
     * @return the RoleAssignmentCreateParameters object itself.
     */
    public RoleAssignmentCreateParameters withProperties(RoleAssignmentProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property properties in model RoleAssignmentCreateParameters"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RoleAssignmentCreateParameters.class);
}
