// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for AssignmentType. */
public final class AssignmentType extends ExpandableStringEnum<AssignmentType> {
    /** Static value Activated for AssignmentType. */
    public static final AssignmentType ACTIVATED = fromString("Activated");

    /** Static value Assigned for AssignmentType. */
    public static final AssignmentType ASSIGNED = fromString("Assigned");

    /**
     * Creates or finds a AssignmentType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AssignmentType.
     */
    @JsonCreator
    public static AssignmentType fromString(String name) {
        return fromString(name, AssignmentType.class);
    }

    /** @return known AssignmentType values. */
    public static Collection<AssignmentType> values() {
        return values(AssignmentType.class);
    }
}
