// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** workbookChartSeries. */
@Fluent
public final class MicrosoftGraphWorkbookChartSeries extends MicrosoftGraphEntity {
    /*
     * Represents the name of a series in a chart.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * workbookChartSeriesFormat
     */
    @JsonProperty(value = "format")
    private MicrosoftGraphWorkbookChartSeriesFormat format;

    /*
     * Represents a collection of all points in the series. Read-only.
     */
    @JsonProperty(value = "points")
    private List<MicrosoftGraphWorkbookChartPoint> points;

    /*
     * workbookChartSeries
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the name property: Represents the name of a series in a chart.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Represents the name of a series in a chart.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookChartSeries object itself.
     */
    public MicrosoftGraphWorkbookChartSeries withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the format property: workbookChartSeriesFormat.
     *
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartSeriesFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartSeriesFormat.
     *
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChartSeries object itself.
     */
    public MicrosoftGraphWorkbookChartSeries withFormat(MicrosoftGraphWorkbookChartSeriesFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the points property: Represents a collection of all points in the series. Read-only.
     *
     * @return the points value.
     */
    public List<MicrosoftGraphWorkbookChartPoint> points() {
        return this.points;
    }

    /**
     * Set the points property: Represents a collection of all points in the series. Read-only.
     *
     * @param points the points value to set.
     * @return the MicrosoftGraphWorkbookChartSeries object itself.
     */
    public MicrosoftGraphWorkbookChartSeries withPoints(List<MicrosoftGraphWorkbookChartPoint> points) {
        this.points = points;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartSeries.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartSeries.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartSeries object itself.
     */
    public MicrosoftGraphWorkbookChartSeries withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookChartSeries withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (format() != null) {
            format().validate();
        }
        if (points() != null) {
            points().forEach(e -> e.validate());
        }
    }
}
