// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** timeOffItem. */
@Fluent
public final class MicrosoftGraphTimeOffItem extends MicrosoftGraphScheduleEntity {
    /*
     * ID of the timeOffReason for this timeOffItem. Required.
     */
    @JsonProperty(value = "timeOffReasonId")
    private String timeOffReasonId;

    /*
     * timeOffItem
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the timeOffReasonId property: ID of the timeOffReason for this timeOffItem. Required.
     *
     * @return the timeOffReasonId value.
     */
    public String timeOffReasonId() {
        return this.timeOffReasonId;
    }

    /**
     * Set the timeOffReasonId property: ID of the timeOffReason for this timeOffItem. Required.
     *
     * @param timeOffReasonId the timeOffReasonId value to set.
     * @return the MicrosoftGraphTimeOffItem object itself.
     */
    public MicrosoftGraphTimeOffItem withTimeOffReasonId(String timeOffReasonId) {
        this.timeOffReasonId = timeOffReasonId;
        return this;
    }

    /**
     * Get the additionalProperties property: timeOffItem.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: timeOffItem.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTimeOffItem object itself.
     */
    public MicrosoftGraphTimeOffItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffItem withEndDateTime(OffsetDateTime endDateTime) {
        super.withEndDateTime(endDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffItem withStartDateTime(OffsetDateTime startDateTime) {
        super.withStartDateTime(startDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffItem withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        super.withTheme(theme);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
