// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * stsPolicy Represents an Azure Active Directory object. The directoryObject type is the base type for many other
 * directory entity types.
 */
@Fluent
public class MicrosoftGraphStsPolicy extends MicrosoftGraphPolicyBase {
    /*
     * A string collection containing a JSON string that defines the rules and
     * settings for a policy. The syntax for the definition differs for each
     * derived policy type. Required.
     */
    @JsonProperty(value = "definition")
    private List<String> definition;

    /*
     * If set to true, activates this policy. There can be many policies for
     * the same policy type, but only one can be activated as the organization
     * default. Optional, default value is false.
     */
    @JsonProperty(value = "isOrganizationDefault")
    private Boolean isOrganizationDefault;

    /*
     * The appliesTo property.
     */
    @JsonProperty(value = "appliesTo")
    private List<MicrosoftGraphDirectoryObjectInner> appliesTo;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the definition property: A string collection containing a JSON string that defines the rules and settings for
     * a policy. The syntax for the definition differs for each derived policy type. Required.
     *
     * @return the definition value.
     */
    public List<String> definition() {
        return this.definition;
    }

    /**
     * Set the definition property: A string collection containing a JSON string that defines the rules and settings for
     * a policy. The syntax for the definition differs for each derived policy type. Required.
     *
     * @param definition the definition value to set.
     * @return the MicrosoftGraphStsPolicy object itself.
     */
    public MicrosoftGraphStsPolicy withDefinition(List<String> definition) {
        this.definition = definition;
        return this;
    }

    /**
     * Get the isOrganizationDefault property: If set to true, activates this policy. There can be many policies for the
     * same policy type, but only one can be activated as the organization default. Optional, default value is false.
     *
     * @return the isOrganizationDefault value.
     */
    public Boolean isOrganizationDefault() {
        return this.isOrganizationDefault;
    }

    /**
     * Set the isOrganizationDefault property: If set to true, activates this policy. There can be many policies for the
     * same policy type, but only one can be activated as the organization default. Optional, default value is false.
     *
     * @param isOrganizationDefault the isOrganizationDefault value to set.
     * @return the MicrosoftGraphStsPolicy object itself.
     */
    public MicrosoftGraphStsPolicy withIsOrganizationDefault(Boolean isOrganizationDefault) {
        this.isOrganizationDefault = isOrganizationDefault;
        return this;
    }

    /**
     * Get the appliesTo property: The appliesTo property.
     *
     * @return the appliesTo value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> appliesTo() {
        return this.appliesTo;
    }

    /**
     * Set the appliesTo property: The appliesTo property.
     *
     * @param appliesTo the appliesTo value to set.
     * @return the MicrosoftGraphStsPolicy object itself.
     */
    public MicrosoftGraphStsPolicy withAppliesTo(List<MicrosoftGraphDirectoryObjectInner> appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphStsPolicy object itself.
     */
    public MicrosoftGraphStsPolicy withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphStsPolicy withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphStsPolicy withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphStsPolicy withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphStsPolicy withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (appliesTo() != null) {
            appliesTo().forEach(e -> e.validate());
        }
    }
}
