// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** shiftPreferences. */
@Fluent
public final class MicrosoftGraphShiftPreferences extends MicrosoftGraphChangeTrackedEntity {
    /*
     * Availability of the user to be scheduled for work and its recurrence
     * pattern.
     */
    @JsonProperty(value = "availability")
    private List<MicrosoftGraphShiftAvailability> availability;

    /*
     * shiftPreferences
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the availability property: Availability of the user to be scheduled for work and its recurrence pattern.
     *
     * @return the availability value.
     */
    public List<MicrosoftGraphShiftAvailability> availability() {
        return this.availability;
    }

    /**
     * Set the availability property: Availability of the user to be scheduled for work and its recurrence pattern.
     *
     * @param availability the availability value to set.
     * @return the MicrosoftGraphShiftPreferences object itself.
     */
    public MicrosoftGraphShiftPreferences withAvailability(List<MicrosoftGraphShiftAvailability> availability) {
        this.availability = availability;
        return this;
    }

    /**
     * Get the additionalProperties property: shiftPreferences.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: shiftPreferences.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphShiftPreferences object itself.
     */
    public MicrosoftGraphShiftPreferences withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShiftPreferences withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShiftPreferences withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShiftPreferences withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShiftPreferences withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (availability() != null) {
            availability().forEach(e -> e.validate());
        }
    }
}
