// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** shiftItem. */
@Fluent
public class MicrosoftGraphShiftItem extends MicrosoftGraphScheduleEntity {
    /*
     * An incremental part of a shift which can cover details of when and where
     * an employee is during their shift. For example, an assignment or a
     * scheduled break or lunch. Required.
     */
    @JsonProperty(value = "activities")
    private List<MicrosoftGraphShiftActivity> activities;

    /*
     * The shift label of the shiftItem.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The shift notes for the shiftItem.
     */
    @JsonProperty(value = "notes")
    private String notes;

    /*
     * shiftItem
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the activities property: An incremental part of a shift which can cover details of when and where an employee
     * is during their shift. For example, an assignment or a scheduled break or lunch. Required.
     *
     * @return the activities value.
     */
    public List<MicrosoftGraphShiftActivity> activities() {
        return this.activities;
    }

    /**
     * Set the activities property: An incremental part of a shift which can cover details of when and where an employee
     * is during their shift. For example, an assignment or a scheduled break or lunch. Required.
     *
     * @param activities the activities value to set.
     * @return the MicrosoftGraphShiftItem object itself.
     */
    public MicrosoftGraphShiftItem withActivities(List<MicrosoftGraphShiftActivity> activities) {
        this.activities = activities;
        return this;
    }

    /**
     * Get the displayName property: The shift label of the shiftItem.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The shift label of the shiftItem.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphShiftItem object itself.
     */
    public MicrosoftGraphShiftItem withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the notes property: The shift notes for the shiftItem.
     *
     * @return the notes value.
     */
    public String notes() {
        return this.notes;
    }

    /**
     * Set the notes property: The shift notes for the shiftItem.
     *
     * @param notes the notes value to set.
     * @return the MicrosoftGraphShiftItem object itself.
     */
    public MicrosoftGraphShiftItem withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    /**
     * Get the additionalProperties property: shiftItem.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: shiftItem.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphShiftItem object itself.
     */
    public MicrosoftGraphShiftItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShiftItem withEndDateTime(OffsetDateTime endDateTime) {
        super.withEndDateTime(endDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShiftItem withStartDateTime(OffsetDateTime startDateTime) {
        super.withStartDateTime(startDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphShiftItem withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        super.withTheme(theme);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (activities() != null) {
            activities().forEach(e -> e.validate());
        }
    }
}
