// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** scheduleEntity. */
@Fluent
public class MicrosoftGraphScheduleEntity {
    /*
     * The endDateTime property.
     */
    @JsonProperty(value = "endDateTime")
    private OffsetDateTime endDateTime;

    /*
     * The startDateTime property.
     */
    @JsonProperty(value = "startDateTime")
    private OffsetDateTime startDateTime;

    /*
     * scheduleEntityTheme
     */
    @JsonProperty(value = "theme")
    private MicrosoftGraphScheduleEntityTheme theme;

    /*
     * scheduleEntity
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the endDateTime property: The endDateTime property.
     *
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: The endDateTime property.
     *
     * @param endDateTime the endDateTime value to set.
     * @return the MicrosoftGraphScheduleEntity object itself.
     */
    public MicrosoftGraphScheduleEntity withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the startDateTime property: The startDateTime property.
     *
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: The startDateTime property.
     *
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphScheduleEntity object itself.
     */
    public MicrosoftGraphScheduleEntity withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the theme property: scheduleEntityTheme.
     *
     * @return the theme value.
     */
    public MicrosoftGraphScheduleEntityTheme theme() {
        return this.theme;
    }

    /**
     * Set the theme property: scheduleEntityTheme.
     *
     * @param theme the theme value to set.
     * @return the MicrosoftGraphScheduleEntity object itself.
     */
    public MicrosoftGraphScheduleEntity withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        this.theme = theme;
        return this;
    }

    /**
     * Get the additionalProperties property: scheduleEntity.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: scheduleEntity.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphScheduleEntity object itself.
     */
    public MicrosoftGraphScheduleEntity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
