// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** openShift. */
@Fluent
public final class MicrosoftGraphOpenShift extends MicrosoftGraphChangeTrackedEntity {
    /*
     * openShiftItem
     */
    @JsonProperty(value = "draftOpenShift")
    private MicrosoftGraphOpenShiftItem draftOpenShift;

    /*
     * ID for the scheduling group that the open shift belongs to.
     */
    @JsonProperty(value = "schedulingGroupId")
    private String schedulingGroupId;

    /*
     * openShiftItem
     */
    @JsonProperty(value = "sharedOpenShift")
    private MicrosoftGraphOpenShiftItem sharedOpenShift;

    /*
     * openShift
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the draftOpenShift property: openShiftItem.
     *
     * @return the draftOpenShift value.
     */
    public MicrosoftGraphOpenShiftItem draftOpenShift() {
        return this.draftOpenShift;
    }

    /**
     * Set the draftOpenShift property: openShiftItem.
     *
     * @param draftOpenShift the draftOpenShift value to set.
     * @return the MicrosoftGraphOpenShift object itself.
     */
    public MicrosoftGraphOpenShift withDraftOpenShift(MicrosoftGraphOpenShiftItem draftOpenShift) {
        this.draftOpenShift = draftOpenShift;
        return this;
    }

    /**
     * Get the schedulingGroupId property: ID for the scheduling group that the open shift belongs to.
     *
     * @return the schedulingGroupId value.
     */
    public String schedulingGroupId() {
        return this.schedulingGroupId;
    }

    /**
     * Set the schedulingGroupId property: ID for the scheduling group that the open shift belongs to.
     *
     * @param schedulingGroupId the schedulingGroupId value to set.
     * @return the MicrosoftGraphOpenShift object itself.
     */
    public MicrosoftGraphOpenShift withSchedulingGroupId(String schedulingGroupId) {
        this.schedulingGroupId = schedulingGroupId;
        return this;
    }

    /**
     * Get the sharedOpenShift property: openShiftItem.
     *
     * @return the sharedOpenShift value.
     */
    public MicrosoftGraphOpenShiftItem sharedOpenShift() {
        return this.sharedOpenShift;
    }

    /**
     * Set the sharedOpenShift property: openShiftItem.
     *
     * @param sharedOpenShift the sharedOpenShift value to set.
     * @return the MicrosoftGraphOpenShift object itself.
     */
    public MicrosoftGraphOpenShift withSharedOpenShift(MicrosoftGraphOpenShiftItem sharedOpenShift) {
        this.sharedOpenShift = sharedOpenShift;
        return this;
    }

    /**
     * Get the additionalProperties property: openShift.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: openShift.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOpenShift object itself.
     */
    public MicrosoftGraphOpenShift withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShift withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShift withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShift withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShift withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (draftOpenShift() != null) {
            draftOpenShift().validate();
        }
        if (sharedOpenShift() != null) {
            sharedOpenShift().validate();
        }
    }
}
