// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** onlineMeeting. */
@Fluent
public final class MicrosoftGraphOnlineMeeting extends MicrosoftGraphEntity {
    /*
     * onlineMeetingPresenters
     */
    @JsonProperty(value = "allowedPresenters")
    private MicrosoftGraphOnlineMeetingPresenters allowedPresenters;

    /*
     * audioConferencing
     */
    @JsonProperty(value = "audioConferencing")
    private MicrosoftGraphAudioConferencing audioConferencing;

    /*
     * chatInfo
     */
    @JsonProperty(value = "chatInfo")
    private MicrosoftGraphChatInfo chatInfo;

    /*
     * The meeting creation time in UTC. Read-only.
     */
    @JsonProperty(value = "creationDateTime")
    private OffsetDateTime creationDateTime;

    /*
     * The meeting end time in UTC.
     */
    @JsonProperty(value = "endDateTime")
    private OffsetDateTime endDateTime;

    /*
     * The externalId property.
     */
    @JsonProperty(value = "externalId")
    private String externalId;

    /*
     * Whether or not to announce when callers join or leave.
     */
    @JsonProperty(value = "isEntryExitAnnounced")
    private Boolean isEntryExitAnnounced;

    /*
     * itemBody
     */
    @JsonProperty(value = "joinInformation")
    private MicrosoftGraphItemBody joinInformation;

    /*
     * The join URL of the online meeting. Read-only.
     */
    @JsonProperty(value = "joinWebUrl")
    private String joinWebUrl;

    /*
     * lobbyBypassSettings
     */
    @JsonProperty(value = "lobbyBypassSettings")
    private MicrosoftGraphLobbyBypassSettings lobbyBypassSettings;

    /*
     * meetingParticipants
     */
    @JsonProperty(value = "participants")
    private MicrosoftGraphMeetingParticipants participants;

    /*
     * The meeting start time in UTC.
     */
    @JsonProperty(value = "startDateTime")
    private OffsetDateTime startDateTime;

    /*
     * The subject of the online meeting.
     */
    @JsonProperty(value = "subject")
    private String subject;

    /*
     * The video teleconferencing ID. Read-only.
     */
    @JsonProperty(value = "videoTeleconferenceId")
    private String videoTeleconferenceId;

    /*
     * onlineMeeting
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the allowedPresenters property: onlineMeetingPresenters.
     *
     * @return the allowedPresenters value.
     */
    public MicrosoftGraphOnlineMeetingPresenters allowedPresenters() {
        return this.allowedPresenters;
    }

    /**
     * Set the allowedPresenters property: onlineMeetingPresenters.
     *
     * @param allowedPresenters the allowedPresenters value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withAllowedPresenters(MicrosoftGraphOnlineMeetingPresenters allowedPresenters) {
        this.allowedPresenters = allowedPresenters;
        return this;
    }

    /**
     * Get the audioConferencing property: audioConferencing.
     *
     * @return the audioConferencing value.
     */
    public MicrosoftGraphAudioConferencing audioConferencing() {
        return this.audioConferencing;
    }

    /**
     * Set the audioConferencing property: audioConferencing.
     *
     * @param audioConferencing the audioConferencing value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withAudioConferencing(MicrosoftGraphAudioConferencing audioConferencing) {
        this.audioConferencing = audioConferencing;
        return this;
    }

    /**
     * Get the chatInfo property: chatInfo.
     *
     * @return the chatInfo value.
     */
    public MicrosoftGraphChatInfo chatInfo() {
        return this.chatInfo;
    }

    /**
     * Set the chatInfo property: chatInfo.
     *
     * @param chatInfo the chatInfo value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withChatInfo(MicrosoftGraphChatInfo chatInfo) {
        this.chatInfo = chatInfo;
        return this;
    }

    /**
     * Get the creationDateTime property: The meeting creation time in UTC. Read-only.
     *
     * @return the creationDateTime value.
     */
    public OffsetDateTime creationDateTime() {
        return this.creationDateTime;
    }

    /**
     * Set the creationDateTime property: The meeting creation time in UTC. Read-only.
     *
     * @param creationDateTime the creationDateTime value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withCreationDateTime(OffsetDateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    /**
     * Get the endDateTime property: The meeting end time in UTC.
     *
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: The meeting end time in UTC.
     *
     * @param endDateTime the endDateTime value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the externalId property: The externalId property.
     *
     * @return the externalId value.
     */
    public String externalId() {
        return this.externalId;
    }

    /**
     * Set the externalId property: The externalId property.
     *
     * @param externalId the externalId value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    /**
     * Get the isEntryExitAnnounced property: Whether or not to announce when callers join or leave.
     *
     * @return the isEntryExitAnnounced value.
     */
    public Boolean isEntryExitAnnounced() {
        return this.isEntryExitAnnounced;
    }

    /**
     * Set the isEntryExitAnnounced property: Whether or not to announce when callers join or leave.
     *
     * @param isEntryExitAnnounced the isEntryExitAnnounced value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withIsEntryExitAnnounced(Boolean isEntryExitAnnounced) {
        this.isEntryExitAnnounced = isEntryExitAnnounced;
        return this;
    }

    /**
     * Get the joinInformation property: itemBody.
     *
     * @return the joinInformation value.
     */
    public MicrosoftGraphItemBody joinInformation() {
        return this.joinInformation;
    }

    /**
     * Set the joinInformation property: itemBody.
     *
     * @param joinInformation the joinInformation value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withJoinInformation(MicrosoftGraphItemBody joinInformation) {
        this.joinInformation = joinInformation;
        return this;
    }

    /**
     * Get the joinWebUrl property: The join URL of the online meeting. Read-only.
     *
     * @return the joinWebUrl value.
     */
    public String joinWebUrl() {
        return this.joinWebUrl;
    }

    /**
     * Set the joinWebUrl property: The join URL of the online meeting. Read-only.
     *
     * @param joinWebUrl the joinWebUrl value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withJoinWebUrl(String joinWebUrl) {
        this.joinWebUrl = joinWebUrl;
        return this;
    }

    /**
     * Get the lobbyBypassSettings property: lobbyBypassSettings.
     *
     * @return the lobbyBypassSettings value.
     */
    public MicrosoftGraphLobbyBypassSettings lobbyBypassSettings() {
        return this.lobbyBypassSettings;
    }

    /**
     * Set the lobbyBypassSettings property: lobbyBypassSettings.
     *
     * @param lobbyBypassSettings the lobbyBypassSettings value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withLobbyBypassSettings(MicrosoftGraphLobbyBypassSettings lobbyBypassSettings) {
        this.lobbyBypassSettings = lobbyBypassSettings;
        return this;
    }

    /**
     * Get the participants property: meetingParticipants.
     *
     * @return the participants value.
     */
    public MicrosoftGraphMeetingParticipants participants() {
        return this.participants;
    }

    /**
     * Set the participants property: meetingParticipants.
     *
     * @param participants the participants value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withParticipants(MicrosoftGraphMeetingParticipants participants) {
        this.participants = participants;
        return this;
    }

    /**
     * Get the startDateTime property: The meeting start time in UTC.
     *
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: The meeting start time in UTC.
     *
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the subject property: The subject of the online meeting.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: The subject of the online meeting.
     *
     * @param subject the subject value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the videoTeleconferenceId property: The video teleconferencing ID. Read-only.
     *
     * @return the videoTeleconferenceId value.
     */
    public String videoTeleconferenceId() {
        return this.videoTeleconferenceId;
    }

    /**
     * Set the videoTeleconferenceId property: The video teleconferencing ID. Read-only.
     *
     * @param videoTeleconferenceId the videoTeleconferenceId value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withVideoTeleconferenceId(String videoTeleconferenceId) {
        this.videoTeleconferenceId = videoTeleconferenceId;
        return this;
    }

    /**
     * Get the additionalProperties property: onlineMeeting.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onlineMeeting.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnlineMeeting object itself.
     */
    public MicrosoftGraphOnlineMeeting withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOnlineMeeting withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (audioConferencing() != null) {
            audioConferencing().validate();
        }
        if (chatInfo() != null) {
            chatInfo().validate();
        }
        if (joinInformation() != null) {
            joinInformation().validate();
        }
        if (lobbyBypassSettings() != null) {
            lobbyBypassSettings().validate();
        }
        if (participants() != null) {
            participants().validate();
        }
    }
}
