// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** onenotePagePreviewLinks. */
@Fluent
public final class MicrosoftGraphOnenotePagePreviewLinks {
    /*
     * externalLink
     */
    @JsonProperty(value = "previewImageUrl")
    private MicrosoftGraphExternalLink previewImageUrl;

    /*
     * onenotePagePreviewLinks
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the previewImageUrl property: externalLink.
     *
     * @return the previewImageUrl value.
     */
    public MicrosoftGraphExternalLink previewImageUrl() {
        return this.previewImageUrl;
    }

    /**
     * Set the previewImageUrl property: externalLink.
     *
     * @param previewImageUrl the previewImageUrl value to set.
     * @return the MicrosoftGraphOnenotePagePreviewLinks object itself.
     */
    public MicrosoftGraphOnenotePagePreviewLinks withPreviewImageUrl(MicrosoftGraphExternalLink previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: onenotePagePreviewLinks.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenotePagePreviewLinks.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenotePagePreviewLinks object itself.
     */
    public MicrosoftGraphOnenotePagePreviewLinks withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (previewImageUrl() != null) {
            previewImageUrl().validate();
        }
    }
}
