// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** onenoteOperation. */
@Fluent
public final class MicrosoftGraphOnenoteOperation extends MicrosoftGraphOperation {
    /*
     * onenoteOperationError
     */
    @JsonProperty(value = "error")
    private MicrosoftGraphOnenoteOperationError error;

    /*
     * The operation percent complete if the operation is still in running
     * status
     */
    @JsonProperty(value = "percentComplete")
    private String percentComplete;

    /*
     * The resource id.
     */
    @JsonProperty(value = "resourceId")
    private String resourceId;

    /*
     * The resource URI for the object. For example, the resource URI for a
     * copied page or section.
     */
    @JsonProperty(value = "resourceLocation")
    private String resourceLocation;

    /*
     * onenoteOperation
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the error property: onenoteOperationError.
     *
     * @return the error value.
     */
    public MicrosoftGraphOnenoteOperationError error() {
        return this.error;
    }

    /**
     * Set the error property: onenoteOperationError.
     *
     * @param error the error value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withError(MicrosoftGraphOnenoteOperationError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the percentComplete property: The operation percent complete if the operation is still in running status.
     *
     * @return the percentComplete value.
     */
    public String percentComplete() {
        return this.percentComplete;
    }

    /**
     * Set the percentComplete property: The operation percent complete if the operation is still in running status.
     *
     * @param percentComplete the percentComplete value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withPercentComplete(String percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    /**
     * Get the resourceId property: The resource id.
     *
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The resource id.
     *
     * @param resourceId the resourceId value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the resourceLocation property: The resource URI for the object. For example, the resource URI for a copied
     * page or section.
     *
     * @return the resourceLocation value.
     */
    public String resourceLocation() {
        return this.resourceLocation;
    }

    /**
     * Set the resourceLocation property: The resource URI for the object. For example, the resource URI for a copied
     * page or section.
     *
     * @param resourceLocation the resourceLocation value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    /**
     * Get the additionalProperties property: onenoteOperation.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenoteOperation.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOnenoteOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOnenoteOperation withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        super.withLastActionDateTime(lastActionDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOnenoteOperation withStatus(MicrosoftGraphOperationStatus status) {
        super.withStatus(status);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOnenoteOperation withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (error() != null) {
            error().validate();
        }
    }
}
