// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** implicitGrantSettings. */
@Fluent
public final class MicrosoftGraphImplicitGrantSettings {
    /*
     * Specifies whether this web application can request an access token using
     * the OAuth 2.0 implicit flow.
     */
    @JsonProperty(value = "enableAccessTokenIssuance")
    private Boolean enableAccessTokenIssuance;

    /*
     * Specifies whether this web application can request an ID token using the
     * OAuth 2.0 implicit flow.
     */
    @JsonProperty(value = "enableIdTokenIssuance")
    private Boolean enableIdTokenIssuance;

    /*
     * implicitGrantSettings
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the enableAccessTokenIssuance property: Specifies whether this web application can request an access token
     * using the OAuth 2.0 implicit flow.
     *
     * @return the enableAccessTokenIssuance value.
     */
    public Boolean enableAccessTokenIssuance() {
        return this.enableAccessTokenIssuance;
    }

    /**
     * Set the enableAccessTokenIssuance property: Specifies whether this web application can request an access token
     * using the OAuth 2.0 implicit flow.
     *
     * @param enableAccessTokenIssuance the enableAccessTokenIssuance value to set.
     * @return the MicrosoftGraphImplicitGrantSettings object itself.
     */
    public MicrosoftGraphImplicitGrantSettings withEnableAccessTokenIssuance(Boolean enableAccessTokenIssuance) {
        this.enableAccessTokenIssuance = enableAccessTokenIssuance;
        return this;
    }

    /**
     * Get the enableIdTokenIssuance property: Specifies whether this web application can request an ID token using the
     * OAuth 2.0 implicit flow.
     *
     * @return the enableIdTokenIssuance value.
     */
    public Boolean enableIdTokenIssuance() {
        return this.enableIdTokenIssuance;
    }

    /**
     * Set the enableIdTokenIssuance property: Specifies whether this web application can request an ID token using the
     * OAuth 2.0 implicit flow.
     *
     * @param enableIdTokenIssuance the enableIdTokenIssuance value to set.
     * @return the MicrosoftGraphImplicitGrantSettings object itself.
     */
    public MicrosoftGraphImplicitGrantSettings withEnableIdTokenIssuance(Boolean enableIdTokenIssuance) {
        this.enableIdTokenIssuance = enableIdTokenIssuance;
        return this;
    }

    /**
     * Get the additionalProperties property: implicitGrantSettings.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: implicitGrantSettings.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphImplicitGrantSettings object itself.
     */
    public MicrosoftGraphImplicitGrantSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
