// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * group Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
 * entity types.
 */
@Fluent
public final class MicrosoftGraphGroupInner extends MicrosoftGraphDirectoryObjectInner {
    /*
     * The list of sensitivity label pairs (label ID, label name) associated
     * with an Microsoft 365 group. Returned only on $select. Read-only.
     */
    @JsonProperty(value = "assignedLabels")
    private List<MicrosoftGraphAssignedLabel> assignedLabels;

    /*
     * The licenses that are assigned to the group. Returned only on $select.
     * Read-only.
     */
    @JsonProperty(value = "assignedLicenses")
    private List<MicrosoftGraphAssignedLicense> assignedLicenses;

    /*
     * Describes a classification for the group (such as low, medium or high
     * business impact). Valid values for this property are defined by creating
     * a ClassificationList setting value, based on the template
     * definition.Returned by default.
     */
    @JsonProperty(value = "classification")
    private String classification;

    /*
     * Timestamp of when the group was created. The value cannot be modified
     * and is automatically populated when the group is created. The Timestamp
     * type represents date and time information using ISO 8601 format and is
     * always in UTC time. For example, midnight UTC on Jan 1, 2014 would look
     * like this: '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     */
    @JsonProperty(value = "createdDateTime")
    private OffsetDateTime createdDateTime;

    /*
     * An optional description for the group. Returned by default.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The display name for the group. This property is required when a group
     * is created and cannot be cleared during updates. Returned by default.
     * Supports $filter and $orderby.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Timestamp of when the group is set to expire. The value cannot be
     * modified and is automatically populated when the group is created. The
     * Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'. Returned by default.
     * Read-only.
     */
    @JsonProperty(value = "expirationDateTime")
    private OffsetDateTime expirationDateTime;

    /*
     * Specifies the group type and its membership.  If the collection contains
     * Unified, the group is a Microsoft 365 group; otherwise, it's either a
     * security group or distribution group. For details, see groups
     * overview.If the collection includes DynamicMembership, the group has
     * dynamic membership; otherwise, membership is static.  Returned by
     * default. Supports $filter.
     */
    @JsonProperty(value = "groupTypes")
    private List<String> groupTypes;

    /*
     * Indicates whether there are members in this group that have license
     * errors from its group-based license assignment. This property is never
     * returned on a GET operation. You can use it as a $filter argument to get
     * groups that have members with license errors (that is, filter for this
     * property being true). See an example.
     */
    @JsonProperty(value = "hasMembersWithLicenseErrors")
    private Boolean hasMembersWithLicenseErrors;

    /*
     * licenseProcessingState
     */
    @JsonProperty(value = "licenseProcessingState")
    private MicrosoftGraphLicenseProcessingState licenseProcessingState;

    /*
     * The SMTP address for the group, for example,
     * 'serviceadmins@contoso.onmicrosoft.com'. Returned by default. Read-only.
     * Supports $filter.
     */
    @JsonProperty(value = "mail")
    private String mail;

    /*
     * Specifies whether the group is mail-enabled. Returned by default.
     */
    @JsonProperty(value = "mailEnabled")
    private Boolean mailEnabled;

    /*
     * The mailNickname property.
     */
    @JsonProperty(value = "mailNickname")
    private String mailNickname;

    /*
     * The rule that determines members for this group if the group is a
     * dynamic group (groupTypes contains DynamicMembership). For more
     * information about the syntax of the membership rule, see Membership
     * Rules syntax. Returned by default.
     */
    @JsonProperty(value = "membershipRule")
    private String membershipRule;

    /*
     * Indicates whether the dynamic membership processing is on or paused.
     * Possible values are 'On' or 'Paused'. Returned by default.
     */
    @JsonProperty(value = "membershipRuleProcessingState")
    private String membershipRuleProcessingState;

    /*
     * The onPremisesDomainName property.
     */
    @JsonProperty(value = "onPremisesDomainName")
    private String onPremisesDomainName;

    /*
     * The onPremisesLastSyncDateTime property.
     */
    @JsonProperty(value = "onPremisesLastSyncDateTime")
    private OffsetDateTime onPremisesLastSyncDateTime;

    /*
     * The onPremisesNetBiosName property.
     */
    @JsonProperty(value = "onPremisesNetBiosName")
    private String onPremisesNetBiosName;

    /*
     * The onPremisesProvisioningErrors property.
     */
    @JsonProperty(value = "onPremisesProvisioningErrors")
    private List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors;

    /*
     * Contains the on-premises SAM account name synchronized from the
     * on-premises directory. The property is only populated for customers who
     * are synchronizing their on-premises directory to Azure Active Directory
     * via Azure AD Connect.Returned by default. Read-only.
     */
    @JsonProperty(value = "onPremisesSamAccountName")
    private String onPremisesSamAccountName;

    /*
     * Contains the on-premises security identifier (SID) for the group that
     * was synchronized from on-premises to the cloud. Returned by default.
     * Read-only.
     */
    @JsonProperty(value = "onPremisesSecurityIdentifier")
    private String onPremisesSecurityIdentifier;

    /*
     * true if this group is synced from an on-premises directory; false if
     * this group was originally synced from an on-premises directory but is no
     * longer synced; null if this object has never been synced from an
     * on-premises directory (default). Returned by default. Read-only.
     * Supports $filter.
     */
    @JsonProperty(value = "onPremisesSyncEnabled")
    private Boolean onPremisesSyncEnabled;

    /*
     * The preferred data location for the group. For more information, see
     * OneDrive Online Multi-Geo. Returned by default.
     */
    @JsonProperty(value = "preferredDataLocation")
    private String preferredDataLocation;

    /*
     * The preferred language for an Microsoft 365 group. Should follow ISO
     * 639-1 Code; for example 'en-US'. Returned by default.
     */
    @JsonProperty(value = "preferredLanguage")
    private String preferredLanguage;

    /*
     * The proxyAddresses property.
     */
    @JsonProperty(value = "proxyAddresses")
    private List<String> proxyAddresses;

    /*
     * Timestamp of when the group was last renewed. This cannot be modified
     * directly and is only updated via the renew service action. The Timestamp
     * type represents date and time information using ISO 8601 format and is
     * always in UTC time. For example, midnight UTC on Jan 1, 2014 would look
     * like this: '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     */
    @JsonProperty(value = "renewedDateTime")
    private OffsetDateTime renewedDateTime;

    /*
     * Specifies whether the group is a security group. Returned by default.
     * Supports $filter.
     */
    @JsonProperty(value = "securityEnabled")
    private Boolean securityEnabled;

    /*
     * Security identifier of the group, used in Windows scenarios. Returned by
     * default.
     */
    @JsonProperty(value = "securityIdentifier")
    private String securityIdentifier;

    /*
     * Specifies an Microsoft 365 group's color theme. Possible values are
     * Teal, Purple, Green, Blue, Pink, Orange or Red. Returned by default.
     */
    @JsonProperty(value = "theme")
    private String theme;

    /*
     * Specifies the visibility of a Microsoft 365 group. Possible values are:
     * Private, Public, or Hiddenmembership; blank values are treated as
     * public.  See group visibility options to learn more.Visibility can be
     * set only when a group is created; it is not editable.Visibility is
     * supported only for unified groups; it is not supported for security
     * groups. Returned by default.
     */
    @JsonProperty(value = "visibility")
    private String visibility;

    /*
     * Indicates if people external to the organization can send messages to
     * the group. Default value is false. Returned only on $select.
     */
    @JsonProperty(value = "allowExternalSenders")
    private Boolean allowExternalSenders;

    /*
     * Indicates if new members added to the group will be auto-subscribed to
     * receive email notifications. You can set this property in a PATCH
     * request for the group; do not set it in the initial POST request that
     * creates the group. Default value is false. Returned only on $select.
     */
    @JsonProperty(value = "autoSubscribeNewMembers")
    private Boolean autoSubscribeNewMembers;

    /*
     * True if the group is not displayed in certain parts of the Outlook UI:
     * the Address Book, address lists for selecting message recipients, and
     * the Browse Groups dialog for searching groups; otherwise, false. Default
     * value is false. Returned only on $select.
     */
    @JsonProperty(value = "hideFromAddressLists")
    private Boolean hideFromAddressLists;

    /*
     * True if the group is not displayed in Outlook clients, such as Outlook
     * for Windows and Outlook on the web; otherwise, false. Default value is
     * false. Returned only on $select.
     */
    @JsonProperty(value = "hideFromOutlookClients")
    private Boolean hideFromOutlookClients;

    /*
     * Indicates whether the signed-in user is subscribed to receive email
     * conversations. Default value is true. Returned only on $select.
     */
    @JsonProperty(value = "isSubscribedByMail")
    private Boolean isSubscribedByMail;

    /*
     * Count of conversations that have received new posts since the signed-in
     * user last visited the group. Returned only on $select.
     */
    @JsonProperty(value = "unseenCount")
    private Integer unseenCount;

    /*
     * The isArchived property.
     */
    @JsonProperty(value = "isArchived")
    private Boolean isArchived;

    /*
     * The appRoleAssignments property.
     */
    @JsonProperty(value = "appRoleAssignments")
    private List<MicrosoftGraphAppRoleAssignment> appRoleAssignments;

    /*
     * directoryObject Represents an Azure Active Directory object. The
     * directoryObject type is the base type for many other directory entity
     * types.
     */
    @JsonProperty(value = "createdOnBehalfOf")
    private MicrosoftGraphDirectoryObjectInner createdOnBehalfOf;

    /*
     * Groups that this group is a member of. HTTP Methods: GET (supported for
     * all groups). Read-only. Nullable.
     */
    @JsonProperty(value = "memberOf")
    private List<MicrosoftGraphDirectoryObjectInner> memberOf;

    /*
     * Users and groups that are members of this group. HTTP Methods: GET
     * (supported for all groups), POST (supported for Microsoft 365 groups,
     * security groups and mail-enabled security groups), DELETE (supported for
     * Microsoft 365 groups and security groups) Nullable.
     */
    @JsonProperty(value = "members")
    private List<MicrosoftGraphDirectoryObjectInner> members;

    /*
     * A list of group members with license errors from this group-based
     * license assignment. Read-only.
     */
    @JsonProperty(value = "membersWithLicenseErrors")
    private List<MicrosoftGraphDirectoryObjectInner> membersWithLicenseErrors;

    /*
     * The owners of the group. The owners are a set of non-admin users who are
     * allowed to modify this object. Limited to 100 owners. HTTP Methods: GET
     * (supported for all groups), POST (supported for Microsoft 365 groups,
     * security groups and mail-enabled security groups), DELETE (supported for
     * Microsoft 365 groups and security groups). Nullable.
     */
    @JsonProperty(value = "owners")
    private List<MicrosoftGraphDirectoryObjectInner> owners;

    /*
     * The permissionGrants property.
     */
    @JsonProperty(value = "permissionGrants")
    private List<MicrosoftGraphResourceSpecificPermissionGrant> permissionGrants;

    /*
     * Read-only. Nullable.
     */
    @JsonProperty(value = "settings")
    private List<MicrosoftGraphGroupSetting> settings;

    /*
     * The transitiveMemberOf property.
     */
    @JsonProperty(value = "transitiveMemberOf")
    private List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf;

    /*
     * The transitiveMembers property.
     */
    @JsonProperty(value = "transitiveMembers")
    private List<MicrosoftGraphDirectoryObjectInner> transitiveMembers;

    /*
     * The list of users or groups that are allowed to create post's or
     * calendar events in this group. If this list is non-empty then only users
     * or groups listed here are allowed to post.
     */
    @JsonProperty(value = "acceptedSenders")
    private List<MicrosoftGraphDirectoryObjectInner> acceptedSenders;

    /*
     * calendar
     */
    @JsonProperty(value = "calendar")
    private MicrosoftGraphCalendar calendar;

    /*
     * The calendar view for the calendar. Read-only.
     */
    @JsonProperty(value = "calendarView")
    private List<MicrosoftGraphEvent> calendarView;

    /*
     * The group's conversations.
     */
    @JsonProperty(value = "conversations")
    private List<MicrosoftGraphConversation> conversations;

    /*
     * The group's calendar events.
     */
    @JsonProperty(value = "events")
    private List<MicrosoftGraphEvent> events;

    /*
     * profilePhoto
     */
    @JsonProperty(value = "photo")
    private MicrosoftGraphProfilePhoto photo;

    /*
     * The profile photos owned by the group. Read-only. Nullable.
     */
    @JsonProperty(value = "photos")
    private List<MicrosoftGraphProfilePhoto> photos;

    /*
     * The list of users or groups that are not allowed to create posts or
     * calendar events in this group. Nullable
     */
    @JsonProperty(value = "rejectedSenders")
    private List<MicrosoftGraphDirectoryObjectInner> rejectedSenders;

    /*
     * The group's conversation threads. Nullable.
     */
    @JsonProperty(value = "threads")
    private List<MicrosoftGraphConversationThread> threads;

    /*
     * drive
     */
    @JsonProperty(value = "drive")
    private MicrosoftGraphDrive drive;

    /*
     * The group's drives. Read-only.
     */
    @JsonProperty(value = "drives")
    private List<MicrosoftGraphDrive> drives;

    /*
     * The list of SharePoint sites in this group. Access the default site with
     * /sites/root.
     */
    @JsonProperty(value = "sites")
    private List<MicrosoftGraphSite> sites;

    /*
     * The collection of open extensions defined for the group. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "extensions")
    private List<MicrosoftGraphExtension> extensions;

    /*
     * The collection of lifecycle policies for this group. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "groupLifecyclePolicies")
    private List<MicrosoftGraphGroupLifecyclePolicy> groupLifecyclePolicies;

    /*
     * plannerGroup
     */
    @JsonProperty(value = "planner")
    private MicrosoftGraphPlannerGroup planner;

    /*
     * onenote
     */
    @JsonProperty(value = "onenote")
    private MicrosoftGraphOnenote onenote;

    /*
     * team
     */
    @JsonProperty(value = "team")
    private MicrosoftGraphTeamInner team;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the assignedLabels property: The list of sensitivity label pairs (label ID, label name) associated with an
     * Microsoft 365 group. Returned only on $select. Read-only.
     *
     * @return the assignedLabels value.
     */
    public List<MicrosoftGraphAssignedLabel> assignedLabels() {
        return this.assignedLabels;
    }

    /**
     * Set the assignedLabels property: The list of sensitivity label pairs (label ID, label name) associated with an
     * Microsoft 365 group. Returned only on $select. Read-only.
     *
     * @param assignedLabels the assignedLabels value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAssignedLabels(List<MicrosoftGraphAssignedLabel> assignedLabels) {
        this.assignedLabels = assignedLabels;
        return this;
    }

    /**
     * Get the assignedLicenses property: The licenses that are assigned to the group. Returned only on $select.
     * Read-only.
     *
     * @return the assignedLicenses value.
     */
    public List<MicrosoftGraphAssignedLicense> assignedLicenses() {
        return this.assignedLicenses;
    }

    /**
     * Set the assignedLicenses property: The licenses that are assigned to the group. Returned only on $select.
     * Read-only.
     *
     * @param assignedLicenses the assignedLicenses value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAssignedLicenses(List<MicrosoftGraphAssignedLicense> assignedLicenses) {
        this.assignedLicenses = assignedLicenses;
        return this;
    }

    /**
     * Get the classification property: Describes a classification for the group (such as low, medium or high business
     * impact). Valid values for this property are defined by creating a ClassificationList setting value, based on the
     * template definition.Returned by default.
     *
     * @return the classification value.
     */
    public String classification() {
        return this.classification;
    }

    /**
     * Set the classification property: Describes a classification for the group (such as low, medium or high business
     * impact). Valid values for this property are defined by creating a ClassificationList setting value, based on the
     * template definition.Returned by default.
     *
     * @param classification the classification value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withClassification(String classification) {
        this.classification = classification;
        return this;
    }

    /**
     * Get the createdDateTime property: Timestamp of when the group was created. The value cannot be modified and is
     * automatically populated when the group is created. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Timestamp of when the group was created. The value cannot be modified and is
     * automatically populated when the group is created. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     *
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the description property: An optional description for the group. Returned by default.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: An optional description for the group. Returned by default.
     *
     * @param description the description value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: The display name for the group. This property is required when a group is created
     * and cannot be cleared during updates. Returned by default. Supports $filter and $orderby.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name for the group. This property is required when a group is created
     * and cannot be cleared during updates. Returned by default. Supports $filter and $orderby.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the expirationDateTime property: Timestamp of when the group is set to expire. The value cannot be modified
     * and is automatically populated when the group is created. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     *
     * @return the expirationDateTime value.
     */
    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * Set the expirationDateTime property: Timestamp of when the group is set to expire. The value cannot be modified
     * and is automatically populated when the group is created. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     *
     * @param expirationDateTime the expirationDateTime value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    /**
     * Get the groupTypes property: Specifies the group type and its membership. If the collection contains Unified, the
     * group is a Microsoft 365 group; otherwise, it's either a security group or distribution group. For details, see
     * groups overview.If the collection includes DynamicMembership, the group has dynamic membership; otherwise,
     * membership is static. Returned by default. Supports $filter.
     *
     * @return the groupTypes value.
     */
    public List<String> groupTypes() {
        return this.groupTypes;
    }

    /**
     * Set the groupTypes property: Specifies the group type and its membership. If the collection contains Unified, the
     * group is a Microsoft 365 group; otherwise, it's either a security group or distribution group. For details, see
     * groups overview.If the collection includes DynamicMembership, the group has dynamic membership; otherwise,
     * membership is static. Returned by default. Supports $filter.
     *
     * @param groupTypes the groupTypes value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withGroupTypes(List<String> groupTypes) {
        this.groupTypes = groupTypes;
        return this;
    }

    /**
     * Get the hasMembersWithLicenseErrors property: Indicates whether there are members in this group that have license
     * errors from its group-based license assignment. This property is never returned on a GET operation. You can use
     * it as a $filter argument to get groups that have members with license errors (that is, filter for this property
     * being true). See an example.
     *
     * @return the hasMembersWithLicenseErrors value.
     */
    public Boolean hasMembersWithLicenseErrors() {
        return this.hasMembersWithLicenseErrors;
    }

    /**
     * Set the hasMembersWithLicenseErrors property: Indicates whether there are members in this group that have license
     * errors from its group-based license assignment. This property is never returned on a GET operation. You can use
     * it as a $filter argument to get groups that have members with license errors (that is, filter for this property
     * being true). See an example.
     *
     * @param hasMembersWithLicenseErrors the hasMembersWithLicenseErrors value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withHasMembersWithLicenseErrors(Boolean hasMembersWithLicenseErrors) {
        this.hasMembersWithLicenseErrors = hasMembersWithLicenseErrors;
        return this;
    }

    /**
     * Get the licenseProcessingState property: licenseProcessingState.
     *
     * @return the licenseProcessingState value.
     */
    public MicrosoftGraphLicenseProcessingState licenseProcessingState() {
        return this.licenseProcessingState;
    }

    /**
     * Set the licenseProcessingState property: licenseProcessingState.
     *
     * @param licenseProcessingState the licenseProcessingState value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withLicenseProcessingState(
        MicrosoftGraphLicenseProcessingState licenseProcessingState) {
        this.licenseProcessingState = licenseProcessingState;
        return this;
    }

    /**
     * Get the mail property: The SMTP address for the group, for example, 'serviceadmins@contoso.onmicrosoft.com'.
     * Returned by default. Read-only. Supports $filter.
     *
     * @return the mail value.
     */
    public String mail() {
        return this.mail;
    }

    /**
     * Set the mail property: The SMTP address for the group, for example, 'serviceadmins@contoso.onmicrosoft.com'.
     * Returned by default. Read-only. Supports $filter.
     *
     * @param mail the mail value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMail(String mail) {
        this.mail = mail;
        return this;
    }

    /**
     * Get the mailEnabled property: Specifies whether the group is mail-enabled. Returned by default.
     *
     * @return the mailEnabled value.
     */
    public Boolean mailEnabled() {
        return this.mailEnabled;
    }

    /**
     * Set the mailEnabled property: Specifies whether the group is mail-enabled. Returned by default.
     *
     * @param mailEnabled the mailEnabled value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMailEnabled(Boolean mailEnabled) {
        this.mailEnabled = mailEnabled;
        return this;
    }

    /**
     * Get the mailNickname property: The mailNickname property.
     *
     * @return the mailNickname value.
     */
    public String mailNickname() {
        return this.mailNickname;
    }

    /**
     * Set the mailNickname property: The mailNickname property.
     *
     * @param mailNickname the mailNickname value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMailNickname(String mailNickname) {
        this.mailNickname = mailNickname;
        return this;
    }

    /**
     * Get the membershipRule property: The rule that determines members for this group if the group is a dynamic group
     * (groupTypes contains DynamicMembership). For more information about the syntax of the membership rule, see
     * Membership Rules syntax. Returned by default.
     *
     * @return the membershipRule value.
     */
    public String membershipRule() {
        return this.membershipRule;
    }

    /**
     * Set the membershipRule property: The rule that determines members for this group if the group is a dynamic group
     * (groupTypes contains DynamicMembership). For more information about the syntax of the membership rule, see
     * Membership Rules syntax. Returned by default.
     *
     * @param membershipRule the membershipRule value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMembershipRule(String membershipRule) {
        this.membershipRule = membershipRule;
        return this;
    }

    /**
     * Get the membershipRuleProcessingState property: Indicates whether the dynamic membership processing is on or
     * paused. Possible values are 'On' or 'Paused'. Returned by default.
     *
     * @return the membershipRuleProcessingState value.
     */
    public String membershipRuleProcessingState() {
        return this.membershipRuleProcessingState;
    }

    /**
     * Set the membershipRuleProcessingState property: Indicates whether the dynamic membership processing is on or
     * paused. Possible values are 'On' or 'Paused'. Returned by default.
     *
     * @param membershipRuleProcessingState the membershipRuleProcessingState value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMembershipRuleProcessingState(String membershipRuleProcessingState) {
        this.membershipRuleProcessingState = membershipRuleProcessingState;
        return this;
    }

    /**
     * Get the onPremisesDomainName property: The onPremisesDomainName property.
     *
     * @return the onPremisesDomainName value.
     */
    public String onPremisesDomainName() {
        return this.onPremisesDomainName;
    }

    /**
     * Set the onPremisesDomainName property: The onPremisesDomainName property.
     *
     * @param onPremisesDomainName the onPremisesDomainName value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesDomainName(String onPremisesDomainName) {
        this.onPremisesDomainName = onPremisesDomainName;
        return this;
    }

    /**
     * Get the onPremisesLastSyncDateTime property: The onPremisesLastSyncDateTime property.
     *
     * @return the onPremisesLastSyncDateTime value.
     */
    public OffsetDateTime onPremisesLastSyncDateTime() {
        return this.onPremisesLastSyncDateTime;
    }

    /**
     * Set the onPremisesLastSyncDateTime property: The onPremisesLastSyncDateTime property.
     *
     * @param onPremisesLastSyncDateTime the onPremisesLastSyncDateTime value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return this;
    }

    /**
     * Get the onPremisesNetBiosName property: The onPremisesNetBiosName property.
     *
     * @return the onPremisesNetBiosName value.
     */
    public String onPremisesNetBiosName() {
        return this.onPremisesNetBiosName;
    }

    /**
     * Set the onPremisesNetBiosName property: The onPremisesNetBiosName property.
     *
     * @param onPremisesNetBiosName the onPremisesNetBiosName value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesNetBiosName(String onPremisesNetBiosName) {
        this.onPremisesNetBiosName = onPremisesNetBiosName;
        return this;
    }

    /**
     * Get the onPremisesProvisioningErrors property: The onPremisesProvisioningErrors property.
     *
     * @return the onPremisesProvisioningErrors value.
     */
    public List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors() {
        return this.onPremisesProvisioningErrors;
    }

    /**
     * Set the onPremisesProvisioningErrors property: The onPremisesProvisioningErrors property.
     *
     * @param onPremisesProvisioningErrors the onPremisesProvisioningErrors value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesProvisioningErrors(
        List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors) {
        this.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
        return this;
    }

    /**
     * Get the onPremisesSamAccountName property: Contains the on-premises SAM account name synchronized from the
     * on-premises directory. The property is only populated for customers who are synchronizing their on-premises
     * directory to Azure Active Directory via Azure AD Connect.Returned by default. Read-only.
     *
     * @return the onPremisesSamAccountName value.
     */
    public String onPremisesSamAccountName() {
        return this.onPremisesSamAccountName;
    }

    /**
     * Set the onPremisesSamAccountName property: Contains the on-premises SAM account name synchronized from the
     * on-premises directory. The property is only populated for customers who are synchronizing their on-premises
     * directory to Azure Active Directory via Azure AD Connect.Returned by default. Read-only.
     *
     * @param onPremisesSamAccountName the onPremisesSamAccountName value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesSamAccountName(String onPremisesSamAccountName) {
        this.onPremisesSamAccountName = onPremisesSamAccountName;
        return this;
    }

    /**
     * Get the onPremisesSecurityIdentifier property: Contains the on-premises security identifier (SID) for the group
     * that was synchronized from on-premises to the cloud. Returned by default. Read-only.
     *
     * @return the onPremisesSecurityIdentifier value.
     */
    public String onPremisesSecurityIdentifier() {
        return this.onPremisesSecurityIdentifier;
    }

    /**
     * Set the onPremisesSecurityIdentifier property: Contains the on-premises security identifier (SID) for the group
     * that was synchronized from on-premises to the cloud. Returned by default. Read-only.
     *
     * @param onPremisesSecurityIdentifier the onPremisesSecurityIdentifier value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
        this.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        return this;
    }

    /**
     * Get the onPremisesSyncEnabled property: true if this group is synced from an on-premises directory; false if this
     * group was originally synced from an on-premises directory but is no longer synced; null if this object has never
     * been synced from an on-premises directory (default). Returned by default. Read-only. Supports $filter.
     *
     * @return the onPremisesSyncEnabled value.
     */
    public Boolean onPremisesSyncEnabled() {
        return this.onPremisesSyncEnabled;
    }

    /**
     * Set the onPremisesSyncEnabled property: true if this group is synced from an on-premises directory; false if this
     * group was originally synced from an on-premises directory but is no longer synced; null if this object has never
     * been synced from an on-premises directory (default). Returned by default. Read-only. Supports $filter.
     *
     * @param onPremisesSyncEnabled the onPremisesSyncEnabled value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        this.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return this;
    }

    /**
     * Get the preferredDataLocation property: The preferred data location for the group. For more information, see
     * OneDrive Online Multi-Geo. Returned by default.
     *
     * @return the preferredDataLocation value.
     */
    public String preferredDataLocation() {
        return this.preferredDataLocation;
    }

    /**
     * Set the preferredDataLocation property: The preferred data location for the group. For more information, see
     * OneDrive Online Multi-Geo. Returned by default.
     *
     * @param preferredDataLocation the preferredDataLocation value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPreferredDataLocation(String preferredDataLocation) {
        this.preferredDataLocation = preferredDataLocation;
        return this;
    }

    /**
     * Get the preferredLanguage property: The preferred language for an Microsoft 365 group. Should follow ISO 639-1
     * Code; for example 'en-US'. Returned by default.
     *
     * @return the preferredLanguage value.
     */
    public String preferredLanguage() {
        return this.preferredLanguage;
    }

    /**
     * Set the preferredLanguage property: The preferred language for an Microsoft 365 group. Should follow ISO 639-1
     * Code; for example 'en-US'. Returned by default.
     *
     * @param preferredLanguage the preferredLanguage value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
        return this;
    }

    /**
     * Get the proxyAddresses property: The proxyAddresses property.
     *
     * @return the proxyAddresses value.
     */
    public List<String> proxyAddresses() {
        return this.proxyAddresses;
    }

    /**
     * Set the proxyAddresses property: The proxyAddresses property.
     *
     * @param proxyAddresses the proxyAddresses value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withProxyAddresses(List<String> proxyAddresses) {
        this.proxyAddresses = proxyAddresses;
        return this;
    }

    /**
     * Get the renewedDateTime property: Timestamp of when the group was last renewed. This cannot be modified directly
     * and is only updated via the renew service action. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     *
     * @return the renewedDateTime value.
     */
    public OffsetDateTime renewedDateTime() {
        return this.renewedDateTime;
    }

    /**
     * Set the renewedDateTime property: Timestamp of when the group was last renewed. This cannot be modified directly
     * and is only updated via the renew service action. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     *
     * @param renewedDateTime the renewedDateTime value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withRenewedDateTime(OffsetDateTime renewedDateTime) {
        this.renewedDateTime = renewedDateTime;
        return this;
    }

    /**
     * Get the securityEnabled property: Specifies whether the group is a security group. Returned by default. Supports
     * $filter.
     *
     * @return the securityEnabled value.
     */
    public Boolean securityEnabled() {
        return this.securityEnabled;
    }

    /**
     * Set the securityEnabled property: Specifies whether the group is a security group. Returned by default. Supports
     * $filter.
     *
     * @param securityEnabled the securityEnabled value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withSecurityEnabled(Boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
        return this;
    }

    /**
     * Get the securityIdentifier property: Security identifier of the group, used in Windows scenarios. Returned by
     * default.
     *
     * @return the securityIdentifier value.
     */
    public String securityIdentifier() {
        return this.securityIdentifier;
    }

    /**
     * Set the securityIdentifier property: Security identifier of the group, used in Windows scenarios. Returned by
     * default.
     *
     * @param securityIdentifier the securityIdentifier value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withSecurityIdentifier(String securityIdentifier) {
        this.securityIdentifier = securityIdentifier;
        return this;
    }

    /**
     * Get the theme property: Specifies an Microsoft 365 group's color theme. Possible values are Teal, Purple, Green,
     * Blue, Pink, Orange or Red. Returned by default.
     *
     * @return the theme value.
     */
    public String theme() {
        return this.theme;
    }

    /**
     * Set the theme property: Specifies an Microsoft 365 group's color theme. Possible values are Teal, Purple, Green,
     * Blue, Pink, Orange or Red. Returned by default.
     *
     * @param theme the theme value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withTheme(String theme) {
        this.theme = theme;
        return this;
    }

    /**
     * Get the visibility property: Specifies the visibility of a Microsoft 365 group. Possible values are: Private,
     * Public, or Hiddenmembership; blank values are treated as public. See group visibility options to learn
     * more.Visibility can be set only when a group is created; it is not editable.Visibility is supported only for
     * unified groups; it is not supported for security groups. Returned by default.
     *
     * @return the visibility value.
     */
    public String visibility() {
        return this.visibility;
    }

    /**
     * Set the visibility property: Specifies the visibility of a Microsoft 365 group. Possible values are: Private,
     * Public, or Hiddenmembership; blank values are treated as public. See group visibility options to learn
     * more.Visibility can be set only when a group is created; it is not editable.Visibility is supported only for
     * unified groups; it is not supported for security groups. Returned by default.
     *
     * @param visibility the visibility value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withVisibility(String visibility) {
        this.visibility = visibility;
        return this;
    }

    /**
     * Get the allowExternalSenders property: Indicates if people external to the organization can send messages to the
     * group. Default value is false. Returned only on $select.
     *
     * @return the allowExternalSenders value.
     */
    public Boolean allowExternalSenders() {
        return this.allowExternalSenders;
    }

    /**
     * Set the allowExternalSenders property: Indicates if people external to the organization can send messages to the
     * group. Default value is false. Returned only on $select.
     *
     * @param allowExternalSenders the allowExternalSenders value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAllowExternalSenders(Boolean allowExternalSenders) {
        this.allowExternalSenders = allowExternalSenders;
        return this;
    }

    /**
     * Get the autoSubscribeNewMembers property: Indicates if new members added to the group will be auto-subscribed to
     * receive email notifications. You can set this property in a PATCH request for the group; do not set it in the
     * initial POST request that creates the group. Default value is false. Returned only on $select.
     *
     * @return the autoSubscribeNewMembers value.
     */
    public Boolean autoSubscribeNewMembers() {
        return this.autoSubscribeNewMembers;
    }

    /**
     * Set the autoSubscribeNewMembers property: Indicates if new members added to the group will be auto-subscribed to
     * receive email notifications. You can set this property in a PATCH request for the group; do not set it in the
     * initial POST request that creates the group. Default value is false. Returned only on $select.
     *
     * @param autoSubscribeNewMembers the autoSubscribeNewMembers value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAutoSubscribeNewMembers(Boolean autoSubscribeNewMembers) {
        this.autoSubscribeNewMembers = autoSubscribeNewMembers;
        return this;
    }

    /**
     * Get the hideFromAddressLists property: True if the group is not displayed in certain parts of the Outlook UI: the
     * Address Book, address lists for selecting message recipients, and the Browse Groups dialog for searching groups;
     * otherwise, false. Default value is false. Returned only on $select.
     *
     * @return the hideFromAddressLists value.
     */
    public Boolean hideFromAddressLists() {
        return this.hideFromAddressLists;
    }

    /**
     * Set the hideFromAddressLists property: True if the group is not displayed in certain parts of the Outlook UI: the
     * Address Book, address lists for selecting message recipients, and the Browse Groups dialog for searching groups;
     * otherwise, false. Default value is false. Returned only on $select.
     *
     * @param hideFromAddressLists the hideFromAddressLists value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withHideFromAddressLists(Boolean hideFromAddressLists) {
        this.hideFromAddressLists = hideFromAddressLists;
        return this;
    }

    /**
     * Get the hideFromOutlookClients property: True if the group is not displayed in Outlook clients, such as Outlook
     * for Windows and Outlook on the web; otherwise, false. Default value is false. Returned only on $select.
     *
     * @return the hideFromOutlookClients value.
     */
    public Boolean hideFromOutlookClients() {
        return this.hideFromOutlookClients;
    }

    /**
     * Set the hideFromOutlookClients property: True if the group is not displayed in Outlook clients, such as Outlook
     * for Windows and Outlook on the web; otherwise, false. Default value is false. Returned only on $select.
     *
     * @param hideFromOutlookClients the hideFromOutlookClients value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withHideFromOutlookClients(Boolean hideFromOutlookClients) {
        this.hideFromOutlookClients = hideFromOutlookClients;
        return this;
    }

    /**
     * Get the isSubscribedByMail property: Indicates whether the signed-in user is subscribed to receive email
     * conversations. Default value is true. Returned only on $select.
     *
     * @return the isSubscribedByMail value.
     */
    public Boolean isSubscribedByMail() {
        return this.isSubscribedByMail;
    }

    /**
     * Set the isSubscribedByMail property: Indicates whether the signed-in user is subscribed to receive email
     * conversations. Default value is true. Returned only on $select.
     *
     * @param isSubscribedByMail the isSubscribedByMail value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withIsSubscribedByMail(Boolean isSubscribedByMail) {
        this.isSubscribedByMail = isSubscribedByMail;
        return this;
    }

    /**
     * Get the unseenCount property: Count of conversations that have received new posts since the signed-in user last
     * visited the group. Returned only on $select.
     *
     * @return the unseenCount value.
     */
    public Integer unseenCount() {
        return this.unseenCount;
    }

    /**
     * Set the unseenCount property: Count of conversations that have received new posts since the signed-in user last
     * visited the group. Returned only on $select.
     *
     * @param unseenCount the unseenCount value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withUnseenCount(Integer unseenCount) {
        this.unseenCount = unseenCount;
        return this;
    }

    /**
     * Get the isArchived property: The isArchived property.
     *
     * @return the isArchived value.
     */
    public Boolean isArchived() {
        return this.isArchived;
    }

    /**
     * Set the isArchived property: The isArchived property.
     *
     * @param isArchived the isArchived value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withIsArchived(Boolean isArchived) {
        this.isArchived = isArchived;
        return this;
    }

    /**
     * Get the appRoleAssignments property: The appRoleAssignments property.
     *
     * @return the appRoleAssignments value.
     */
    public List<MicrosoftGraphAppRoleAssignment> appRoleAssignments() {
        return this.appRoleAssignments;
    }

    /**
     * Set the appRoleAssignments property: The appRoleAssignments property.
     *
     * @param appRoleAssignments the appRoleAssignments value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAppRoleAssignments(List<MicrosoftGraphAppRoleAssignment> appRoleAssignments) {
        this.appRoleAssignments = appRoleAssignments;
        return this;
    }

    /**
     * Get the createdOnBehalfOf property: directoryObject Represents an Azure Active Directory object. The
     * directoryObject type is the base type for many other directory entity types.
     *
     * @return the createdOnBehalfOf value.
     */
    public MicrosoftGraphDirectoryObjectInner createdOnBehalfOf() {
        return this.createdOnBehalfOf;
    }

    /**
     * Set the createdOnBehalfOf property: directoryObject Represents an Azure Active Directory object. The
     * directoryObject type is the base type for many other directory entity types.
     *
     * @param createdOnBehalfOf the createdOnBehalfOf value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withCreatedOnBehalfOf(MicrosoftGraphDirectoryObjectInner createdOnBehalfOf) {
        this.createdOnBehalfOf = createdOnBehalfOf;
        return this;
    }

    /**
     * Get the memberOf property: Groups that this group is a member of. HTTP Methods: GET (supported for all groups).
     * Read-only. Nullable.
     *
     * @return the memberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> memberOf() {
        return this.memberOf;
    }

    /**
     * Set the memberOf property: Groups that this group is a member of. HTTP Methods: GET (supported for all groups).
     * Read-only. Nullable.
     *
     * @param memberOf the memberOf value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMemberOf(List<MicrosoftGraphDirectoryObjectInner> memberOf) {
        this.memberOf = memberOf;
        return this;
    }

    /**
     * Get the members property: Users and groups that are members of this group. HTTP Methods: GET (supported for all
     * groups), POST (supported for Microsoft 365 groups, security groups and mail-enabled security groups), DELETE
     * (supported for Microsoft 365 groups and security groups) Nullable.
     *
     * @return the members value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> members() {
        return this.members;
    }

    /**
     * Set the members property: Users and groups that are members of this group. HTTP Methods: GET (supported for all
     * groups), POST (supported for Microsoft 365 groups, security groups and mail-enabled security groups), DELETE
     * (supported for Microsoft 365 groups and security groups) Nullable.
     *
     * @param members the members value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMembers(List<MicrosoftGraphDirectoryObjectInner> members) {
        this.members = members;
        return this;
    }

    /**
     * Get the membersWithLicenseErrors property: A list of group members with license errors from this group-based
     * license assignment. Read-only.
     *
     * @return the membersWithLicenseErrors value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> membersWithLicenseErrors() {
        return this.membersWithLicenseErrors;
    }

    /**
     * Set the membersWithLicenseErrors property: A list of group members with license errors from this group-based
     * license assignment. Read-only.
     *
     * @param membersWithLicenseErrors the membersWithLicenseErrors value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMembersWithLicenseErrors(
        List<MicrosoftGraphDirectoryObjectInner> membersWithLicenseErrors) {
        this.membersWithLicenseErrors = membersWithLicenseErrors;
        return this;
    }

    /**
     * Get the owners property: The owners of the group. The owners are a set of non-admin users who are allowed to
     * modify this object. Limited to 100 owners. HTTP Methods: GET (supported for all groups), POST (supported for
     * Microsoft 365 groups, security groups and mail-enabled security groups), DELETE (supported for Microsoft 365
     * groups and security groups). Nullable.
     *
     * @return the owners value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> owners() {
        return this.owners;
    }

    /**
     * Set the owners property: The owners of the group. The owners are a set of non-admin users who are allowed to
     * modify this object. Limited to 100 owners. HTTP Methods: GET (supported for all groups), POST (supported for
     * Microsoft 365 groups, security groups and mail-enabled security groups), DELETE (supported for Microsoft 365
     * groups and security groups). Nullable.
     *
     * @param owners the owners value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOwners(List<MicrosoftGraphDirectoryObjectInner> owners) {
        this.owners = owners;
        return this;
    }

    /**
     * Get the permissionGrants property: The permissionGrants property.
     *
     * @return the permissionGrants value.
     */
    public List<MicrosoftGraphResourceSpecificPermissionGrant> permissionGrants() {
        return this.permissionGrants;
    }

    /**
     * Set the permissionGrants property: The permissionGrants property.
     *
     * @param permissionGrants the permissionGrants value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPermissionGrants(
        List<MicrosoftGraphResourceSpecificPermissionGrant> permissionGrants) {
        this.permissionGrants = permissionGrants;
        return this;
    }

    /**
     * Get the settings property: Read-only. Nullable.
     *
     * @return the settings value.
     */
    public List<MicrosoftGraphGroupSetting> settings() {
        return this.settings;
    }

    /**
     * Set the settings property: Read-only. Nullable.
     *
     * @param settings the settings value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withSettings(List<MicrosoftGraphGroupSetting> settings) {
        this.settings = settings;
        return this;
    }

    /**
     * Get the transitiveMemberOf property: The transitiveMemberOf property.
     *
     * @return the transitiveMemberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf() {
        return this.transitiveMemberOf;
    }

    /**
     * Set the transitiveMemberOf property: The transitiveMemberOf property.
     *
     * @param transitiveMemberOf the transitiveMemberOf value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withTransitiveMemberOf(
        List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf) {
        this.transitiveMemberOf = transitiveMemberOf;
        return this;
    }

    /**
     * Get the transitiveMembers property: The transitiveMembers property.
     *
     * @return the transitiveMembers value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> transitiveMembers() {
        return this.transitiveMembers;
    }

    /**
     * Set the transitiveMembers property: The transitiveMembers property.
     *
     * @param transitiveMembers the transitiveMembers value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withTransitiveMembers(List<MicrosoftGraphDirectoryObjectInner> transitiveMembers) {
        this.transitiveMembers = transitiveMembers;
        return this;
    }

    /**
     * Get the acceptedSenders property: The list of users or groups that are allowed to create post's or calendar
     * events in this group. If this list is non-empty then only users or groups listed here are allowed to post.
     *
     * @return the acceptedSenders value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> acceptedSenders() {
        return this.acceptedSenders;
    }

    /**
     * Set the acceptedSenders property: The list of users or groups that are allowed to create post's or calendar
     * events in this group. If this list is non-empty then only users or groups listed here are allowed to post.
     *
     * @param acceptedSenders the acceptedSenders value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAcceptedSenders(List<MicrosoftGraphDirectoryObjectInner> acceptedSenders) {
        this.acceptedSenders = acceptedSenders;
        return this;
    }

    /**
     * Get the calendar property: calendar.
     *
     * @return the calendar value.
     */
    public MicrosoftGraphCalendar calendar() {
        return this.calendar;
    }

    /**
     * Set the calendar property: calendar.
     *
     * @param calendar the calendar value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withCalendar(MicrosoftGraphCalendar calendar) {
        this.calendar = calendar;
        return this;
    }

    /**
     * Get the calendarView property: The calendar view for the calendar. Read-only.
     *
     * @return the calendarView value.
     */
    public List<MicrosoftGraphEvent> calendarView() {
        return this.calendarView;
    }

    /**
     * Set the calendarView property: The calendar view for the calendar. Read-only.
     *
     * @param calendarView the calendarView value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withCalendarView(List<MicrosoftGraphEvent> calendarView) {
        this.calendarView = calendarView;
        return this;
    }

    /**
     * Get the conversations property: The group's conversations.
     *
     * @return the conversations value.
     */
    public List<MicrosoftGraphConversation> conversations() {
        return this.conversations;
    }

    /**
     * Set the conversations property: The group's conversations.
     *
     * @param conversations the conversations value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withConversations(List<MicrosoftGraphConversation> conversations) {
        this.conversations = conversations;
        return this;
    }

    /**
     * Get the events property: The group's calendar events.
     *
     * @return the events value.
     */
    public List<MicrosoftGraphEvent> events() {
        return this.events;
    }

    /**
     * Set the events property: The group's calendar events.
     *
     * @param events the events value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withEvents(List<MicrosoftGraphEvent> events) {
        this.events = events;
        return this;
    }

    /**
     * Get the photo property: profilePhoto.
     *
     * @return the photo value.
     */
    public MicrosoftGraphProfilePhoto photo() {
        return this.photo;
    }

    /**
     * Set the photo property: profilePhoto.
     *
     * @param photo the photo value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPhoto(MicrosoftGraphProfilePhoto photo) {
        this.photo = photo;
        return this;
    }

    /**
     * Get the photos property: The profile photos owned by the group. Read-only. Nullable.
     *
     * @return the photos value.
     */
    public List<MicrosoftGraphProfilePhoto> photos() {
        return this.photos;
    }

    /**
     * Set the photos property: The profile photos owned by the group. Read-only. Nullable.
     *
     * @param photos the photos value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPhotos(List<MicrosoftGraphProfilePhoto> photos) {
        this.photos = photos;
        return this;
    }

    /**
     * Get the rejectedSenders property: The list of users or groups that are not allowed to create posts or calendar
     * events in this group. Nullable.
     *
     * @return the rejectedSenders value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> rejectedSenders() {
        return this.rejectedSenders;
    }

    /**
     * Set the rejectedSenders property: The list of users or groups that are not allowed to create posts or calendar
     * events in this group. Nullable.
     *
     * @param rejectedSenders the rejectedSenders value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withRejectedSenders(List<MicrosoftGraphDirectoryObjectInner> rejectedSenders) {
        this.rejectedSenders = rejectedSenders;
        return this;
    }

    /**
     * Get the threads property: The group's conversation threads. Nullable.
     *
     * @return the threads value.
     */
    public List<MicrosoftGraphConversationThread> threads() {
        return this.threads;
    }

    /**
     * Set the threads property: The group's conversation threads. Nullable.
     *
     * @param threads the threads value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withThreads(List<MicrosoftGraphConversationThread> threads) {
        this.threads = threads;
        return this;
    }

    /**
     * Get the drive property: drive.
     *
     * @return the drive value.
     */
    public MicrosoftGraphDrive drive() {
        return this.drive;
    }

    /**
     * Set the drive property: drive.
     *
     * @param drive the drive value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withDrive(MicrosoftGraphDrive drive) {
        this.drive = drive;
        return this;
    }

    /**
     * Get the drives property: The group's drives. Read-only.
     *
     * @return the drives value.
     */
    public List<MicrosoftGraphDrive> drives() {
        return this.drives;
    }

    /**
     * Set the drives property: The group's drives. Read-only.
     *
     * @param drives the drives value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withDrives(List<MicrosoftGraphDrive> drives) {
        this.drives = drives;
        return this;
    }

    /**
     * Get the sites property: The list of SharePoint sites in this group. Access the default site with /sites/root.
     *
     * @return the sites value.
     */
    public List<MicrosoftGraphSite> sites() {
        return this.sites;
    }

    /**
     * Set the sites property: The list of SharePoint sites in this group. Access the default site with /sites/root.
     *
     * @param sites the sites value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withSites(List<MicrosoftGraphSite> sites) {
        this.sites = sites;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the group. Read-only. Nullable.
     *
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the group. Read-only. Nullable.
     *
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the groupLifecyclePolicies property: The collection of lifecycle policies for this group. Read-only.
     * Nullable.
     *
     * @return the groupLifecyclePolicies value.
     */
    public List<MicrosoftGraphGroupLifecyclePolicy> groupLifecyclePolicies() {
        return this.groupLifecyclePolicies;
    }

    /**
     * Set the groupLifecyclePolicies property: The collection of lifecycle policies for this group. Read-only.
     * Nullable.
     *
     * @param groupLifecyclePolicies the groupLifecyclePolicies value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withGroupLifecyclePolicies(
        List<MicrosoftGraphGroupLifecyclePolicy> groupLifecyclePolicies) {
        this.groupLifecyclePolicies = groupLifecyclePolicies;
        return this;
    }

    /**
     * Get the planner property: plannerGroup.
     *
     * @return the planner value.
     */
    public MicrosoftGraphPlannerGroup planner() {
        return this.planner;
    }

    /**
     * Set the planner property: plannerGroup.
     *
     * @param planner the planner value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPlanner(MicrosoftGraphPlannerGroup planner) {
        this.planner = planner;
        return this;
    }

    /**
     * Get the onenote property: onenote.
     *
     * @return the onenote value.
     */
    public MicrosoftGraphOnenote onenote() {
        return this.onenote;
    }

    /**
     * Set the onenote property: onenote.
     *
     * @param onenote the onenote value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnenote(MicrosoftGraphOnenote onenote) {
        this.onenote = onenote;
        return this;
    }

    /**
     * Get the team property: team.
     *
     * @return the team value.
     */
    public MicrosoftGraphTeamInner team() {
        return this.team;
    }

    /**
     * Set the team property: team.
     *
     * @param team the team value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withTeam(MicrosoftGraphTeamInner team) {
        this.team = team;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphGroupInner withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphGroupInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (assignedLabels() != null) {
            assignedLabels().forEach(e -> e.validate());
        }
        if (assignedLicenses() != null) {
            assignedLicenses().forEach(e -> e.validate());
        }
        if (licenseProcessingState() != null) {
            licenseProcessingState().validate();
        }
        if (onPremisesProvisioningErrors() != null) {
            onPremisesProvisioningErrors().forEach(e -> e.validate());
        }
        if (appRoleAssignments() != null) {
            appRoleAssignments().forEach(e -> e.validate());
        }
        if (createdOnBehalfOf() != null) {
            createdOnBehalfOf().validate();
        }
        if (memberOf() != null) {
            memberOf().forEach(e -> e.validate());
        }
        if (members() != null) {
            members().forEach(e -> e.validate());
        }
        if (membersWithLicenseErrors() != null) {
            membersWithLicenseErrors().forEach(e -> e.validate());
        }
        if (owners() != null) {
            owners().forEach(e -> e.validate());
        }
        if (permissionGrants() != null) {
            permissionGrants().forEach(e -> e.validate());
        }
        if (settings() != null) {
            settings().forEach(e -> e.validate());
        }
        if (transitiveMemberOf() != null) {
            transitiveMemberOf().forEach(e -> e.validate());
        }
        if (transitiveMembers() != null) {
            transitiveMembers().forEach(e -> e.validate());
        }
        if (acceptedSenders() != null) {
            acceptedSenders().forEach(e -> e.validate());
        }
        if (calendar() != null) {
            calendar().validate();
        }
        if (calendarView() != null) {
            calendarView().forEach(e -> e.validate());
        }
        if (conversations() != null) {
            conversations().forEach(e -> e.validate());
        }
        if (events() != null) {
            events().forEach(e -> e.validate());
        }
        if (photo() != null) {
            photo().validate();
        }
        if (photos() != null) {
            photos().forEach(e -> e.validate());
        }
        if (rejectedSenders() != null) {
            rejectedSenders().forEach(e -> e.validate());
        }
        if (threads() != null) {
            threads().forEach(e -> e.validate());
        }
        if (drive() != null) {
            drive().validate();
        }
        if (drives() != null) {
            drives().forEach(e -> e.validate());
        }
        if (sites() != null) {
            sites().forEach(e -> e.validate());
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (groupLifecyclePolicies() != null) {
            groupLifecyclePolicies().forEach(e -> e.validate());
        }
        if (planner() != null) {
            planner().validate();
        }
        if (onenote() != null) {
            onenote().validate();
        }
        if (team() != null) {
            team().validate();
        }
    }
}
