// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** defaultColumnValue. */
@Fluent
public final class MicrosoftGraphDefaultColumnValue {
    /*
     * The formula used to compute the default value for this column.
     */
    @JsonProperty(value = "formula")
    private String formula;

    /*
     * The direct value to use as the default value for this column.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * defaultColumnValue
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the formula property: The formula used to compute the default value for this column.
     *
     * @return the formula value.
     */
    public String formula() {
        return this.formula;
    }

    /**
     * Set the formula property: The formula used to compute the default value for this column.
     *
     * @param formula the formula value to set.
     * @return the MicrosoftGraphDefaultColumnValue object itself.
     */
    public MicrosoftGraphDefaultColumnValue withFormula(String formula) {
        this.formula = formula;
        return this;
    }

    /**
     * Get the value property: The direct value to use as the default value for this column.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The direct value to use as the default value for this column.
     *
     * @param value the value value to set.
     * @return the MicrosoftGraphDefaultColumnValue object itself.
     */
    public MicrosoftGraphDefaultColumnValue withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the additionalProperties property: defaultColumnValue.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: defaultColumnValue.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDefaultColumnValue object itself.
     */
    public MicrosoftGraphDefaultColumnValue withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
