// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** dateTimeTimeZone. */
@Fluent
public final class MicrosoftGraphDateTimeZone {
    /*
     * A single point of time in a combined date and time representation
     * ({date}T{time}; for example, 2017-08-29T04:00:00.0000000).
     */
    @JsonProperty(value = "dateTime")
    private String dateTime;

    /*
     * Represents a time zone, for example, 'Pacific Standard Time'. See below
     * for more possible values.
     */
    @JsonProperty(value = "timeZone")
    private String timeZone;

    /*
     * dateTimeTimeZone
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the dateTime property: A single point of time in a combined date and time representation ({date}T{time}; for
     * example, 2017-08-29T04:00:00.0000000).
     *
     * @return the dateTime value.
     */
    public String dateTime() {
        return this.dateTime;
    }

    /**
     * Set the dateTime property: A single point of time in a combined date and time representation ({date}T{time}; for
     * example, 2017-08-29T04:00:00.0000000).
     *
     * @param dateTime the dateTime value to set.
     * @return the MicrosoftGraphDateTimeZone object itself.
     */
    public MicrosoftGraphDateTimeZone withDateTime(String dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    /**
     * Get the timeZone property: Represents a time zone, for example, 'Pacific Standard Time'. See below for more
     * possible values.
     *
     * @return the timeZone value.
     */
    public String timeZone() {
        return this.timeZone;
    }

    /**
     * Set the timeZone property: Represents a time zone, for example, 'Pacific Standard Time'. See below for more
     * possible values.
     *
     * @param timeZone the timeZone value to set.
     * @return the MicrosoftGraphDateTimeZone object itself.
     */
    public MicrosoftGraphDateTimeZone withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    /**
     * Get the additionalProperties property: dateTimeTimeZone.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: dateTimeTimeZone.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDateTimeZone object itself.
     */
    public MicrosoftGraphDateTimeZone withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
