// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** CopyNotebookModel. */
@Fluent
public final class MicrosoftGraphCopyNotebookModel {
    /*
     * The createdBy property.
     */
    @JsonProperty(value = "createdBy")
    private String createdBy;

    /*
     * identitySet
     */
    @JsonProperty(value = "createdByIdentity")
    private MicrosoftGraphIdentitySet createdByIdentity;

    /*
     * The createdTime property.
     */
    @JsonProperty(value = "createdTime")
    private OffsetDateTime createdTime;

    /*
     * The id property.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The isDefault property.
     */
    @JsonProperty(value = "isDefault")
    private Boolean isDefault;

    /*
     * The isShared property.
     */
    @JsonProperty(value = "isShared")
    private Boolean isShared;

    /*
     * The lastModifiedBy property.
     */
    @JsonProperty(value = "lastModifiedBy")
    private String lastModifiedBy;

    /*
     * identitySet
     */
    @JsonProperty(value = "lastModifiedByIdentity")
    private MicrosoftGraphIdentitySet lastModifiedByIdentity;

    /*
     * The lastModifiedTime property.
     */
    @JsonProperty(value = "lastModifiedTime")
    private OffsetDateTime lastModifiedTime;

    /*
     * notebookLinks
     */
    @JsonProperty(value = "links")
    private MicrosoftGraphNotebookLinks links;

    /*
     * The name property.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The sectionGroupsUrl property.
     */
    @JsonProperty(value = "sectionGroupsUrl")
    private String sectionGroupsUrl;

    /*
     * The sectionsUrl property.
     */
    @JsonProperty(value = "sectionsUrl")
    private String sectionsUrl;

    /*
     * The self property.
     */
    @JsonProperty(value = "self")
    private String self;

    /*
     * onenoteUserRole
     */
    @JsonProperty(value = "userRole")
    private MicrosoftGraphOnenoteUserRole userRole;

    /*
     * CopyNotebookModel
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the createdBy property: The createdBy property.
     *
     * @return the createdBy value.
     */
    public String createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: The createdBy property.
     *
     * @param createdBy the createdBy value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the createdByIdentity property: identitySet.
     *
     * @return the createdByIdentity value.
     */
    public MicrosoftGraphIdentitySet createdByIdentity() {
        return this.createdByIdentity;
    }

    /**
     * Set the createdByIdentity property: identitySet.
     *
     * @param createdByIdentity the createdByIdentity value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withCreatedByIdentity(MicrosoftGraphIdentitySet createdByIdentity) {
        this.createdByIdentity = createdByIdentity;
        return this;
    }

    /**
     * Get the createdTime property: The createdTime property.
     *
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Set the createdTime property: The createdTime property.
     *
     * @param createdTime the createdTime value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    /**
     * Get the id property: The id property.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id property.
     *
     * @param id the id value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the isDefault property: The isDefault property.
     *
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: The isDefault property.
     *
     * @param isDefault the isDefault value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the isShared property: The isShared property.
     *
     * @return the isShared value.
     */
    public Boolean isShared() {
        return this.isShared;
    }

    /**
     * Set the isShared property: The isShared property.
     *
     * @param isShared the isShared value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withIsShared(Boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    /**
     * Get the lastModifiedBy property: The lastModifiedBy property.
     *
     * @return the lastModifiedBy value.
     */
    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Set the lastModifiedBy property: The lastModifiedBy property.
     *
     * @param lastModifiedBy the lastModifiedBy value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    /**
     * Get the lastModifiedByIdentity property: identitySet.
     *
     * @return the lastModifiedByIdentity value.
     */
    public MicrosoftGraphIdentitySet lastModifiedByIdentity() {
        return this.lastModifiedByIdentity;
    }

    /**
     * Set the lastModifiedByIdentity property: identitySet.
     *
     * @param lastModifiedByIdentity the lastModifiedByIdentity value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withLastModifiedByIdentity(
        MicrosoftGraphIdentitySet lastModifiedByIdentity) {
        this.lastModifiedByIdentity = lastModifiedByIdentity;
        return this;
    }

    /**
     * Get the lastModifiedTime property: The lastModifiedTime property.
     *
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Set the lastModifiedTime property: The lastModifiedTime property.
     *
     * @param lastModifiedTime the lastModifiedTime value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    /**
     * Get the links property: notebookLinks.
     *
     * @return the links value.
     */
    public MicrosoftGraphNotebookLinks links() {
        return this.links;
    }

    /**
     * Set the links property: notebookLinks.
     *
     * @param links the links value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withLinks(MicrosoftGraphNotebookLinks links) {
        this.links = links;
        return this;
    }

    /**
     * Get the name property: The name property.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the sectionGroupsUrl property: The sectionGroupsUrl property.
     *
     * @return the sectionGroupsUrl value.
     */
    public String sectionGroupsUrl() {
        return this.sectionGroupsUrl;
    }

    /**
     * Set the sectionGroupsUrl property: The sectionGroupsUrl property.
     *
     * @param sectionGroupsUrl the sectionGroupsUrl value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withSectionGroupsUrl(String sectionGroupsUrl) {
        this.sectionGroupsUrl = sectionGroupsUrl;
        return this;
    }

    /**
     * Get the sectionsUrl property: The sectionsUrl property.
     *
     * @return the sectionsUrl value.
     */
    public String sectionsUrl() {
        return this.sectionsUrl;
    }

    /**
     * Set the sectionsUrl property: The sectionsUrl property.
     *
     * @param sectionsUrl the sectionsUrl value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withSectionsUrl(String sectionsUrl) {
        this.sectionsUrl = sectionsUrl;
        return this;
    }

    /**
     * Get the self property: The self property.
     *
     * @return the self value.
     */
    public String self() {
        return this.self;
    }

    /**
     * Set the self property: The self property.
     *
     * @param self the self value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withSelf(String self) {
        this.self = self;
        return this;
    }

    /**
     * Get the userRole property: onenoteUserRole.
     *
     * @return the userRole value.
     */
    public MicrosoftGraphOnenoteUserRole userRole() {
        return this.userRole;
    }

    /**
     * Set the userRole property: onenoteUserRole.
     *
     * @param userRole the userRole value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withUserRole(MicrosoftGraphOnenoteUserRole userRole) {
        this.userRole = userRole;
        return this;
    }

    /**
     * Get the additionalProperties property: CopyNotebookModel.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: CopyNotebookModel.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (createdByIdentity() != null) {
            createdByIdentity().validate();
        }
        if (lastModifiedByIdentity() != null) {
            lastModifiedByIdentity().validate();
        }
        if (links() != null) {
            links().validate();
        }
    }
}
