// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.RoleManagementPolicyInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RoleManagementPoliciesClient. */
public interface RoleManagementPoliciesClient extends InnerSupportsDelete<Void> {
    /**
     * Get the specified role management policy for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyName The name (guid) of the role management policy to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy for a resource scope along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleManagementPolicyInner>> getWithResponseAsync(String scope, String roleManagementPolicyName);

    /**
     * Get the specified role management policy for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyName The name (guid) of the role management policy to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy for a resource scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleManagementPolicyInner> getAsync(String scope, String roleManagementPolicyName);

    /**
     * Get the specified role management policy for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyName The name (guid) of the role management policy to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy for a resource scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleManagementPolicyInner get(String scope, String roleManagementPolicyName);

    /**
     * Get the specified role management policy for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyName The name (guid) of the role management policy to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy for a resource scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleManagementPolicyInner> getWithResponse(String scope, String roleManagementPolicyName, Context context);

    /**
     * Update a role management policy.
     *
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param parameters Parameters for the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleManagementPolicyInner>> updateWithResponseAsync(
        String scope, String roleManagementPolicyName, RoleManagementPolicyInner parameters);

    /**
     * Update a role management policy.
     *
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param parameters Parameters for the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleManagementPolicyInner> updateAsync(
        String scope, String roleManagementPolicyName, RoleManagementPolicyInner parameters);

    /**
     * Update a role management policy.
     *
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param parameters Parameters for the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleManagementPolicyInner update(
        String scope, String roleManagementPolicyName, RoleManagementPolicyInner parameters);

    /**
     * Update a role management policy.
     *
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param parameters Parameters for the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleManagementPolicyInner> updateWithResponse(
        String scope, String roleManagementPolicyName, RoleManagementPolicyInner parameters, Context context);

    /**
     * Delete a role management policy.
     *
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String scope, String roleManagementPolicyName);

    /**
     * Delete a role management policy.
     *
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String scope, String roleManagementPolicyName);

    /**
     * Delete a role management policy.
     *
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String scope, String roleManagementPolicyName);

    /**
     * Delete a role management policy.
     *
     * @param scope The scope of the role management policy to upsert.
     * @param roleManagementPolicyName The name (guid) of the role management policy to upsert.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String scope, String roleManagementPolicyName, Context context);

    /**
     * Gets role management policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policies for a resource scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleManagementPolicyInner> listForScopeAsync(String scope);

    /**
     * Gets role management policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policies for a resource scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleManagementPolicyInner> listForScope(String scope);

    /**
     * Gets role management policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policies for a resource scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleManagementPolicyInner> listForScope(String scope, Context context);
}
