/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoryRolesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject8;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject7;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfScopedRoleMembership0;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesSelect;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryRoleInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScopedRoleMembershipInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class DirectoryRolesClientImpl
implements DirectoryRolesClient {
    private final ClientLogger logger = new ClientLogger(DirectoryRolesClientImpl.class);
    private final DirectoryRolesService service;
    private final MicrosoftGraphClientImpl client;

    DirectoryRolesClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (DirectoryRolesService)RestProxy.create(DirectoryRolesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMembers(this.client.getEndpoint(), directoryRoleId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject8)res.getValue()).value(), ((CollectionOfDirectoryObject8)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMembers(this.client.getEndpoint(), directoryRoleId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject8)res.getValue()).value(), ((CollectionOfDirectoryObject8)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMembersSinglePageAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String directoryRoleId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMembersSinglePageAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMembersSinglePageAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String directoryRoleId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryRolesOrderby> orderby = null;
        List<DirectoryRolesSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMembersAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMembersAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefMembers(this.client.getEndpoint(), directoryRoleId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject7)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject7)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefMembers(this.client.getEndpoint(), directoryRoleId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject7)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject7)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(directoryRoleId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(String directoryRoleId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(directoryRoleId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefMembersAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(directoryRoleId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(String directoryRoleId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryRolesOrderby> orderby = null;
        return new PagedIterable(this.listRefMembersAsync(directoryRoleId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMembersAsync(directoryRoleId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefMembersWithResponseAsync(String directoryRoleId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMembers(this.client.getEndpoint(), directoryRoleId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefMembersWithResponseAsync(String directoryRoleId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMembers(this.client.getEndpoint(), directoryRoleId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefMembersAsync(String directoryRoleId, Map<String, Object> body) {
        return this.createRefMembersWithResponseAsync(directoryRoleId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefMembers(String directoryRoleId, Map<String, Object> body) {
        return (Map)this.createRefMembersAsync(directoryRoleId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefMembersWithResponse(String directoryRoleId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMembersWithResponseAsync(directoryRoleId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String directoryRoleId, DirectoryRolesCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberGroups(this.client.getEndpoint(), directoryRoleId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String directoryRoleId, DirectoryRolesCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberGroups(this.client.getEndpoint(), directoryRoleId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberGroupsAsync(String directoryRoleId, DirectoryRolesCheckMemberGroupsRequestBody body) {
        return this.checkMemberGroupsWithResponseAsync(directoryRoleId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberGroups(String directoryRoleId, DirectoryRolesCheckMemberGroupsRequestBody body) {
        return (List)this.checkMemberGroupsAsync(directoryRoleId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberGroupsWithResponse(String directoryRoleId, DirectoryRolesCheckMemberGroupsRequestBody body, Context context) {
        return (Response)this.checkMemberGroupsWithResponseAsync(directoryRoleId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String directoryRoleId, DirectoryRolesCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberObjects(this.client.getEndpoint(), directoryRoleId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String directoryRoleId, DirectoryRolesCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberObjects(this.client.getEndpoint(), directoryRoleId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberObjectsAsync(String directoryRoleId, DirectoryRolesCheckMemberObjectsRequestBody body) {
        return this.checkMemberObjectsWithResponseAsync(directoryRoleId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberObjects(String directoryRoleId, DirectoryRolesCheckMemberObjectsRequestBody body) {
        return (List)this.checkMemberObjectsAsync(directoryRoleId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberObjectsWithResponse(String directoryRoleId, DirectoryRolesCheckMemberObjectsRequestBody body, Context context) {
        return (Response)this.checkMemberObjectsWithResponseAsync(directoryRoleId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String directoryRoleId, DirectoryRolesGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), directoryRoleId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String directoryRoleId, DirectoryRolesGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), directoryRoleId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberGroupsAsync(String directoryRoleId, DirectoryRolesGetMemberGroupsRequestBody body) {
        return this.getMemberGroupsWithResponseAsync(directoryRoleId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberGroups(String directoryRoleId, DirectoryRolesGetMemberGroupsRequestBody body) {
        return (List)this.getMemberGroupsAsync(directoryRoleId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberGroupsWithResponse(String directoryRoleId, DirectoryRolesGetMemberGroupsRequestBody body, Context context) {
        return (Response)this.getMemberGroupsWithResponseAsync(directoryRoleId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String directoryRoleId, DirectoryRolesGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberObjects(this.client.getEndpoint(), directoryRoleId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String directoryRoleId, DirectoryRolesGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberObjects(this.client.getEndpoint(), directoryRoleId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberObjectsAsync(String directoryRoleId, DirectoryRolesGetMemberObjectsRequestBody body) {
        return this.getMemberObjectsWithResponseAsync(directoryRoleId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberObjects(String directoryRoleId, DirectoryRolesGetMemberObjectsRequestBody body) {
        return (List)this.getMemberObjectsAsync(directoryRoleId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberObjectsWithResponse(String directoryRoleId, DirectoryRolesGetMemberObjectsRequestBody body, Context context) {
        return (Response)this.getMemberObjectsWithResponseAsync(directoryRoleId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String directoryRoleId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), directoryRoleId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String directoryRoleId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), directoryRoleId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String directoryRoleId) {
        return this.restoreWithResponseAsync(directoryRoleId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner restore(String directoryRoleId) {
        return (MicrosoftGraphDirectoryObjectInner)this.restoreAsync(directoryRoleId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String directoryRoleId, Context context) {
        return (Response)this.restoreWithResponseAsync(directoryRoleId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedMembersSinglePageAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listScopedMembers(this.client.getEndpoint(), directoryRoleId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership0)res.getValue()).value(), ((CollectionOfScopedRoleMembership0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedMembersSinglePageAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listScopedMembers(this.client.getEndpoint(), directoryRoleId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership0)res.getValue()).value(), ((CollectionOfScopedRoleMembership0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedMembersAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listScopedMembersSinglePageAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listScopedMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedMembersAsync(String directoryRoleId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listScopedMembersSinglePageAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listScopedMembersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedMembersAsync(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listScopedMembersSinglePageAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listScopedMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedMembers(String directoryRoleId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryRolesOrderby> orderby = null;
        List<DirectoryRolesSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listScopedMembersAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedMembers(String directoryRoleId, Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesOrderby> orderby, List<DirectoryRolesSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listScopedMembersAsync(directoryRoleId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedMembersWithResponseAsync(String directoryRoleId, MicrosoftGraphScopedRoleMembershipInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createScopedMembers(this.client.getEndpoint(), directoryRoleId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedMembersWithResponseAsync(String directoryRoleId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createScopedMembers(this.client.getEndpoint(), directoryRoleId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphScopedRoleMembershipInner> createScopedMembersAsync(String directoryRoleId, MicrosoftGraphScopedRoleMembershipInner body) {
        return this.createScopedMembersWithResponseAsync(directoryRoleId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphScopedRoleMembershipInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphScopedRoleMembershipInner createScopedMembers(String directoryRoleId, MicrosoftGraphScopedRoleMembershipInner body) {
        return (MicrosoftGraphScopedRoleMembershipInner)this.createScopedMembersAsync(directoryRoleId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphScopedRoleMembershipInner> createScopedMembersWithResponse(String directoryRoleId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        return (Response)this.createScopedMembersWithResponseAsync(directoryRoleId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedMembersWithResponseAsync(String directoryRoleId, String scopedRoleMembershipId, List<DirectoryRolesSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getScopedMembers(this.client.getEndpoint(), directoryRoleId, scopedRoleMembershipId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedMembersWithResponseAsync(String directoryRoleId, String scopedRoleMembershipId, List<DirectoryRolesSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getScopedMembers(this.client.getEndpoint(), directoryRoleId, scopedRoleMembershipId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedMembersAsync(String directoryRoleId, String scopedRoleMembershipId, List<DirectoryRolesSelect> select, List<String> expand) {
        return this.getScopedMembersWithResponseAsync(directoryRoleId, scopedRoleMembershipId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphScopedRoleMembershipInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedMembersAsync(String directoryRoleId, String scopedRoleMembershipId) {
        List<DirectoryRolesSelect> select = null;
        List<String> expand = null;
        return this.getScopedMembersWithResponseAsync(directoryRoleId, scopedRoleMembershipId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphScopedRoleMembershipInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphScopedRoleMembershipInner getScopedMembers(String directoryRoleId, String scopedRoleMembershipId) {
        List<DirectoryRolesSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphScopedRoleMembershipInner)this.getScopedMembersAsync(directoryRoleId, scopedRoleMembershipId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphScopedRoleMembershipInner> getScopedMembersWithResponse(String directoryRoleId, String scopedRoleMembershipId, List<DirectoryRolesSelect> select, List<String> expand, Context context) {
        return (Response)this.getScopedMembersWithResponseAsync(directoryRoleId, scopedRoleMembershipId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateScopedMembersWithResponseAsync(String directoryRoleId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateScopedMembers(this.client.getEndpoint(), directoryRoleId, scopedRoleMembershipId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateScopedMembersWithResponseAsync(String directoryRoleId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateScopedMembers(this.client.getEndpoint(), directoryRoleId, scopedRoleMembershipId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateScopedMembersAsync(String directoryRoleId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        return this.updateScopedMembersWithResponseAsync(directoryRoleId, scopedRoleMembershipId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateScopedMembers(String directoryRoleId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        this.updateScopedMembersAsync(directoryRoleId, scopedRoleMembershipId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateScopedMembersWithResponse(String directoryRoleId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        return (Response)this.updateScopedMembersWithResponseAsync(directoryRoleId, scopedRoleMembershipId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteScopedMembersWithResponseAsync(String directoryRoleId, String scopedRoleMembershipId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteScopedMembers(this.client.getEndpoint(), directoryRoleId, scopedRoleMembershipId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteScopedMembersWithResponseAsync(String directoryRoleId, String scopedRoleMembershipId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteScopedMembers(this.client.getEndpoint(), directoryRoleId, scopedRoleMembershipId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteScopedMembersAsync(String directoryRoleId, String scopedRoleMembershipId, String ifMatch) {
        return this.deleteScopedMembersWithResponseAsync(directoryRoleId, scopedRoleMembershipId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteScopedMembersAsync(String directoryRoleId, String scopedRoleMembershipId) {
        String ifMatch = null;
        return this.deleteScopedMembersWithResponseAsync(directoryRoleId, scopedRoleMembershipId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteScopedMembers(String directoryRoleId, String scopedRoleMembershipId) {
        String ifMatch = null;
        this.deleteScopedMembersAsync(directoryRoleId, scopedRoleMembershipId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteScopedMembersWithResponse(String directoryRoleId, String scopedRoleMembershipId, String ifMatch, Context context) {
        return (Response)this.deleteScopedMembersWithResponseAsync(directoryRoleId, scopedRoleMembershipId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphDirectoryRoleInner>>> deltaWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delta(this.client.getEndpoint(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphDirectoryRoleInner>>> deltaWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delta(this.client.getEndpoint(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphDirectoryRoleInner>> deltaAsync() {
        return this.deltaWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphDirectoryRoleInner> delta() {
        return (List)this.deltaAsync().block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphDirectoryRoleInner>> deltaWithResponse(Context context) {
        return (Response)this.deltaWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(DirectoryRolesGetAvailableExtensionPropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(DirectoryRolesGetAvailableExtensionPropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(DirectoryRolesGetAvailableExtensionPropertiesRequestBody body) {
        return this.getAvailableExtensionPropertiesWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(DirectoryRolesGetAvailableExtensionPropertiesRequestBody body) {
        return (List)this.getAvailableExtensionPropertiesAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(DirectoryRolesGetAvailableExtensionPropertiesRequestBody body, Context context) {
        return (Response)this.getAvailableExtensionPropertiesWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(DirectoryRolesGetByIdsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByIds(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(DirectoryRolesGetByIdsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByIds(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(DirectoryRolesGetByIdsRequestBody body) {
        return this.getByIdsWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphDirectoryObjectInner> getByIds(DirectoryRolesGetByIdsRequestBody body) {
        return (List)this.getByIdsAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(DirectoryRolesGetByIdsRequestBody body, Context context) {
        return (Response)this.getByIdsWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(DirectoryRolesValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> validatePropertiesWithResponseAsync(DirectoryRolesValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> validatePropertiesAsync(DirectoryRolesValidatePropertiesRequestBody body) {
        return this.validatePropertiesWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validateProperties(DirectoryRolesValidatePropertiesRequestBody body) {
        this.validatePropertiesAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> validatePropertiesWithResponse(DirectoryRolesValidatePropertiesRequestBody body, Context context) {
        return (Response)this.validatePropertiesWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject8)res.getValue()).value(), ((CollectionOfDirectoryObject8)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject8)res.getValue()).value(), ((CollectionOfDirectoryObject8)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject7)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject7)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject7)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject7)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listScopedMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership0)res.getValue()).value(), ((CollectionOfScopedRoleMembership0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listScopedMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership0)res.getValue()).value(), ((CollectionOfScopedRoleMembership0)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface DirectoryRolesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directoryRoles/{directoryRole-id}/members")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject8>> listMembers(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directoryRoles/{directoryRole-id}/members/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject7>> listRefMembers(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/{directoryRole-id}/members/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefMembers(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/{directoryRole-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @BodyParam(value="application/json") DirectoryRolesCheckMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/{directoryRole-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @BodyParam(value="application/json") DirectoryRolesCheckMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/{directoryRole-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @BodyParam(value="application/json") DirectoryRolesGetMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/{directoryRole-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @BodyParam(value="application/json") DirectoryRolesGetMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/{directoryRole-id}/microsoft.graph.restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directoryRoles/{directoryRole-id}/scopedMembers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfScopedRoleMembership0>> listScopedMembers(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/{directoryRole-id}/scopedMembers")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedMembers(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @BodyParam(value="application/json") MicrosoftGraphScopedRoleMembershipInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directoryRoles/{directoryRole-id}/scopedMembers/{scopedRoleMembership-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedMembers(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @PathParam(value="scopedRoleMembership-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/directoryRoles/{directoryRole-id}/scopedMembers/{scopedRoleMembership-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateScopedMembers(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @PathParam(value="scopedRoleMembership-id") String var3, @BodyParam(value="application/json") MicrosoftGraphScopedRoleMembershipInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/directoryRoles/{directoryRole-id}/scopedMembers/{scopedRoleMembership-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteScopedMembers(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @PathParam(value="scopedRoleMembership-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directoryRoles/microsoft.graph.delta()")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphDirectoryRoleInner>>> delta(@HostParam(value="$host") String var1, @HeaderParam(value="Accept") String var2, Context var3);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/microsoft.graph.getAvailableExtensionProperties")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") DirectoryRolesGetAvailableExtensionPropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/microsoft.graph.getByIds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIds(@HostParam(value="$host") String var1, @BodyParam(value="application/json") DirectoryRolesGetByIdsRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles/microsoft.graph.validateProperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> validateProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") DirectoryRolesValidatePropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject8>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject7>> listRefMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfScopedRoleMembership0>> listScopedMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

