/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.authorization.fluent.AuthorizationManagementClient;
import com.azure.resourcemanager.authorization.fluent.MicrosoftGraphClient;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryApplicationsImpl;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryGroupsImpl;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryUsersImpl;
import com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientBuilder;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientBuilder;
import com.azure.resourcemanager.authorization.implementation.RoleAssignmentsImpl;
import com.azure.resourcemanager.authorization.implementation.RoleDefinitionsImpl;
import com.azure.resourcemanager.authorization.implementation.ServicePrincipalsImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplications;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryGroups;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryUsers;
import com.azure.resourcemanager.authorization.models.RoleAssignments;
import com.azure.resourcemanager.authorization.models.RoleDefinitions;
import com.azure.resourcemanager.authorization.models.ServicePrincipals;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.HasServiceClient;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;

public final class AuthorizationManager
implements HasServiceClient<MicrosoftGraphClient> {
    private final String tenantId;
    private final AzureEnvironment environment;
    private ResourceManagerUtils.InternalRuntimeContext internalContext;
    private final MicrosoftGraphClient microsoftGraphClient;
    private final AuthorizationManagementClient authorizationManagementClient;
    private ActiveDirectoryUsers activeDirectoryUsers;
    private ActiveDirectoryGroups activeDirectoryGroups;
    private ServicePrincipals servicePrincipals;
    private ActiveDirectoryApplications applications;
    private RoleAssignments roleAssignments;
    private RoleDefinitions roleDefinitions;
    private static final String DEFAULT_GRAPH_ENDPOINT_SUFFIX = "v1.0";

    public static AuthorizationManager authenticate(TokenCredential credential, AzureProfile profile) {
        return AuthorizationManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    private static AuthorizationManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new AuthorizationManager(httpPipeline, profile);
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public MicrosoftGraphClient serviceClient() {
        return this.microsoftGraphClient;
    }

    private AuthorizationManager(HttpPipeline httpPipeline, AzureProfile profile) {
        String graphEndpoint = profile.getEnvironment().getMicrosoftGraphEndpoint();
        graphEndpoint = graphEndpoint.endsWith("/") ? graphEndpoint + DEFAULT_GRAPH_ENDPOINT_SUFFIX : graphEndpoint + "/" + DEFAULT_GRAPH_ENDPOINT_SUFFIX;
        this.microsoftGraphClient = new MicrosoftGraphClientBuilder().pipeline(httpPipeline).endpoint(graphEndpoint).buildClient();
        this.authorizationManagementClient = new AuthorizationManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient();
        this.tenantId = profile.getTenantId();
        this.environment = profile.getEnvironment();
    }

    public AuthorizationManagementClient roleServiceClient() {
        return this.authorizationManagementClient;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public AzureEnvironment environment() {
        return this.environment;
    }

    public ResourceManagerUtils.InternalRuntimeContext internalContext() {
        if (this.internalContext == null) {
            this.internalContext = new ResourceManagerUtils.InternalRuntimeContext();
        }
        return this.internalContext;
    }

    public ActiveDirectoryUsers users() {
        if (this.activeDirectoryUsers == null) {
            this.activeDirectoryUsers = new ActiveDirectoryUsersImpl(this);
        }
        return this.activeDirectoryUsers;
    }

    public ActiveDirectoryGroups groups() {
        if (this.activeDirectoryGroups == null) {
            this.activeDirectoryGroups = new ActiveDirectoryGroupsImpl(this);
        }
        return this.activeDirectoryGroups;
    }

    public ServicePrincipals servicePrincipals() {
        if (this.servicePrincipals == null) {
            this.servicePrincipals = new ServicePrincipalsImpl(this);
        }
        return this.servicePrincipals;
    }

    public ActiveDirectoryApplications applications() {
        if (this.applications == null) {
            this.applications = new ActiveDirectoryApplicationsImpl(this);
        }
        return this.applications;
    }

    public RoleAssignments roleAssignments() {
        if (this.roleAssignments == null) {
            this.roleAssignments = new RoleAssignmentsImpl(this);
        }
        return this.roleAssignments;
    }

    public RoleDefinitions roleDefinitions() {
        if (this.roleDefinitions == null) {
            this.roleDefinitions = new RoleDefinitionsImpl(this);
        }
        return this.roleDefinitions;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public AuthorizationManager authenticate(TokenCredential credential, AzureProfile profile) {
            return AuthorizationManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public AuthorizationManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

