// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Deny assignment permissions. */
@Fluent
public final class DenyAssignmentPermission {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DenyAssignmentPermission.class);

    /*
     * Actions to which the deny assignment does not grant access.
     */
    @JsonProperty(value = "actions")
    private List<String> actions;

    /*
     * Actions to exclude from that the deny assignment does not grant access.
     */
    @JsonProperty(value = "notActions")
    private List<String> notActions;

    /*
     * Data actions to which the deny assignment does not grant access.
     */
    @JsonProperty(value = "dataActions")
    private List<String> dataActions;

    /*
     * Data actions to exclude from that the deny assignment does not grant
     * access.
     */
    @JsonProperty(value = "notDataActions")
    private List<String> notDataActions;

    /**
     * Get the actions property: Actions to which the deny assignment does not grant access.
     *
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: Actions to which the deny assignment does not grant access.
     *
     * @param actions the actions value to set.
     * @return the DenyAssignmentPermission object itself.
     */
    public DenyAssignmentPermission withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the notActions property: Actions to exclude from that the deny assignment does not grant access.
     *
     * @return the notActions value.
     */
    public List<String> notActions() {
        return this.notActions;
    }

    /**
     * Set the notActions property: Actions to exclude from that the deny assignment does not grant access.
     *
     * @param notActions the notActions value to set.
     * @return the DenyAssignmentPermission object itself.
     */
    public DenyAssignmentPermission withNotActions(List<String> notActions) {
        this.notActions = notActions;
        return this;
    }

    /**
     * Get the dataActions property: Data actions to which the deny assignment does not grant access.
     *
     * @return the dataActions value.
     */
    public List<String> dataActions() {
        return this.dataActions;
    }

    /**
     * Set the dataActions property: Data actions to which the deny assignment does not grant access.
     *
     * @param dataActions the dataActions value to set.
     * @return the DenyAssignmentPermission object itself.
     */
    public DenyAssignmentPermission withDataActions(List<String> dataActions) {
        this.dataActions = dataActions;
        return this;
    }

    /**
     * Get the notDataActions property: Data actions to exclude from that the deny assignment does not grant access.
     *
     * @return the notDataActions value.
     */
    public List<String> notDataActions() {
        return this.notDataActions;
    }

    /**
     * Set the notDataActions property: Data actions to exclude from that the deny assignment does not grant access.
     *
     * @param notDataActions the notDataActions value to set.
     * @return the DenyAssignmentPermission object itself.
     */
    public DenyAssignmentPermission withNotDataActions(List<String> notDataActions) {
        this.notDataActions = notDataActions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
