// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersTodoListsTasksClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtension1;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinkedResource;
import com.azure.resourcemanager.authorization.fluent.models.Get5ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLinkedResourceInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsTasksOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsTasksSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in UsersTodoListsTasksClient. */
public final class UsersTodoListsTasksClientImpl implements UsersTodoListsTasksClient {
    private final ClientLogger logger = new ClientLogger(UsersTodoListsTasksClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final UsersTodoListsTasksService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of UsersTodoListsTasksClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    UsersTodoListsTasksClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy.create(UsersTodoListsTasksService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientUsersTodoListsTasks to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface UsersTodoListsTasksService {
        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtension1>> listExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @BodyParam("application/json") MicrosoftGraphExtensionInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions/{extension-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @PathParam("extension-id") String extensionId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions/{extension-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @PathParam("extension-id") String extensionId,
            @BodyParam("application/json") MicrosoftGraphExtensionInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/extensions/{extension-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @PathParam("extension-id") String extensionId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinkedResource>> listLinkedResources(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphLinkedResourceInner>> createLinkedResources(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @BodyParam("application/json") MicrosoftGraphLinkedResourceInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources/{linkedResource-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphLinkedResourceInner>> getLinkedResources(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @PathParam("linkedResource-id") String linkedResourceId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources/{linkedResource-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateLinkedResources(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @PathParam("linkedResource-id") String linkedResourceId,
            @BodyParam("application/json") MicrosoftGraphLinkedResourceInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}/linkedResources/{linkedResource-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteLinkedResources(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @PathParam("linkedResource-id") String linkedResourceId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtension1>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinkedResource>> listLinkedResourcesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<String> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listExtensions(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            todoTaskId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphExtensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listExtensions(
                this.client.getEndpoint(),
                userId,
                todoTaskListId,
                todoTaskId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<String> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersTodoListsTasksOrderby> orderby = null;
        final List<String> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    userId,
                    todoTaskListId,
                    todoTaskId,
                    top,
                    skip,
                    search,
                    filter,
                    count,
                    orderby,
                    select,
                    expand,
                    context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(
        String userId, String todoTaskListId, String todoTaskId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersTodoListsTasksOrderby> orderby = null;
        final List<String> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listExtensionsAsync(
                userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listExtensionsAsync(
                userId,
                todoTaskListId,
                todoTaskId,
                top,
                skip,
                search,
                filter,
                count,
                orderby,
                select,
                expand,
                context));
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createExtensions(
                            this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createExtensions(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, accept, context);
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body) {
        return createExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, body)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner createExtensions(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body) {
        return createExtensionsAsync(userId, todoTaskListId, todoTaskId, body).block();
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body, Context context) {
        return createExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, body, context).block();
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        List<String> select,
        List<Get5ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getExtensions(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            todoTaskId,
                            extensionId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        List<String> select,
        List<Get5ItemsItem> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getExtensions(
                this.client.getEndpoint(),
                userId,
                todoTaskListId,
                todoTaskId,
                extensionId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        List<String> select,
        List<Get5ItemsItem> expand) {
        return getExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId) {
        final List<String> select = null;
        final List<Get5ItemsItem> expand = null;
        return getExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner getExtensions(
        String userId, String todoTaskListId, String todoTaskId, String extensionId) {
        final List<String> select = null;
        final List<Get5ItemsItem> expand = null;
        return getExtensionsAsync(userId, todoTaskListId, todoTaskId, extensionId, select, expand).block();
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        List<String> select,
        List<Get5ItemsItem> expand,
        Context context) {
        return getExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, select, expand, context)
            .block();
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateExtensions(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            todoTaskId,
                            extensionId,
                            body,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        MicrosoftGraphExtensionInner body,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateExtensions(
                this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, extensionId, body, accept, context);
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateExtensionsAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        MicrosoftGraphExtensionInner body) {
        return updateExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateExtensions(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        MicrosoftGraphExtensionInner body) {
        updateExtensionsAsync(userId, todoTaskListId, todoTaskId, extensionId, body).block();
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateExtensionsWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        MicrosoftGraphExtensionInner body,
        Context context) {
        return updateExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, body, context)
            .block();
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteExtensions(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            todoTaskId,
                            extensionId,
                            ifMatch,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteExtensions(
                this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, extensionId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch) {
        return deleteExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId) {
        final String ifMatch = null;
        return deleteExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteExtensions(String userId, String todoTaskListId, String todoTaskId, String extensionId) {
        final String ifMatch = null;
        deleteExtensionsAsync(userId, todoTaskListId, todoTaskId, extensionId, ifMatch).block();
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteExtensionsWithResponse(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch, Context context) {
        return deleteExtensionsWithResponseAsync(userId, todoTaskListId, todoTaskId, extensionId, ifMatch, context)
            .block();
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphLinkedResourceInner>> listLinkedResourcesSinglePageAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listLinkedResources(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            todoTaskId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphLinkedResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphLinkedResourceInner>> listLinkedResourcesSinglePageAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listLinkedResources(
                this.client.getEndpoint(),
                userId,
                todoTaskListId,
                todoTaskId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphLinkedResourceInner> listLinkedResourcesAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listLinkedResourcesSinglePageAsync(
                    userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listLinkedResourcesNextSinglePageAsync(nextLink));
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphLinkedResourceInner> listLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersTodoListsTasksOrderby> orderby = null;
        final List<UsersTodoListsTasksSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listLinkedResourcesSinglePageAsync(
                    userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listLinkedResourcesNextSinglePageAsync(nextLink));
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphLinkedResourceInner> listLinkedResourcesAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listLinkedResourcesSinglePageAsync(
                    userId,
                    todoTaskListId,
                    todoTaskId,
                    top,
                    skip,
                    search,
                    filter,
                    count,
                    orderby,
                    select,
                    expand,
                    context),
            nextLink -> listLinkedResourcesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphLinkedResourceInner> listLinkedResources(
        String userId, String todoTaskListId, String todoTaskId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersTodoListsTasksOrderby> orderby = null;
        final List<UsersTodoListsTasksSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listLinkedResourcesAsync(
                userId, todoTaskListId, todoTaskId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphLinkedResourceInner> listLinkedResources(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listLinkedResourcesAsync(
                userId,
                todoTaskListId,
                todoTaskId,
                top,
                skip,
                search,
                filter,
                count,
                orderby,
                select,
                expand,
                context));
    }

    /**
     * Create new navigation property to linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphLinkedResourceInner>> createLinkedResourcesWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createLinkedResources(
                            this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphLinkedResourceInner>> createLinkedResourcesWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        MicrosoftGraphLinkedResourceInner body,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createLinkedResources(
                this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, accept, context);
    }

    /**
     * Create new navigation property to linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphLinkedResourceInner> createLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body) {
        return createLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, body)
            .flatMap(
                (Response<MicrosoftGraphLinkedResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphLinkedResourceInner createLinkedResources(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body) {
        return createLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, body).block();
    }

    /**
     * Create new navigation property to linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphLinkedResourceInner> createLinkedResourcesWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        MicrosoftGraphLinkedResourceInner body,
        Context context) {
        return createLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, body, context).block();
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphLinkedResourceInner>> getLinkedResourcesWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getLinkedResources(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            todoTaskId,
                            linkedResourceId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphLinkedResourceInner>> getLinkedResourcesWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getLinkedResources(
                this.client.getEndpoint(),
                userId,
                todoTaskListId,
                todoTaskId,
                linkedResourceId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphLinkedResourceInner> getLinkedResourcesAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand) {
        return getLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphLinkedResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphLinkedResourceInner> getLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId) {
        final List<UsersTodoListsTasksSelect> select = null;
        final List<String> expand = null;
        return getLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphLinkedResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphLinkedResourceInner getLinkedResources(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId) {
        final List<UsersTodoListsTasksSelect> select = null;
        final List<String> expand = null;
        return getLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, select, expand).block();
    }

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphLinkedResourceInner> getLinkedResourcesWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand,
        Context context) {
        return getLinkedResourcesWithResponseAsync(
                userId, todoTaskListId, todoTaskId, linkedResourceId, select, expand, context)
            .block();
    }

    /**
     * Update the navigation property linkedResources in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateLinkedResourcesWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        MicrosoftGraphLinkedResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateLinkedResources(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            todoTaskId,
                            linkedResourceId,
                            body,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property linkedResources in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateLinkedResourcesWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        MicrosoftGraphLinkedResourceInner body,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateLinkedResources(
                this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, linkedResourceId, body, accept, context);
    }

    /**
     * Update the navigation property linkedResources in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateLinkedResourcesAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        MicrosoftGraphLinkedResourceInner body) {
        return updateLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property linkedResources in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateLinkedResources(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        MicrosoftGraphLinkedResourceInner body) {
        updateLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, body).block();
    }

    /**
     * Update the navigation property linkedResources in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateLinkedResourcesWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        MicrosoftGraphLinkedResourceInner body,
        Context context) {
        return updateLinkedResourcesWithResponseAsync(
                userId, todoTaskListId, todoTaskId, linkedResourceId, body, context)
            .block();
    }

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteLinkedResourcesWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteLinkedResources(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            todoTaskId,
                            linkedResourceId,
                            ifMatch,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteLinkedResourcesWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        String ifMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (linkedResourceId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter linkedResourceId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteLinkedResources(
                this.client.getEndpoint(),
                userId,
                todoTaskListId,
                todoTaskId,
                linkedResourceId,
                ifMatch,
                accept,
                context);
    }

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, String ifMatch) {
        return deleteLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId) {
        final String ifMatch = null;
        return deleteLinkedResourcesWithResponseAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteLinkedResources(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId) {
        final String ifMatch = null;
        deleteLinkedResourcesAsync(userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch).block();
    }

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteLinkedResourcesWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        String ifMatch,
        Context context) {
        return deleteLinkedResourcesWithResponseAsync(
                userId, todoTaskListId, todoTaskId, linkedResourceId, ifMatch, context)
            .block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphExtensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphLinkedResourceInner>> listLinkedResourcesNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listLinkedResourcesNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphLinkedResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphLinkedResourceInner>> listLinkedResourcesNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listLinkedResourcesNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
