// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersOutlooksClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfOutlookCategory;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOutlookCategoryInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersOutlookOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersOutlookSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in UsersOutlooksClient. */
public final class UsersOutlooksClientImpl implements UsersOutlooksClient {
    private final ClientLogger logger = new ClientLogger(UsersOutlooksClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final UsersOutlooksService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of UsersOutlooksClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    UsersOutlooksClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy.create(UsersOutlooksService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientUsersOutlooks to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface UsersOutlooksService {
        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/outlook/masterCategories")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfOutlookCategory>> listMasterCategories(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/users/{user-id}/outlook/masterCategories")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphOutlookCategoryInner>> createMasterCategories(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @BodyParam("application/json") MicrosoftGraphOutlookCategoryInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/outlook/masterCategories/{outlookCategory-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphOutlookCategoryInner>> getMasterCategories(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("outlookCategory-id") String outlookCategoryId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/users/{user-id}/outlook/masterCategories/{outlookCategory-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateMasterCategories(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("outlookCategory-id") String outlookCategoryId,
            @BodyParam("application/json") MicrosoftGraphOutlookCategoryInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/users/{user-id}/outlook/masterCategories/{outlookCategory-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteMasterCategories(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("outlookCategory-id") String outlookCategoryId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfOutlookCategory>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOutlookCategoryInner>> listMasterCategoriesSinglePageAsync(
        String userId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersOutlookOrderby> orderby,
        List<UsersOutlookSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listMasterCategories(
                            this.client.getEndpoint(),
                            userId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphOutlookCategoryInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOutlookCategoryInner>> listMasterCategoriesSinglePageAsync(
        String userId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersOutlookOrderby> orderby,
        List<UsersOutlookSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listMasterCategories(
                this.client.getEndpoint(),
                userId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOutlookCategoryInner> listMasterCategoriesAsync(
        String userId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersOutlookOrderby> orderby,
        List<UsersOutlookSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listMasterCategoriesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOutlookCategoryInner> listMasterCategoriesAsync(String userId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersOutlookOrderby> orderby = null;
        final List<UsersOutlookSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listMasterCategoriesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphOutlookCategoryInner> listMasterCategoriesAsync(
        String userId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersOutlookOrderby> orderby,
        List<UsersOutlookSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listMasterCategoriesSinglePageAsync(
                    userId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOutlookCategoryInner> listMasterCategories(String userId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersOutlookOrderby> orderby = null;
        final List<UsersOutlookSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listMasterCategoriesAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOutlookCategoryInner> listMasterCategories(
        String userId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersOutlookOrderby> orderby,
        List<UsersOutlookSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listMasterCategoriesAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to masterCategories for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOutlookCategoryInner>> createMasterCategoriesWithResponseAsync(
        String userId, MicrosoftGraphOutlookCategoryInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createMasterCategories(this.client.getEndpoint(), userId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to masterCategories for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOutlookCategoryInner>> createMasterCategoriesWithResponseAsync(
        String userId, MicrosoftGraphOutlookCategoryInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createMasterCategories(this.client.getEndpoint(), userId, body, accept, context);
    }

    /**
     * Create new navigation property to masterCategories for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphOutlookCategoryInner> createMasterCategoriesAsync(
        String userId, MicrosoftGraphOutlookCategoryInner body) {
        return createMasterCategoriesWithResponseAsync(userId, body)
            .flatMap(
                (Response<MicrosoftGraphOutlookCategoryInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to masterCategories for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphOutlookCategoryInner createMasterCategories(
        String userId, MicrosoftGraphOutlookCategoryInner body) {
        return createMasterCategoriesAsync(userId, body).block();
    }

    /**
     * Create new navigation property to masterCategories for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphOutlookCategoryInner> createMasterCategoriesWithResponse(
        String userId, MicrosoftGraphOutlookCategoryInner body, Context context) {
        return createMasterCategoriesWithResponseAsync(userId, body, context).block();
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOutlookCategoryInner>> getMasterCategoriesWithResponseAsync(
        String userId, String outlookCategoryId, List<UsersOutlookSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getMasterCategories(
                            this.client.getEndpoint(),
                            userId,
                            outlookCategoryId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOutlookCategoryInner>> getMasterCategoriesWithResponseAsync(
        String userId,
        String outlookCategoryId,
        List<UsersOutlookSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getMasterCategories(
                this.client.getEndpoint(),
                userId,
                outlookCategoryId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphOutlookCategoryInner> getMasterCategoriesAsync(
        String userId, String outlookCategoryId, List<UsersOutlookSelect> select, List<String> expand) {
        return getMasterCategoriesWithResponseAsync(userId, outlookCategoryId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphOutlookCategoryInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphOutlookCategoryInner> getMasterCategoriesAsync(String userId, String outlookCategoryId) {
        final List<UsersOutlookSelect> select = null;
        final List<String> expand = null;
        return getMasterCategoriesWithResponseAsync(userId, outlookCategoryId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphOutlookCategoryInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphOutlookCategoryInner getMasterCategories(String userId, String outlookCategoryId) {
        final List<UsersOutlookSelect> select = null;
        final List<String> expand = null;
        return getMasterCategoriesAsync(userId, outlookCategoryId, select, expand).block();
    }

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphOutlookCategoryInner> getMasterCategoriesWithResponse(
        String userId,
        String outlookCategoryId,
        List<UsersOutlookSelect> select,
        List<String> expand,
        Context context) {
        return getMasterCategoriesWithResponseAsync(userId, outlookCategoryId, select, expand, context).block();
    }

    /**
     * Update the navigation property masterCategories in users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateMasterCategoriesWithResponseAsync(
        String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateMasterCategories(
                            this.client.getEndpoint(), userId, outlookCategoryId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property masterCategories in users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateMasterCategoriesWithResponseAsync(
        String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateMasterCategories(this.client.getEndpoint(), userId, outlookCategoryId, body, accept, context);
    }

    /**
     * Update the navigation property masterCategories in users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateMasterCategoriesAsync(
        String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body) {
        return updateMasterCategoriesWithResponseAsync(userId, outlookCategoryId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property masterCategories in users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateMasterCategories(
        String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body) {
        updateMasterCategoriesAsync(userId, outlookCategoryId, body).block();
    }

    /**
     * Update the navigation property masterCategories in users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateMasterCategoriesWithResponse(
        String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body, Context context) {
        return updateMasterCategoriesWithResponseAsync(userId, outlookCategoryId, body, context).block();
    }

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteMasterCategoriesWithResponseAsync(
        String userId, String outlookCategoryId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteMasterCategories(
                            this.client.getEndpoint(), userId, outlookCategoryId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteMasterCategoriesWithResponseAsync(
        String userId, String outlookCategoryId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteMasterCategories(this.client.getEndpoint(), userId, outlookCategoryId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteMasterCategoriesAsync(String userId, String outlookCategoryId, String ifMatch) {
        return deleteMasterCategoriesWithResponseAsync(userId, outlookCategoryId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteMasterCategoriesAsync(String userId, String outlookCategoryId) {
        final String ifMatch = null;
        return deleteMasterCategoriesWithResponseAsync(userId, outlookCategoryId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteMasterCategories(String userId, String outlookCategoryId) {
        final String ifMatch = null;
        deleteMasterCategoriesAsync(userId, outlookCategoryId, ifMatch).block();
    }

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteMasterCategoriesWithResponse(
        String userId, String outlookCategoryId, String ifMatch, Context context) {
        return deleteMasterCategoriesWithResponseAsync(userId, outlookCategoryId, ifMatch, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOutlookCategoryInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphOutlookCategoryInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOutlookCategoryInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
