// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.SubscribedSkusSubscribedSkusClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfSubscribedSku;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSubscribedSkuInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.SubscribedSkusSubscribedSkuOrderby;
import com.azure.resourcemanager.authorization.fluent.models.SubscribedSkusSubscribedSkuSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in SubscribedSkusSubscribedSkusClient. */
public final class SubscribedSkusSubscribedSkusClientImpl implements SubscribedSkusSubscribedSkusClient {
    private final ClientLogger logger = new ClientLogger(SubscribedSkusSubscribedSkusClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final SubscribedSkusSubscribedSkusService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of SubscribedSkusSubscribedSkusClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    SubscribedSkusSubscribedSkusClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy
                .create(
                    SubscribedSkusSubscribedSkusService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientSubscribedSkusSubscribedSkus to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface SubscribedSkusSubscribedSkusService {
        @Headers({"Content-Type: application/json"})
        @Get("/subscribedSkus")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfSubscribedSku>> listSubscribedSku(
            @HostParam("$host") String endpoint,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/subscribedSkus")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphSubscribedSkuInner>> createSubscribedSku(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") MicrosoftGraphSubscribedSkuInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscribedSkus/{subscribedSku-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphSubscribedSkuInner>> getSubscribedSku(
            @HostParam("$host") String endpoint,
            @PathParam("subscribedSku-id") String subscribedSkuId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/subscribedSkus/{subscribedSku-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateSubscribedSku(
            @HostParam("$host") String endpoint,
            @PathParam("subscribedSku-id") String subscribedSkuId,
            @BodyParam("application/json") MicrosoftGraphSubscribedSkuInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/subscribedSkus/{subscribedSku-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteSubscribedSku(
            @HostParam("$host") String endpoint,
            @PathParam("subscribedSku-id") String subscribedSkuId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfSubscribedSku>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get entities from subscribedSkus.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphSubscribedSkuInner>> listSubscribedSkuSinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<SubscribedSkusSubscribedSkuOrderby> orderby,
        List<SubscribedSkusSubscribedSkuSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listSubscribedSku(
                            this.client.getEndpoint(),
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphSubscribedSkuInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entities from subscribedSkus.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphSubscribedSkuInner>> listSubscribedSkuSinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<SubscribedSkusSubscribedSkuOrderby> orderby,
        List<SubscribedSkusSubscribedSkuSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listSubscribedSku(
                this.client.getEndpoint(),
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get entities from subscribedSkus.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphSubscribedSkuInner> listSubscribedSkuAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<SubscribedSkusSubscribedSkuOrderby> orderby,
        List<SubscribedSkusSubscribedSkuSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () -> listSubscribedSkuSinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from subscribedSkus.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphSubscribedSkuInner> listSubscribedSkuAsync() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<SubscribedSkusSubscribedSkuOrderby> orderby = null;
        final List<SubscribedSkusSubscribedSkuSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () -> listSubscribedSkuSinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from subscribedSkus.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphSubscribedSkuInner> listSubscribedSkuAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<SubscribedSkusSubscribedSkuOrderby> orderby,
        List<SubscribedSkusSubscribedSkuSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () -> listSubscribedSkuSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get entities from subscribedSkus.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphSubscribedSkuInner> listSubscribedSku() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<SubscribedSkusSubscribedSkuOrderby> orderby = null;
        final List<SubscribedSkusSubscribedSkuSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(listSubscribedSkuAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get entities from subscribedSkus.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from subscribedSkus.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphSubscribedSkuInner> listSubscribedSku(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<SubscribedSkusSubscribedSkuOrderby> orderby,
        List<SubscribedSkusSubscribedSkuSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listSubscribedSkuAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Add new entity to subscribedSkus.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphSubscribedSkuInner>> createSubscribedSkuWithResponseAsync(
        MicrosoftGraphSubscribedSkuInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createSubscribedSku(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Add new entity to subscribedSkus.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphSubscribedSkuInner>> createSubscribedSkuWithResponseAsync(
        MicrosoftGraphSubscribedSkuInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createSubscribedSku(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Add new entity to subscribedSkus.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphSubscribedSkuInner> createSubscribedSkuAsync(MicrosoftGraphSubscribedSkuInner body) {
        return createSubscribedSkuWithResponseAsync(body)
            .flatMap(
                (Response<MicrosoftGraphSubscribedSkuInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Add new entity to subscribedSkus.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphSubscribedSkuInner createSubscribedSku(MicrosoftGraphSubscribedSkuInner body) {
        return createSubscribedSkuAsync(body).block();
    }

    /**
     * Add new entity to subscribedSkus.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphSubscribedSkuInner> createSubscribedSkuWithResponse(
        MicrosoftGraphSubscribedSkuInner body, Context context) {
        return createSubscribedSkuWithResponseAsync(body, context).block();
    }

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphSubscribedSkuInner>> getSubscribedSkuWithResponseAsync(
        String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getSubscribedSku(
                            this.client.getEndpoint(),
                            subscribedSkuId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphSubscribedSkuInner>> getSubscribedSkuWithResponseAsync(
        String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getSubscribedSku(
                this.client.getEndpoint(), subscribedSkuId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphSubscribedSkuInner> getSubscribedSkuAsync(
        String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand) {
        return getSubscribedSkuWithResponseAsync(subscribedSkuId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphSubscribedSkuInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphSubscribedSkuInner> getSubscribedSkuAsync(String subscribedSkuId) {
        final List<SubscribedSkusSubscribedSkuSelect> select = null;
        final List<String> expand = null;
        return getSubscribedSkuWithResponseAsync(subscribedSkuId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphSubscribedSkuInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphSubscribedSkuInner getSubscribedSku(String subscribedSkuId) {
        final List<SubscribedSkusSubscribedSkuSelect> select = null;
        final List<String> expand = null;
        return getSubscribedSkuAsync(subscribedSkuId, select, expand).block();
    }

    /**
     * Get entity from subscribedSkus by key.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from subscribedSkus by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphSubscribedSkuInner> getSubscribedSkuWithResponse(
        String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand, Context context) {
        return getSubscribedSkuWithResponseAsync(subscribedSkuId, select, expand, context).block();
    }

    /**
     * Update entity in subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateSubscribedSkuWithResponseAsync(
        String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.updateSubscribedSku(this.client.getEndpoint(), subscribedSkuId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update entity in subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscribedSkuWithResponseAsync(
        String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateSubscribedSku(this.client.getEndpoint(), subscribedSkuId, body, accept, context);
    }

    /**
     * Update entity in subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateSubscribedSkuAsync(String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body) {
        return updateSubscribedSkuWithResponseAsync(subscribedSkuId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update entity in subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateSubscribedSku(String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body) {
        updateSubscribedSkuAsync(subscribedSkuId, body).block();
    }

    /**
     * Update entity in subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateSubscribedSkuWithResponse(
        String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body, Context context) {
        return updateSubscribedSkuWithResponseAsync(subscribedSkuId, body, context).block();
    }

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSubscribedSkuWithResponseAsync(String subscribedSkuId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.deleteSubscribedSku(this.client.getEndpoint(), subscribedSkuId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteSubscribedSkuWithResponseAsync(
        String subscribedSkuId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteSubscribedSku(this.client.getEndpoint(), subscribedSkuId, ifMatch, accept, context);
    }

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSubscribedSkuAsync(String subscribedSkuId, String ifMatch) {
        return deleteSubscribedSkuWithResponseAsync(subscribedSkuId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSubscribedSkuAsync(String subscribedSkuId) {
        final String ifMatch = null;
        return deleteSubscribedSkuWithResponseAsync(subscribedSkuId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSubscribedSku(String subscribedSkuId) {
        final String ifMatch = null;
        deleteSubscribedSkuAsync(subscribedSkuId, ifMatch).block();
    }

    /**
     * Delete entity from subscribedSkus.
     *
     * @param subscribedSkuId key: id of subscribedSku.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteSubscribedSkuWithResponse(String subscribedSkuId, String ifMatch, Context context) {
        return deleteSubscribedSkuWithResponseAsync(subscribedSkuId, ifMatch, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphSubscribedSkuInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphSubscribedSkuInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of subscribedSku.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphSubscribedSkuInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
